/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.enchantment;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.enchantment.IInherentEngrave;
import com.github.manasmods.tensura.item.TensuraArmourMaterials;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class HolyCoatEnchantment
extends EngravingEnchantment
implements IInherentEngrave {
    public HolyCoatEnchantment() {
        super(Enchantment.Rarity.COMMON, EnchantmentCategory.BREAKABLE, EquipmentSlot.MAINHAND);
    }

    @Override
    public float getDamageBonus(int pLevel, DamageSource source, LivingEntity attacker, LivingEntity target, EquipmentSlot slot, float damage) {
        if (slot != EquipmentSlot.MAINHAND || source.m_7640_() != attacker) {
            return 0.0f;
        }
        if (RaceHelper.isAffectedByHolyCoat((Entity)target)) {
            return damage * 0.25f * (float)pLevel;
        }
        return 0.0f;
    }

    public int m_7205_(int pLevel, DamageSource pSource) {
        Entity entity = pSource.m_7640_();
        if (entity == null) {
            return 0;
        }
        if (!RaceHelper.isAffectedByHolyCoat(entity)) {
            return 0;
        }
        return pLevel * 4;
    }

    public static void applyHolyCoat(ItemStack toStack) {
        Item item = toStack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem item2 = (TieredItem)item;
            if (item2.m_43314_().equals(TensuraToolTiers.SILVER) && toStack.getEnchantmentLevel((Enchantment)TensuraEnchantments.HOLY_COAT.get()) < 1) {
                EngravingEnchantment.engrave(toStack, (Enchantment)TensuraEnchantments.HOLY_COAT.get(), 1);
            } else if (item2.m_43314_().equals(TensuraToolTiers.MITHRIL) && toStack.getEnchantmentLevel((Enchantment)TensuraEnchantments.HOLY_COAT.get()) < 1) {
                EngravingEnchantment.engrave(toStack, (Enchantment)TensuraEnchantments.HOLY_COAT.get(), 2);
            }
            return;
        }
        item = toStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem item3 = (ArmorItem)item;
            if (item3.m_40401_().equals((Object)TensuraArmourMaterials.SILVER) && toStack.getEnchantmentLevel((Enchantment)TensuraEnchantments.HOLY_COAT.get()) < 1) {
                EngravingEnchantment.engrave(toStack, (Enchantment)TensuraEnchantments.HOLY_COAT.get(), 1);
            } else if (item3.m_40401_().equals((Object)TensuraArmourMaterials.MITHRIL) && toStack.getEnchantmentLevel((Enchantment)TensuraEnchantments.HOLY_COAT.get()) < 1) {
                EngravingEnchantment.engrave(toStack, (Enchantment)TensuraEnchantments.HOLY_COAT.get(), 2);
            }
        }
    }
}

