/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.enchantment;

import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.enchantment.IInherentEngrave;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.items.TensuraArmorItems;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class ElementalResistanceEnchantment
extends EngravingEnchantment
implements IInherentEngrave {
    public ElementalResistanceEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEARABLE, EquipmentSlot.values());
    }

    public int m_6586_() {
        return 2;
    }

    @Override
    public float getDamageProtection(int pLevel, DamageSource source, LivingEntity wearer, EquipmentSlot slot, float damage) {
        if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) {
            return 0.0f;
        }
        if (DamageSourceHelper.isNaturalEffects(source)) {
            return 0.1f * (float)pLevel * damage;
        }
        return 0.0f;
    }

    public static void applyHolyEnchantments(ItemStack toStack) {
        if (toStack.m_204117_(TensuraTags.Items.HOLY_ARMAMENTS_ITEMS) && toStack.getEnchantmentLevel((Enchantment)TensuraEnchantments.ELEMENTAL_RESISTANCE.get()) < 1) {
            EngravingEnchantment.engrave(toStack, (Enchantment)TensuraEnchantments.ELEMENTAL_RESISTANCE.get(), 2);
            EngravingEnchantment.engrave(toStack, (Enchantment)TensuraEnchantments.ELEMENTAL_BOOST.get(), 2);
        }
    }

    @Override
    public boolean shouldHasFoil(ItemStack stack) {
        if (stack.m_150930_((Item)TensuraArmorItems.ANTI_MAGIC_MASK.get())) {
            return false;
        }
        return !stack.m_204117_(TensuraTags.Items.HOLY_ARMAMENTS_ITEMS);
    }
}

