/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.enchantment;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.ToolActions;

public class CrushingEnchantment
extends EngravingEnchantment {
    public CrushingEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND);
    }

    public float getDamageBonus(int level, MobType mobType, ItemStack enchantedItem) {
        float damage = 10.0f * (float)level;
        Item item = enchantedItem.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            damage = sword.m_43299_() * (float)level;
        }
        if ((item = enchantedItem.m_41720_()) instanceof DiggerItem) {
            DiggerItem digger = (DiggerItem)item;
            damage = digger.m_41008_() * (float)level;
        }
        return damage * 0.5f;
    }

    public void m_7677_(LivingEntity pAttacker, Entity pTarget, int pLevel) {
        if (!(pTarget instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)pTarget;
        int durabilityBreak = 5 * pLevel;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && !target.m_6844_(slot).canPerformAction(ToolActions.SHIELD_BLOCK)) continue;
            target.m_6844_(slot).m_41622_(durabilityBreak, target, living -> living.m_21166_(slot));
        }
    }
}

