/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.effect.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.effect.template.DamageAction;
import com.github.manasmods.tensura.effect.template.SkillMobEffect;
import com.github.manasmods.tensura.enchantment.SlottingEnchantment;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.util.damage.TensuraEntityDamageSource;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MagicAuraEffect
extends SkillMobEffect
implements DamageAction {
    public MagicAuraEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    @Override
    public void onPlayerAttack(Player attacker, Entity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)attacker);
        Optional optional = storage.getSkill((ManasSkill)ExtraSkills.MAGIC_AURA.get());
        if (optional.isEmpty()) {
            return;
        }
        ManasSkillInstance instance = (ManasSkillInstance)optional.get();
        ItemStack stack = attacker.m_21205_();
        if (SlottingEnchantment.getContentWeight(stack) > 0) {
            return;
        }
        float amount = SkillHelper.noCritAttackDamage(attacker, entity) * 1.5f;
        entity.m_6469_(this.auraSource(instance, (LivingEntity)attacker), amount);
        entity.f_19802_ = 0;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return false;
    }

    private DamageSource auraSource(ManasSkillInstance instance, LivingEntity attacker) {
        if (instance.getMode() == 1) {
            return TensuraDamageSources.genericMagic((Entity)attacker);
        }
        if (instance.getMode() == 2) {
            return TensuraDamageSources.holyDamage((Entity)attacker);
        }
        String element = switch (instance.getMode()) {
            case 3 -> "tensura.earth_attack";
            case 4 -> "tensura.fire_attack";
            case 5 -> "tensura.space_attack";
            case 6 -> "tensura.water_attack";
            default -> "tensura.wind_attack";
        };
        TensuraDamageSource damageSource = new TensuraEntityDamageSource(element, (Entity)attacker).setSkill(instance).setMpCost(1000.0).setNotTensuraMagic();
        if (instance.getMode() == 4) {
            return damageSource.m_19380_().m_19389_().m_19383_();
        }
        return damageSource.m_19380_().m_19389_();
    }
}

