/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.effect.skill;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.effect.template.DamageAction;
import com.github.manasmods.tensura.effect.template.SkillMobEffect;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;

public class LustDrainEffect
extends SkillMobEffect
implements DamageAction {
    public LustDrainEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity entity, int pAmplifier) {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get());
    }

    public boolean m_6584_(int pDuration, int amplifier) {
        return pDuration % 10 == 0;
    }

    @Override
    public void onPlayerAttack(Player source, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (SkillHelper.drainEnergy(target, (LivingEntity)source, 200.0, false)) {
            double percentage = 0.001 * (double)Objects.requireNonNull(source.m_21124_((MobEffect)this)).m_19564_();
            if (percentage > 0.0) {
                SkillHelper.drainEnergy(target, (LivingEntity)source, percentage, true);
            }
            TensuraPlayerCapability.getFrom(source).ifPresent(cap -> {
                if (cap.getAura() > source.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) {
                    cap.setAura(source.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()));
                }
                if (cap.getMagicule() > source.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get())) {
                    cap.setMagicule(source.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()));
                }
            });
            TensuraPlayerCapability.sync(source);
            source.m_9236_().m_6263_(null, source.m_20185_(), source.m_20186_(), source.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get());
        }
    }
}

