/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.effect;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.effect.template.TensuraMobEffect;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FearEffect
extends TensuraMobEffect {
    protected static final String FEAR_SPEED_UUID = "3e34a2f8-c55b-11ed-afa1-0242ac120002";

    public FearEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
        this.m_19472_(Attributes.f_22279_, FEAR_SPEED_UUID, -0.05f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void m_6742_(LivingEntity entity, int pAmplifier) {
        Player target;
        if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ResistanceSkills.ABNORMAL_CONDITION_RESISTANCE.get())) {
            pAmplifier -= 2;
        }
        if (pAmplifier < 4) {
            return;
        }
        Player source = TensuraEffectsCapability.getEffectSource(entity, this);
        if (source != null && entity instanceof Player && (target = (Player)entity).m_20270_((Entity)source) < 7.0f) {
            target.m_6469_(TensuraDamageSources.insanity((Entity)source), (float)(2 * (pAmplifier - 3)));
        }
        if (pAmplifier < 9) {
            return;
        }
        float damage = 3 * (pAmplifier - 8);
        if (source == null) {
            entity.m_6469_(TensuraDamageSources.FEAR, damage);
        } else {
            entity.m_6469_(TensuraDamageSources.fear((Entity)source), damage);
            if (entity.m_6084_() || !(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            if (!this.usingDemonLordHaki(source)) {
                return;
            }
            RaceHelper.applyMajinChance(player);
        }
    }

    public double m_7048_(int pAmplifier, AttributeModifier pModifier) {
        if (pAmplifier <= 0) {
            return 0.0;
        }
        return pModifier.m_22218_() * (double)(pAmplifier + 1);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration % 40 == 0;
    }

    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }

    private boolean usingDemonLordHaki(Player source) {
        if (TensuraSkillCapability.isSkillInSlot((LivingEntity)source, (ManasSkill)UniqueSkills.VILLAIN.get())) {
            Optional optional = SkillAPI.getSkillsFrom((Entity)source).getSkill((ManasSkill)UniqueSkills.VILLAIN.get());
            if (optional.isEmpty()) {
                return false;
            }
            if (((ManasSkillInstance)optional.get()).getMode() == 1) {
                return true;
            }
        }
        return TensuraSkillCapability.isSkillInSlot((LivingEntity)source, (ManasSkill)ExtraSkills.DEMON_LORD_HAKI.get());
    }

    public static void onClientTick(Player player, float soundVolume) {
        int interval;
        MobEffectInstance fear = player.m_21124_((MobEffect)TensuraMobEffects.FEAR.get());
        if (fear == null) {
            return;
        }
        int n = interval = fear.m_19564_() >= 2 ? 4 : 14;
        if (player.f_19797_ % interval == 0) {
            FearEffect.playHeartbeatSound(player, soundVolume, interval == 14);
        }
        Minecraft.m_91087_().f_91065_.m_93067_((Entity)player);
    }

    public static void playHeartbeatSound(Player player, float volume, boolean longer) {
        if (!player.m_21023_((MobEffect)TensuraMobEffects.FEAR.get())) {
            return;
        }
        player.m_6330_(longer ? (SoundEvent)TensuraSoundEvents.HEARTBEAT2.get() : (SoundEvent)TensuraSoundEvents.HEARTBEAT1.get(), SoundSource.PLAYERS, volume, 1.0f);
    }
}

