/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.data.recipe;

import com.github.manasmods.manascore.api.util.ItemComparator;
import com.github.manasmods.tensura.capability.smithing.SmithingCapability;
import com.github.manasmods.tensura.item.templates.SimpleSwordItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleGreatSwordItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleKatanaItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleKodachiItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleLongSwordItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleOdachiItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleShortSwordItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleSickleItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleSpearItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleTachiItem;
import com.github.manasmods.tensura.registry.recipe.TensuraRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SmithingBenchRecipe
implements Recipe<Container>,
Comparator<SmithingBenchRecipe> {
    public static final ItemComparator<Item> SMITHING_BENCH_RECIPE_COMPARATOR = ItemComparator.Builder.firstInstancesOf(SimpleSwordItem.class).thenInstancesOf(SwordItem.class).then((item, item2) -> {
        if (item instanceof SwordItem) {
            SwordItem sword1 = (SwordItem)item;
            if (item2 instanceof SwordItem) {
                SwordItem sword2 = (SwordItem)item2;
                if (sword1.getClass() == SwordItem.class && sword2.getClass() != SwordItem.class) {
                    return -1;
                }
                if (sword1.getClass() != SwordItem.class && sword2.getClass() == SwordItem.class) {
                    return 1;
                }
            }
        }
        return 0;
    }).thenInstancesOf(SimpleShortSwordItem.class).thenInstancesOf(SimpleLongSwordItem.class).thenInstancesOf(SimpleGreatSwordItem.class).thenInstancesOf(SimpleKatanaItem.class).thenInstancesOf(SimpleKodachiItem.class).thenInstancesOf(SimpleTachiItem.class).thenInstancesOf(SimpleOdachiItem.class).thenInstancesOf(SimpleSpearItem.class).thenInstancesOf(PickaxeItem.class).thenInstancesOf(AxeItem.class).thenInstancesOf(ShovelItem.class).thenInstancesOf(HoeItem.class).thenInstancesOf(SimpleSickleItem.class).thenInstancesOf(TieredItem.class).thenInstancesOf(ArmorItem.class).then((item, item2) -> {
        if (item instanceof ArmorItem) {
            ArmorItem armor1 = (ArmorItem)item;
            if (item2 instanceof ArmorItem) {
                ArmorItem armor2 = (ArmorItem)item2;
                return armor2.m_40402_().compareTo((Enum)armor1.m_40402_());
            }
        }
        return 0;
    }).build();
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient ingredient1;
    private final Ingredient ingredient2;
    private final Ingredient ingredient3;
    private final Ingredient ingredient4;
    private final Ingredient ingredient5;
    private final int amount1;
    private final int amount2;
    private final int amount3;
    private final int amount4;
    private final int amount5;
    private final List<ResourceLocation> requiredSchematics;

    public SmithingBenchRecipe(ResourceLocation pRecipeId, ItemStack result, List<ResourceLocation> requiredSchematics, List<Ingredient> ingredientList, List<Integer> amountList) {
        this.id = pRecipeId;
        this.output = result;
        this.requiredSchematics = requiredSchematics;
        int i = 0;
        if (ingredientList.size() > i) {
            this.ingredient1 = ingredientList.get(i);
            this.amount1 = amountList.get(i);
            ++i;
        } else {
            this.ingredient1 = Ingredient.f_43901_;
            this.amount1 = 0;
        }
        if (ingredientList.size() > i) {
            this.ingredient2 = ingredientList.get(i);
            this.amount2 = amountList.get(i);
            ++i;
        } else {
            this.ingredient2 = Ingredient.f_43901_;
            this.amount2 = 0;
        }
        if (ingredientList.size() > i) {
            this.ingredient3 = ingredientList.get(i);
            this.amount3 = amountList.get(i);
            ++i;
        } else {
            this.ingredient3 = Ingredient.f_43901_;
            this.amount3 = 0;
        }
        if (ingredientList.size() > i) {
            this.ingredient4 = ingredientList.get(i);
            this.amount4 = amountList.get(i);
            ++i;
        } else {
            this.ingredient4 = Ingredient.f_43901_;
            this.amount4 = 0;
        }
        if (ingredientList.size() > i) {
            this.ingredient5 = ingredientList.get(i);
            this.amount5 = amountList.get(i);
        } else {
            this.ingredient5 = Ingredient.f_43901_;
            this.amount5 = 0;
        }
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.hasEnough(pContainer, this.ingredient1, this.amount1) && this.hasEnough(pContainer, this.ingredient2, this.amount2) && this.hasEnough(pContainer, this.ingredient3, this.amount3) && this.hasEnough(pContainer, this.ingredient4, this.amount4) && this.hasEnough(pContainer, this.ingredient5, this.amount5);
    }

    private boolean hasEnough(Container container, Ingredient ingredient, int amount) {
        if (ingredient.m_43947_()) {
            return true;
        }
        int remainingAmount = amount;
        if (remainingAmount <= 0) {
            return true;
        }
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (!ingredient.test(item)) continue;
            remainingAmount -= item.m_41613_();
        }
        return remainingAmount <= 0;
    }

    public boolean hasUnlocked(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        return SmithingCapability.getFrom(player).map(data -> data.hasSchematics(this.requiredSchematics)).orElse(false);
    }

    public ItemStack m_5874_(Container pContainer) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TensuraRecipeTypes.Serializer.SMITHING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TensuraRecipeTypes.SMITHING.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient1, this.ingredient2, this.ingredient3, this.ingredient4, this.ingredient5});
    }

    public NonNullList<Integer> getIngedientAmount() {
        return NonNullList.m_122783_((Object)0, (Object[])new Integer[]{this.amount1, this.amount2, this.amount3, this.amount4, this.amount5});
    }

    public FinishedRecipe finishedRecipe() {
        return new FinishedRecipe(){

            public void m_7917_(JsonObject root) {
                JsonArray ingredients = new JsonArray();
                this.addIngredient(ingredients, SmithingBenchRecipe.this.ingredient1, SmithingBenchRecipe.this.amount1);
                this.addIngredient(ingredients, SmithingBenchRecipe.this.ingredient2, SmithingBenchRecipe.this.amount2);
                this.addIngredient(ingredients, SmithingBenchRecipe.this.ingredient3, SmithingBenchRecipe.this.amount3);
                this.addIngredient(ingredients, SmithingBenchRecipe.this.ingredient4, SmithingBenchRecipe.this.amount4);
                this.addIngredient(ingredients, SmithingBenchRecipe.this.ingredient5, SmithingBenchRecipe.this.amount5);
                root.add("ingredients", (JsonElement)ingredients);
                root.add("result", (JsonElement)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SmithingBenchRecipe.this.output).result().orElseThrow(() -> new IllegalArgumentException("Could not serialize ItemStack: " + SmithingBenchRecipe.this.output)));
                this.addRequiredSchematics(root);
            }

            private void addRequiredSchematics(JsonObject root) {
                JsonArray data = new JsonArray();
                SmithingBenchRecipe.this.requiredSchematics.forEach(schematic -> data.add(schematic.toString()));
                root.add("schematics", (JsonElement)data);
            }

            private void addIngredient(JsonArray ingredients, Ingredient ingredient, int amount) {
                if (ingredient.m_43947_()) {
                    return;
                }
                JsonObject root = new JsonObject();
                root.add("type", ingredient.m_43942_());
                if (amount > 1) {
                    root.addProperty("amount", (Number)amount);
                }
                ingredients.add((JsonElement)root);
            }

            public ResourceLocation m_6445_() {
                return SmithingBenchRecipe.this.id;
            }

            public RecipeSerializer<?> m_6637_() {
                return SmithingBenchRecipe.this.m_7707_();
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        };
    }

    @Override
    public int compare(SmithingBenchRecipe o1, SmithingBenchRecipe o2) {
        Item result1 = o1.m_8043_().m_41720_();
        Item result2 = o2.m_8043_().m_41720_();
        List<ResourceLocation> repairItems1 = this.getRepairItemsOf(result1);
        List<ResourceLocation> repairItems2 = this.getRepairItemsOf(result2);
        if (!repairItems1.isEmpty() && repairItems1.contains(ForgeRegistries.ITEMS.getKey((Object)result2))) {
            return 1;
        }
        if (!repairItems2.isEmpty() && repairItems2.contains(ForgeRegistries.ITEMS.getKey((Object)result1))) {
            return -1;
        }
        return ForgeRegistries.ITEMS.getKey((Object)result1).m_135815_().compareTo(ForgeRegistries.ITEMS.getKey((Object)result2).m_135815_());
    }

    private List<ResourceLocation> getRepairItemsOf(Item item) {
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return Arrays.stream(tieredItem.m_43314_().m_6282_().m_43908_()).map(ItemStack::m_41720_).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)).filter(Objects::nonNull).toList();
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return Arrays.stream(armorItem.m_40401_().m_6230_().m_43908_()).map(ItemStack::m_41720_).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)).filter(Objects::nonNull).toList();
        }
        return List.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmithingBenchRecipe recipe = (SmithingBenchRecipe)o;
        return this.id.equals((Object)recipe.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public void takeItemsFrom(Container container) {
        for (int i = 0; i < 5; ++i) {
            Ingredient ingredient = (Ingredient)this.m_7527_().get(i);
            if (ingredient.m_43947_()) continue;
            int amount = (Integer)this.getIngedientAmount().get(i);
            if (amount == 0) break;
            for (int j = 0; j < container.m_6643_(); ++j) {
                ItemStack inventoryStack = container.m_8020_(j);
                if (inventoryStack.m_41619_() || !ingredient.test(inventoryStack)) continue;
                if (amount - inventoryStack.m_41613_() < 0) {
                    inventoryStack.m_41774_(amount);
                    amount = 0;
                    continue;
                }
                amount -= inventoryStack.m_41613_();
                inventoryStack.m_41764_(0);
            }
        }
    }

    public SmithingBenchRecipe(ResourceLocation id, ItemStack output, Ingredient ingredient1, Ingredient ingredient2, Ingredient ingredient3, Ingredient ingredient4, Ingredient ingredient5, int amount1, int amount2, int amount3, int amount4, int amount5, List<ResourceLocation> requiredSchematics) {
        this.id = id;
        this.output = output;
        this.ingredient1 = ingredient1;
        this.ingredient2 = ingredient2;
        this.ingredient3 = ingredient3;
        this.ingredient4 = ingredient4;
        this.ingredient5 = ingredient5;
        this.amount1 = amount1;
        this.amount2 = amount2;
        this.amount3 = amount3;
        this.amount4 = amount4;
        this.amount5 = amount5;
        this.requiredSchematics = requiredSchematics;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Builder {
        private final ItemStack result;
        private final List<ResourceLocation> schematics = new ArrayList<ResourceLocation>();
        private final NonNullList<Pair<Ingredient, Integer>> ingredientMap = NonNullList.m_122780_((int)5, (Object)Pair.of((Object)Ingredient.f_43901_, (Object)0));
        private int ingredientAmount = 0;

        public static Builder of(Item result, int amount) {
            return Builder.of(new ItemStack((ItemLike)result, amount));
        }

        public static Builder of(Item result) {
            return Builder.of(result.m_7968_());
        }

        public static Builder of(Supplier<? extends Item> result) {
            return Builder.of(result.get());
        }

        public Builder addIngredient(Ingredient ingredient, int amount) {
            if (this.ingredientAmount + 1 > 5) {
                throw new IllegalStateException("SmithingBenchRecipes only allow up to 5 ingredient");
            }
            this.ingredientMap.set(this.ingredientAmount++, (Object)Pair.of((Object)ingredient, (Object)amount));
            return this;
        }

        public Builder addIngredient(ItemStack stack) {
            return this.addIngredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), stack.m_41613_());
        }

        public Builder addIngredient(TagKey<Item> itemTagKey, int amount) {
            return this.addIngredient(Ingredient.m_204132_(itemTagKey), amount);
        }

        public Builder addIngredient(Supplier<? extends Item> item, int amount) {
            return this.addIngredient(item.get(), amount);
        }

        public Builder addIngredient(Item item, int amount) {
            return this.addIngredient(new ItemStack((ItemLike)item, amount));
        }

        public Builder addIngredient(Item item) {
            return this.addIngredient(item, 1);
        }

        public Builder requiresSchematic(ResourceLocation schematic) {
            this.schematics.add(schematic);
            return this;
        }

        public Builder requiresSchematic(Supplier<? extends Item> schematic) {
            return this.requiresSchematic(schematic.get());
        }

        public Builder requiresSchematic(Item schematic) {
            return this.requiresSchematic(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)schematic)));
        }

        public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (this.ingredientAmount == 0) {
                throw new IllegalStateException(String.format("Recipe %s need at least 1 ingredient", id));
            }
            consumer.accept(new SmithingBenchRecipe(new ResourceLocation(id.m_135827_(), "smithing/" + id.m_135815_()), this.result, (Ingredient)((Pair)this.ingredientMap.get(0)).getFirst(), (Ingredient)((Pair)this.ingredientMap.get(1)).getFirst(), (Ingredient)((Pair)this.ingredientMap.get(2)).getFirst(), (Ingredient)((Pair)this.ingredientMap.get(3)).getFirst(), (Ingredient)((Pair)this.ingredientMap.get(4)).getFirst(), (Integer)((Pair)this.ingredientMap.get(0)).getSecond(), (Integer)((Pair)this.ingredientMap.get(1)).getSecond(), (Integer)((Pair)this.ingredientMap.get(2)).getSecond(), (Integer)((Pair)this.ingredientMap.get(3)).getSecond(), (Integer)((Pair)this.ingredientMap.get(4)).getSecond(), this.schematics.stream().distinct().toList()).finishedRecipe());
        }

        public void build(Consumer<FinishedRecipe> consumer) {
            this.build(consumer, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_())));
        }

        private Builder(ItemStack result) {
            this.result = result;
        }

        public static Builder of(ItemStack result) {
            return new Builder(result);
        }
    }

    public static class Type
    implements RecipeType<SmithingBenchRecipe> {
    }

    public static class Serializer
    implements RecipeSerializer<SmithingBenchRecipe> {
        private static final Logger log = LogManager.getLogger(Serializer.class);

        public SmithingBenchRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            JsonArray ingredients = pSerializedRecipe.getAsJsonArray("ingredients");
            ItemStack result = (ItemStack)((Pair)ItemStack.f_41582_.decode((DynamicOps)JsonOps.INSTANCE, (Object)pSerializedRecipe.get("result")).result().orElseThrow(() -> new IllegalArgumentException("Could not load result ItemStack from: " + pRecipeId))).getFirst();
            JsonArray schematics = pSerializedRecipe.getAsJsonArray("schematics");
            ArrayList<ResourceLocation> requiredSchematics = new ArrayList<ResourceLocation>();
            schematics.forEach(jsonElement -> requiredSchematics.add(ResourceLocation.m_135820_((String)jsonElement.getAsString())));
            if (ingredients.size() > 5) {
                log.fatal("Failed to load recipe {}. Too many Ingredients", (Object)pRecipeId);
                return null;
            }
            if (ingredients.isEmpty()) {
                log.fatal("Failed to load recipe {}. No ingredients found", (Object)pRecipeId);
                return null;
            }
            ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>(5);
            ArrayList<Integer> amountList = new ArrayList<Integer>(5);
            ingredients.forEach(jsonElement -> {
                JsonObject root = jsonElement.getAsJsonObject();
                ingredientList.add(Ingredient.m_43917_((JsonElement)root.get("type")));
                if (root.has("amount")) {
                    amountList.add(root.get("amount").getAsInt());
                } else {
                    amountList.add(1);
                }
            });
            return new SmithingBenchRecipe(pRecipeId, result, requiredSchematics, ingredientList, amountList);
        }

        @Nullable
        public SmithingBenchRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            return new SmithingBenchRecipe(pRecipeId, pBuffer.m_130267_(), Ingredient.m_43940_((FriendlyByteBuf)pBuffer), Ingredient.m_43940_((FriendlyByteBuf)pBuffer), Ingredient.m_43940_((FriendlyByteBuf)pBuffer), Ingredient.m_43940_((FriendlyByteBuf)pBuffer), Ingredient.m_43940_((FriendlyByteBuf)pBuffer), pBuffer.readInt(), pBuffer.readInt(), pBuffer.readInt(), pBuffer.readInt(), pBuffer.readInt(), pBuffer.m_236845_(FriendlyByteBuf::m_130281_));
        }

        public void toNetwork(FriendlyByteBuf pBuffer, SmithingBenchRecipe pRecipe) {
            pBuffer.writeItemStack(pRecipe.m_8043_(), false);
            pRecipe.ingredient1.m_43923_(pBuffer);
            pRecipe.ingredient2.m_43923_(pBuffer);
            pRecipe.ingredient3.m_43923_(pBuffer);
            pRecipe.ingredient4.m_43923_(pBuffer);
            pRecipe.ingredient5.m_43923_(pBuffer);
            pBuffer.writeInt(pRecipe.amount1);
            pBuffer.writeInt(pRecipe.amount2);
            pBuffer.writeInt(pRecipe.amount3);
            pBuffer.writeInt(pRecipe.amount4);
            pBuffer.writeInt(pRecipe.amount5);
            pBuffer.m_236828_(pRecipe.requiredSchematics, FriendlyByteBuf::m_130085_);
        }
    }
}

