/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.data.recipe;

import com.github.manasmods.tensura.block.entity.KilnBlockEntity;
import com.github.manasmods.tensura.data.recipe.KilnRecipe;
import com.github.manasmods.tensura.registry.recipe.TensuraRecipeTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KilnMixingRecipe
extends KilnRecipe
implements Comparable<KilnMixingRecipe> {
    private static final Logger log = LogManager.getLogger(KilnMixingRecipe.class);
    public static final ResourceLocation EMPTY = new ResourceLocation("minecraft:air");
    private final ResourceLocation id;
    private final ResourceLocation leftInput;
    private final int leftInputAmount;
    private final ResourceLocation rightInput;
    private final int rightInputAmount;
    private final ItemStack output;

    public boolean matches(KilnBlockEntity pContainer, Level pLevel) {
        if (!this.leftInput.equals((Object)EMPTY)) {
            if (pContainer.getLeftBarId().isEmpty() || pContainer.getLeftBarId().get().equals((Object)EMPTY)) {
                return false;
            }
            if (!pContainer.getLeftBarId().get().equals((Object)this.leftInput)) {
                return false;
            }
            if (pContainer.getMoltenAmount() < this.leftInputAmount) {
                return false;
            }
        }
        if (!this.rightInput.equals((Object)EMPTY)) {
            if (pContainer.getRightBarId().isEmpty() || pContainer.getRightBarId().get().equals((Object)EMPTY)) {
                return false;
            }
            if (!pContainer.getRightBarId().get().equals((Object)this.rightInput)) {
                return false;
            }
            return pContainer.getMagicMaterialAmount() >= this.rightInputAmount;
        }
        return true;
    }

    public ItemStack assemble(KilnBlockEntity pContainer) {
        return this.m_8043_();
    }

    @Override
    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    @Override
    public FinishedRecipe finishRecipe() {
        return new FinishedRecipe(){

            public void m_7917_(JsonObject root) {
                JsonObject input;
                if (!KilnMixingRecipe.this.getLeftInput().equals((Object)EMPTY)) {
                    input = new JsonObject();
                    input.addProperty("moltenType", KilnMixingRecipe.this.leftInput.toString());
                    input.addProperty("amount", (Number)KilnMixingRecipe.this.leftInputAmount);
                    root.add("inputLeft", (JsonElement)input);
                }
                if (!KilnMixingRecipe.this.getRightInput().equals((Object)EMPTY)) {
                    input = new JsonObject();
                    input.addProperty("moltenType", KilnMixingRecipe.this.rightInput.toString());
                    input.addProperty("amount", (Number)KilnMixingRecipe.this.rightInputAmount);
                    root.add("inputRight", (JsonElement)input);
                }
                root.add("result", (JsonElement)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)KilnMixingRecipe.this.output).result().orElseThrow(() -> new IllegalArgumentException("Could not serialize ItemStack: " + KilnMixingRecipe.this.output)));
            }

            public ResourceLocation m_6445_() {
                return KilnMixingRecipe.this.id;
            }

            public RecipeSerializer<?> m_6637_() {
                return KilnMixingRecipe.this.m_7707_();
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        };
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TensuraRecipeTypes.Serializer.KILN_MIXING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TensuraRecipeTypes.KILN_MIXING.get();
    }

    @Override
    public int compareTo(@NotNull KilnMixingRecipe o) {
        int inputAmountLeft = Integer.compare(this.rightInputAmount, o.rightInputAmount);
        if (inputAmountLeft != 0) {
            return inputAmountLeft;
        }
        return Integer.compare(this.leftInputAmount, o.leftInputAmount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KilnMixingRecipe recipe = (KilnMixingRecipe)o;
        if (!this.id.equals((Object)recipe.id)) {
            return false;
        }
        if (this.leftInputAmount != recipe.leftInputAmount) {
            return false;
        }
        if (this.rightInputAmount != recipe.rightInputAmount) {
            return false;
        }
        return this.leftInput.equals((Object)recipe.leftInput) && this.rightInput.equals((Object)recipe.rightInput) && this.output.equals(recipe.output, false);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.leftInput, this.leftInputAmount, this.rightInput, this.rightInputAmount, this.output);
    }

    public KilnMixingRecipe(ResourceLocation id, ResourceLocation leftInput, int leftInputAmount, ResourceLocation rightInput, int rightInputAmount, ItemStack output) {
        this.id = id;
        this.leftInput = leftInput;
        this.leftInputAmount = leftInputAmount;
        this.rightInput = rightInput;
        this.rightInputAmount = rightInputAmount;
        this.output = output;
    }

    public String toString() {
        return "KilnMixingRecipe(id=" + this.m_6423_() + ", leftInput=" + this.getLeftInput() + ", leftInputAmount=" + this.getLeftInputAmount() + ", rightInput=" + this.getRightInput() + ", rightInputAmount=" + this.getRightInputAmount() + ", output=" + this.getOutput() + ")";
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ResourceLocation getLeftInput() {
        return this.leftInput;
    }

    public int getLeftInputAmount() {
        return this.leftInputAmount;
    }

    public ResourceLocation getRightInput() {
        return this.rightInput;
    }

    public int getRightInputAmount() {
        return this.rightInputAmount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public static class Builder {
        private final ItemStack output;
        private ResourceLocation leftInput = EMPTY;
        private int leftAmount = 0;
        private ResourceLocation rightInput = EMPTY;
        private int rightAmount = 0;

        public Builder leftInput(ResourceLocation moltenType, int amount) {
            this.leftInput = moltenType;
            this.leftAmount = amount;
            return this;
        }

        public Builder rightInput(ResourceLocation moltenType, int amount) {
            this.rightInput = moltenType;
            this.rightAmount = amount;
            return this;
        }

        public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            consumer.accept(new KilnMixingRecipe(new ResourceLocation(id.m_135827_(), "mixing/" + id.m_135815_()), this.leftInput, this.leftAmount, this.rightInput, this.rightAmount, this.output).finishRecipe());
        }

        public void build(Consumer<FinishedRecipe> consumer) {
            this.build(consumer, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_())));
        }

        public static Builder of(Item item) {
            return Builder.of(item.m_7968_());
        }

        public static Builder of(Supplier<? extends Item> item) {
            return Builder.of(item.get());
        }

        private Builder(ItemStack output) {
            this.output = output;
        }

        public static Builder of(ItemStack output) {
            return new Builder(output);
        }
    }

    public static class Type
    implements RecipeType<KilnMixingRecipe> {
    }

    public static class Serializer
    implements RecipeSerializer<KilnMixingRecipe> {
        public KilnMixingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ResourceLocation inputLeft = EMPTY;
            int inputLeftAmount = 0;
            if (pSerializedRecipe.has("inputLeft")) {
                JsonObject inputLeftRoot = pSerializedRecipe.getAsJsonObject("inputLeft");
                inputLeft = ResourceLocation.m_135820_((String)inputLeftRoot.get("moltenType").getAsString());
                inputLeftAmount = inputLeftRoot.get("amount").getAsInt();
            }
            ResourceLocation inputRight = EMPTY;
            int inputRightAmount = 0;
            if (pSerializedRecipe.has("inputRight")) {
                JsonObject inputLeftRoot = pSerializedRecipe.getAsJsonObject("inputRight");
                inputRight = ResourceLocation.m_135820_((String)inputLeftRoot.get("moltenType").getAsString());
                inputRightAmount = inputLeftRoot.get("amount").getAsInt();
            }
            ItemStack output = (ItemStack)((Pair)ItemStack.f_41582_.decode((DynamicOps)JsonOps.INSTANCE, (Object)pSerializedRecipe.get("result")).result().orElseThrow(() -> new IllegalArgumentException("Could not load result ItemStack from: " + pRecipeId))).getFirst();
            return new KilnMixingRecipe(pRecipeId, inputLeft, inputLeftAmount, inputRight, inputRightAmount, output);
        }

        @Nullable
        public KilnMixingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            return new KilnMixingRecipe(pRecipeId, pBuffer.m_130281_(), pBuffer.readInt(), pBuffer.m_130281_(), pBuffer.readInt(), pBuffer.m_130267_());
        }

        public void toNetwork(FriendlyByteBuf pBuffer, KilnMixingRecipe pRecipe) {
            pBuffer.m_130085_(pRecipe.leftInput);
            pBuffer.writeInt(pRecipe.leftInputAmount);
            pBuffer.m_130085_(pRecipe.rightInput);
            pBuffer.writeInt(pRecipe.rightInputAmount);
            pBuffer.writeItemStack(pRecipe.output, false);
        }
    }
}

