/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.data.pack;

import com.github.manasmods.tensura.api.magicule.MagiculeModifier;
import com.github.manasmods.tensura.data.pack.DataPackMagiculeModifier;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public record LevelMagiculeModifier(ResourceLocation worldId, int priority, List<DataPackMagiculeModifier> modifiers, List<DataPackMagiculeModifier> regenModifiers) implements MagiculeModifier
{
    public static final Codec<LevelMagiculeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("world").forGetter(LevelMagiculeModifier::worldId), (App)Codec.intRange((int)0, (int)255).optionalFieldOf("priority", (Object)0).forGetter(LevelMagiculeModifier::priority), (App)DataPackMagiculeModifier.CODEC.listOf().optionalFieldOf("modifiers", new ArrayList()).forGetter(LevelMagiculeModifier::modifiers), (App)DataPackMagiculeModifier.CODEC.listOf().optionalFieldOf("regen_modifiers", new ArrayList()).forGetter(LevelMagiculeModifier::regenModifiers)).apply((Applicative)instance, LevelMagiculeModifier::new));

    @Override
    public double getMaxMagicule(double oldMaxMagicule) {
        for (DataPackMagiculeModifier modifier : this.modifiers) {
            switch (modifier.mode()) {
                case ADD: {
                    oldMaxMagicule += modifier.value();
                    break;
                }
                case MULTIPLY: {
                    oldMaxMagicule *= modifier.value();
                }
            }
        }
        return oldMaxMagicule;
    }

    @Override
    public double getRegenerationRate(double oldRegenerationRate) {
        for (DataPackMagiculeModifier modifier : this.regenModifiers) {
            switch (modifier.mode()) {
                case ADD: {
                    oldRegenerationRate += modifier.value();
                    break;
                }
                case MULTIPLY: {
                    oldRegenerationRate *= modifier.value();
                }
            }
        }
        return oldRegenerationRate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void buildJson(BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        consumer.accept(this.worldId, () -> (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElseThrow(() -> new IllegalStateException("Could not serialize " + this)));
    }
}

