/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.data.gen;

import com.github.manasmods.manascore.api.data.gen.CustomDataProvider;
import com.github.manasmods.tensura.data.pack.BiomeMagiculeModifier;
import com.github.manasmods.tensura.data.pack.DataPackMagiculeModifier;
import com.github.manasmods.tensura.registry.biome.TensuraBiomes;
import com.github.manasmods.tensura.registry.magicule.TensuraBiomeMagiculeModifier;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class TensuraBiomeMagiculeModifiersProvider
extends CustomDataProvider {
    public TensuraBiomeMagiculeModifiersProvider(GatherDataEvent gatherDataEvent) {
        super(String.format("%s/%s", TensuraBiomeMagiculeModifier.REGISTRY_KEY.m_135782_().m_135827_(), TensuraBiomeMagiculeModifier.REGISTRY_KEY.m_135782_().m_135815_()), gatherDataEvent.getGenerator());
    }

    public String m_6055_() {
        return "Tensura biome modifiers";
    }

    protected void run(BiConsumer<ResourceLocation, Supplier<JsonElement>> biConsumer) {
        ArrayList<ResourceLocation> biomeList = new ArrayList<ResourceLocation>();
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_48151_.m_135782_(), 1500.0, 10.0));
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_220594_.m_135782_(), 2000.0, 20.0));
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_48175_.m_135782_(), 2500.0, 30.0));
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_48200_.m_135782_(), 4500.0, 50.0));
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_48209_.m_135782_(), 1500.0, 20.0));
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_48201_.m_135782_(), 3500.0, 40.0));
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_48165_.m_135782_(), 4500.0, 25.0));
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_48163_.m_135782_(), 4500.0, 25.0));
        biomeList.add(this.magiculeModifier(biConsumer, Biomes.f_48164_.m_135782_(), 4500.0, 25.0));
        biomeList.add(this.magiculeModifier(biConsumer, TensuraBiomes.UNDERWORLD_BARRENS.getId(), 3500.0, 50.0));
        biomeList.add(this.magiculeModifier(biConsumer, TensuraBiomes.UNDERWORLD_RED_SANDS.getId(), 1500.0, 50.0));
        biomeList.add(this.magiculeModifier(biConsumer, TensuraBiomes.UNDERWORLD_SANDS.getId(), 500.0, 50.0));
        biomeList.add(this.magiculeModifier(biConsumer, TensuraBiomes.UNDERWORLD_SPIKES.getId(), 2500.0, 50.0));
        for (ResourceLocation biomeId : ForgeRegistries.BIOMES.getKeys()) {
            if (biomeList.contains(biomeId)) continue;
            new BiomeMagiculeModifier(biomeId, -1, List.of(new DataPackMagiculeModifier(DataPackMagiculeModifier.Mode.ADD, 0.0)), List.of(new DataPackMagiculeModifier(DataPackMagiculeModifier.Mode.ADD, 0.0))).buildJson(biConsumer);
        }
    }

    private ResourceLocation magiculeModifier(BiConsumer<ResourceLocation, Supplier<JsonElement>> biConsumer, ResourceLocation biomeId, double base, double regen) {
        BiomeMagiculeModifier biomeMagiculeModifier = new BiomeMagiculeModifier(biomeId, -1, List.of(new DataPackMagiculeModifier(DataPackMagiculeModifier.Mode.ADD, base)), List.of(new DataPackMagiculeModifier(DataPackMagiculeModifier.Mode.ADD, regen)));
        biomeMagiculeModifier.buildJson(biConsumer);
        return biomeId;
    }

    private ResourceLocation magiculeModifier(BiConsumer<ResourceLocation, Supplier<JsonElement>> biConsumer, String biome, double base, double regen) {
        ResourceLocation biomeId = new ResourceLocation(biome);
        return this.magiculeModifier(biConsumer, biomeId, base, regen);
    }
}

