/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.core.client;

import com.github.manasmods.tensura.ability.SkillClientUtils;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScreenEffectRenderer.class})
public abstract class MixinScreenEffectRenderer {
    @Unique
    private static final Material BLACK_FIRE_1 = new Material(TextureAtlas.f_118259_, new ResourceLocation("tensura:block/black_fire_1"));

    @Inject(method={"renderFire"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderFire(Minecraft pMinecraft, PoseStack pPoseStack, CallbackInfo ci) {
        if (pMinecraft.f_91074_ != null && SkillClientUtils.shouldCancelFireOverlay((LivingEntity)pMinecraft.f_91074_)) {
            ci.cancel();
        }
    }

    @Redirect(method={"renderScreenEffect"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/client/ForgeHooksClient;renderFireOverlay(Lnet/minecraft/world/entity/player/Player;Lcom/mojang/blaze3d/vertex/PoseStack;)Z"))
    private static boolean redirectRenderFireOverlay(Player player, PoseStack poseStack) {
        if (TensuraEffectsCapability.hasSyncedEffect((LivingEntity)player, (MobEffect)TensuraMobEffects.BLACK_BURN.get())) {
            return ForgeHooksClient.renderBlockOverlay((Player)player, (PoseStack)poseStack, (RenderBlockScreenEffectEvent.OverlayType)RenderBlockScreenEffectEvent.OverlayType.FIRE, (BlockState)((Block)TensuraBlocks.BLACK_FIRE.get()).m_49966_(), (BlockPos)player.m_20183_());
        }
        return ForgeHooksClient.renderFireOverlay((Player)player, (PoseStack)poseStack);
    }

    @ModifyVariable(method={"renderFire"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/resources/model/Material;sprite()Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"))
    private static TextureAtlasSprite onRenderFire(TextureAtlasSprite value, Minecraft minecraft, PoseStack poseStack) {
        if (minecraft.f_91074_ != null && TensuraEffectsCapability.hasSyncedEffect((LivingEntity)minecraft.f_91074_, (MobEffect)TensuraMobEffects.BLACK_BURN.get())) {
            return BLACK_FIRE_1.m_119204_();
        }
        return value;
    }
}

