/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.core.client;

import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.entity.client.layer.StaticBlockLayer;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class})
public abstract class MixinLivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    protected MixinLivingEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    @Inject(method={"render*"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIFFFF)V", ordinal=0, shift=At.Shift.AFTER)})
    public void blockOverlayRender(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci) {
        ResourceLocation chargingTexture = StaticBlockLayer.getBlockTexture(pEntity);
        if (chargingTexture == null) {
            return;
        }
        VertexConsumer vertexconsumer = pBuffer.m_6299_(StaticBlockLayer.getBlockRenderType(chargingTexture));
        int i = LivingEntityRenderer.m_115338_(pEntity, (float)0.0f);
        ((LivingEntityRenderer)this).m_7200_().m_7695_(pMatrixStack, vertexconsumer, pPackedLight, i, 1.0f, 1.0f, 1.0f, StaticBlockLayer.getAlphaValue(pEntity));
    }

    @Inject(method={"getOverlayCoords"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getOverlayCoords(LivingEntity entity, float pU, CallbackInfoReturnable<Integer> cir) {
        if (SkillUtils.hasPainNull(entity) && !TensuraEffectsCapability.hasSyncedEffect(entity, (MobEffect)TensuraMobEffects.LUST_EMBRACEMENT.get())) {
            cir.setReturnValue((Object)OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)pU), (int)OverlayTexture.m_118096_((entity.f_20919_ > 0 ? 1 : 0) != 0)));
        }
    }
}

