/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.core;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TamableAnimal.class})
public class MixinTamableAnimal {
    @Inject(method={"getOwnerUUID"}, at={@At(value="RETURN")}, cancellable=true)
    public void getOwnerUUID(CallbackInfoReturnable<UUID> cir) {
        TamableAnimal animal = (TamableAnimal)this;
        UUID temporary = TensuraEPCapability.getTemporaryOwner((LivingEntity)animal);
        if (temporary != null) {
            cir.setReturnValue((Object)temporary);
            return;
        }
        UUID permanent = TensuraEPCapability.getPermanentOwner((LivingEntity)animal);
        if (permanent != null) {
            cir.setReturnValue((Object)permanent);
        }
    }

    @Inject(method={"isTame"}, at={@At(value="RETURN")}, cancellable=true)
    public void isTame(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        TamableAnimal animal = (TamableAnimal)this;
        if (TensuraEPCapability.getTemporaryOwner((LivingEntity)animal) != null) {
            cir.setReturnValue((Object)true);
        }
        if (TensuraEPCapability.getPermanentOwner((LivingEntity)animal) != null) {
            cir.setReturnValue((Object)true);
        }
    }
}

