/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.core;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.common.HydraulicPropulsionSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.effect.template.DamageAction;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class MixinPlayer {
    @Inject(method={"getMyRidingOffset"}, at={@At(value="RETURN")}, cancellable=true)
    public void getMyRidingOffset(CallbackInfoReturnable<Double> cir) {
        Player player = (Player)this;
        cir.setReturnValue((Object)(0.65 - (double)RaceHelper.getSizeMultiplier((LivingEntity)player)));
    }

    @Inject(method={"doAutoAttackOnTouch"}, at={@At(value="RETURN")})
    public void getSpinAttackAbility(LivingEntity pTarget, CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_21209_()) {
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                if (cap.isSkillInSlots((ManasSkill)CommonSkills.HYDRAULIC_PROPULSION.get())) {
                    HydraulicPropulsionSkill.riptideImpact((LivingEntity)player, pTarget);
                }
            });
        }
    }

    @Inject(method={"getHurtSound"}, at={@At(value="RETURN")}, cancellable=true)
    protected void getHurtSound(DamageSource pDamageSource, CallbackInfoReturnable<SoundEvent> cir) {
        Player player = (Player)this;
        if (SkillUtils.hasPainNull((LivingEntity)player)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"causeFoodExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    public void causeFoodExhaustion(float pExhaustion, CallbackInfo ci) {
        Player player = (Player)this;
        if (player.m_21023_(MobEffects.f_19612_)) {
            return;
        }
        if (!TensuraEPCapability.isMajin((LivingEntity)player) && !RaceHelper.isSpiritualLifeForm((LivingEntity)player)) {
            return;
        }
        if (player.m_36324_().m_38702_() < 18) {
            player.m_36324_().m_38705_(18);
            ci.cancel();
        } else if (player.m_36324_().m_38702_() == 18) {
            ci.cancel();
        }
    }

    @Inject(method={"isHurt"}, at={@At(value="RETURN")}, cancellable=true)
    public void isSeveranceHurt(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        Player player = (Player)this;
        if ((double)player.m_21223_() >= (double)player.m_21233_() - TensuraEffectsCapability.getSeverance((LivingEntity)player)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isSleepingLongEnough"}, at={@At(value="RETURN")}, cancellable=true)
    public void isSleepingLongEnough(CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        if (player.m_21124_((MobEffect)TensuraMobEffects.INSANITY.get()) != null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", shift=At.Shift.AFTER)})
    public void attack(Entity pTarget, CallbackInfo ci, @Local(ordinal=0) float damage) {
        Player player = (Player)this;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (SkillUtils.noInteractiveMode((LivingEntity)player)) {
            return;
        }
        EngravingEnchantment.doAdditionalAttack(player.m_21205_(), (LivingEntity)player, pTarget, damage);
        for (MobEffectInstance instance : player.m_21220_()) {
            MobEffect mobEffect = instance.m_19544_();
            if (!(mobEffect instanceof DamageAction)) continue;
            DamageAction effect = (DamageAction)mobEffect;
            effect.onPlayerAttack(player, pTarget);
        }
    }
}

