/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config.client;

import com.github.manasmods.tensura.config.client.TensuraClientConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class DisplayConfig {
    public final ForgeConfigSpec.BooleanValue titleScreen;
    public final ForgeConfigSpec.BooleanValue arachnophobia;
    public final ForgeConfigSpec.BooleanValue leftSideStats;
    public final ForgeConfigSpec.BooleanValue leftSideSkills;
    public final ForgeConfigSpec.BooleanValue leftSideAnalysis;
    public final ForgeConfigSpec.DoubleValue size;
    public final ForgeConfigSpec.IntValue hudVariant;
    public final ForgeConfigSpec.IntValue hudX;
    public final ForgeConfigSpec.IntValue hudY;
    public final ForgeConfigSpec.IntValue skillsX;
    public final ForgeConfigSpec.IntValue skillsY;
    public final ForgeConfigSpec.IntValue appraisalOpacity;

    public DisplayConfig(ForgeConfigSpec.Builder builder) {
        builder.push("titleScreen");
        this.titleScreen = builder.comment(new String[]{"Display Tensura's Title Screen", "default = true"}).define("useTensuraTitleScreen", true);
        builder.pop();
        builder.push("arachnophobia");
        this.arachnophobia = builder.comment(new String[]{"Give spider mobs a more friendly texture", "default: false"}).define("arachnophobiaMode", false);
        builder.pop();
        builder.push("tensuraHUD");
        this.hudVariant = builder.comment(new String[]{"Type of HUD to show", "0 = vanilla, 1 = tensura, 2 = both, 3 = vanilla HUD + tensura MP and AP bars, skills, appraisal"}).defineInRange("hudVariant", 1, 0, 3);
        this.hudX = builder.comment(new String[]{"Horizontal HUD position (only for hudVariant 3)", "-1 will reset it to default"}).defineInRange("hudX", -1, -1, 7680);
        this.hudY = builder.comment(new String[]{"Vertical HUD position (only for hudVariant 3)", "-1 will reset it to default"}).defineInRange("hudY", -1, -1, 4320);
        this.leftSideStats = builder.comment(new String[]{"Should statistics be displayed on the left side", "true = left, false = right"}).define("leftSideStats", true);
        this.leftSideSkills = builder.comment(new String[]{"Should the Skill Overlay be flipped", "true = left to right, false = right to left"}).define("flipped", false);
        this.leftSideAnalysis = builder.comment(new String[]{"Should the Analysis Overlay be on the left side", "true = left, false = right"}).define("leftSideAnalysis", false);
        this.size = builder.comment(new String[]{"Multiplier that scales the HUD, e.g. 1 * 0.75 = 25% smaller, 1 * 1.25 = 25% bigger", "set to 1 if no change is desired"}).defineInRange("size", 1.0, 0.25, 10.0);
        this.skillsX = builder.comment(new String[]{"Horizontal position for the Skill Overlay", "-1 will reset it to default", "-2 will anchor it on the right side"}).defineInRange("posX", -1, -2, 7680);
        this.skillsY = builder.comment(new String[]{"Vertical position for the Skill Overlay", "-1 will reset it to default", "-2 will anchor it on the bottom"}).defineInRange("posY", -1, -2, 4320);
        this.appraisalOpacity = builder.comment(new String[]{"Opacity value for the Appraisal HUD element, lower = more see-through", "default: 80"}).defineInRange("opacityValue", 80, 0, 100);
        builder.pop();
    }

    public static void resetEverything() {
        if (!TensuraClientConfig.SPEC.isLoaded()) {
            return;
        }
        DisplayConfig cfg = TensuraClientConfig.INSTANCE.displayConfig;
        cfg.titleScreen.set((Object)((Boolean)cfg.titleScreen.getDefault()));
        cfg.arachnophobia.set((Object)((Boolean)cfg.arachnophobia.getDefault()));
        cfg.leftSideStats.set((Object)((Boolean)cfg.leftSideStats.getDefault()));
        cfg.leftSideSkills.set((Object)((Boolean)cfg.leftSideSkills.getDefault()));
        cfg.leftSideAnalysis.set((Object)((Boolean)cfg.leftSideAnalysis.getDefault()));
        cfg.size.set((Object)((Double)cfg.size.getDefault()));
        cfg.hudVariant.set((Object)((Integer)cfg.hudVariant.getDefault()));
        cfg.hudX.set((Object)((Integer)cfg.hudX.getDefault()));
        cfg.hudY.set((Object)((Integer)cfg.hudY.getDefault()));
        cfg.skillsX.set((Object)((Integer)cfg.skillsX.getDefault()));
        cfg.skillsY.set((Object)((Integer)cfg.skillsY.getDefault()));
        cfg.appraisalOpacity.set((Object)((Integer)cfg.appraisalOpacity.getDefault()));
    }
}

