/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SpawnRateConfig {
    public static final SpawnRateConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.IntValue otherworlderSpawnRate;
    public final ForgeConfigSpec.IntValue shizuChance;
    public final ForgeConfigSpec.IntValue hinataChance;
    public final ForgeConfigSpec.IntValue aquaFrogSpawnRate;
    public final ForgeConfigSpec.IntValue armoursaurusSpawnRate;
    public final ForgeConfigSpec.IntValue armyWaspSpawnRate;
    public final ForgeConfigSpec.IntValue barghestSpawnRate;
    public final ForgeConfigSpec.IntValue beastGnomeSpawnRate;
    public final ForgeConfigSpec.IntValue blackSpiderSpawnRate;
    public final ForgeConfigSpec.IntValue bladeTigerSpawnRate;
    public final ForgeConfigSpec.IntValue bulldeerSpawnRate;
    public final ForgeConfigSpec.IntValue direwolfSpawnRate;
    public final ForgeConfigSpec.IntValue dragonPeacockSpawnRate;
    public final ForgeConfigSpec.IntValue evilCentipedeSpawnRate;
    public final ForgeConfigSpec.IntValue featheredSerpentSpawnRate;
    public final ForgeConfigSpec.IntValue giantAntSpawnRate;
    public final ForgeConfigSpec.IntValue giantBatSpawnRate;
    public final ForgeConfigSpec.IntValue giantBearSpawnRate;
    public final ForgeConfigSpec.IntValue giantCodSpawnRate;
    public final ForgeConfigSpec.IntValue giantSalmonSpawnRate;
    public final ForgeConfigSpec.IntValue goblinSpawnRate;
    public final ForgeConfigSpec.IntValue hellCaterpillarSpawnRate;
    public final ForgeConfigSpec.IntValue hellMothSpawnRate;
    public final ForgeConfigSpec.IntValue hornedBearSpawnRate;
    public final ForgeConfigSpec.IntValue hornedRabbitSpawnRate;
    public final ForgeConfigSpec.IntValue houndDogSpawnRate;
    public final ForgeConfigSpec.IntValue houndDogSnakeChance;
    public final ForgeConfigSpec.IntValue hoverLizardSpawnRate;
    public final ForgeConfigSpec.IntValue knightSpiderSpawnRate;
    public final ForgeConfigSpec.IntValue landfishSpawnRate;
    public final ForgeConfigSpec.IntValue leechLizardSpawnRate;
    public final ForgeConfigSpec.IntValue lizardmanSpawnRate;
    public final ForgeConfigSpec.IntValue megalodonSpawnRate;
    public final ForgeConfigSpec.IntValue oneEyedOwlSpawnRate;
    public final ForgeConfigSpec.IntValue orcSpawnRate;
    public final ForgeConfigSpec.IntValue orcLordChance;
    public final ForgeConfigSpec.IntValue orcRoyalChance;
    public final ForgeConfigSpec.IntValue orcRoyalLordChance;
    public final ForgeConfigSpec.IntValue salamanderSpawnRate;
    public final ForgeConfigSpec.IntValue sissieSpawnRate;
    public final ForgeConfigSpec.IntValue slimeSpawnRate;
    public final ForgeConfigSpec.IntValue slimeMetalChance;
    public final ForgeConfigSpec.IntValue slimeSupermassiveChance;
    public final ForgeConfigSpec.IntValue spearToroSpawnRate;
    public final ForgeConfigSpec.IntValue tempestSerpentSpawnRate;
    public final ForgeConfigSpec.IntValue unicornSpawnRate;
    public final ForgeConfigSpec.IntValue wingedCatSpawnRate;
    public final ForgeConfigSpec.IntValue giantFishAwarenessRange;
    public final ForgeConfigSpec.IntValue hellMothAwarenessRange;
    public final ForgeConfigSpec.IntValue slimeAwarenessRange;
    public final ForgeConfigSpec.IntValue alphaWolf;
    public final ForgeConfigSpec.IntValue starBirthmark;
    public final ForgeConfigSpec.DoubleValue evolvedPack;
    public final ForgeConfigSpec.DoubleValue elementalFangPack;
    public final ForgeConfigSpec.DoubleValue tempestWolfPack;

    public SpawnRateConfig(ForgeConfigSpec.Builder builder) {
        builder.push("otherworlder");
        this.otherworlderSpawnRate = this.spawnrate(builder, 20);
        this.shizuChance = this.buildInt(builder, "shizuChance", "One of how many chances for Shizu to spawn when an otherworlder spawns.", 30);
        this.hinataChance = this.buildInt(builder, "hinataChance", "One of how many chances for Hinata to spawn when an otherworlder spawns.", 69);
        builder.pop();
        builder.push("aqua_frog");
        this.aquaFrogSpawnRate = this.spawnrate(builder, 20);
        builder.pop();
        builder.push("armoursaurus");
        this.armoursaurusSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("army_wasp");
        this.armyWaspSpawnRate = this.spawnrate(builder, 50);
        builder.pop();
        builder.push("barghest");
        this.barghestSpawnRate = this.spawnrate(builder, 10);
        builder.pop();
        builder.push("beast_gnome");
        this.beastGnomeSpawnRate = this.spawnrate(builder, 20);
        builder.pop();
        builder.push("black_spider");
        this.blackSpiderSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("blade_tiger");
        this.bladeTigerSpawnRate = this.spawnrate(builder, 15);
        builder.pop();
        builder.push("bulldeer");
        this.bulldeerSpawnRate = this.spawnrate(builder, 10);
        builder.pop();
        builder.push("direwolf");
        this.direwolfSpawnRate = this.spawnrate(builder, 1);
        this.alphaWolf = builder.comment("One of how many chances for a Direwolf to be an Alpha.").defineInRange("alphaWolf", 10, 0, 1024);
        this.starBirthmark = builder.comment("One of how many chances for a Tempest Wolf to have the Star birthmark.").defineInRange("starBirthmark", 8, 0, 1024);
        this.evolvedPack = builder.comment("The percentage chance for a direwolf pack to be evolved").defineInRange("evolvedPack", 40.0, 0.0, 100.0);
        this.elementalFangPack = builder.comment("The percentage chance for a direwolf pack to be Elemental Fang based on biomes").defineInRange("elementalPack", 65.0, 0.0, 100.0);
        this.tempestWolfPack = builder.comment("The percentage chance for a direwolf pack to be Tempest Wolves").defineInRange("tempestPack", 10.0, 0.0, 100.0);
        builder.pop();
        builder.push("dragonPeacock");
        this.dragonPeacockSpawnRate = this.spawnrate(builder, 25);
        builder.pop();
        builder.push("evilCentipede");
        this.evilCentipedeSpawnRate = this.spawnrate(builder, 30);
        builder.pop();
        builder.push("feathered_serpent");
        this.featheredSerpentSpawnRate = this.spawnrate(builder, 60);
        builder.pop();
        builder.push("giantAnt");
        this.giantAntSpawnRate = this.spawnrate(builder, 10);
        builder.pop();
        builder.push("giantBat");
        this.giantBatSpawnRate = this.spawnrate(builder, 2);
        builder.pop();
        builder.push("giantBear");
        this.giantBearSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("giantCod");
        this.giantCodSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("giantSalmon");
        this.giantSalmonSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("goblin");
        this.goblinSpawnRate = this.spawnrate(builder, 2);
        builder.pop();
        builder.push("hellCaterpillar");
        this.hellCaterpillarSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("hellMoth");
        this.hellMothSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("hornedBear");
        this.hornedBearSpawnRate = this.spawnrate(builder, 3);
        builder.pop();
        builder.push("hornedRabbit");
        this.hornedRabbitSpawnRate = this.spawnrate(builder, 2);
        builder.pop();
        builder.push("houndDog");
        this.houndDogSpawnRate = this.spawnrate(builder, 12);
        this.houndDogSnakeChance = this.buildInt(builder, "snakeChance", "One of how many chances for a hound dog to have a snake tail.", 40);
        builder.pop();
        builder.push("hoverLizard");
        this.hoverLizardSpawnRate = this.spawnrate(builder, 2);
        builder.pop();
        builder.push("knightSpider");
        this.knightSpiderSpawnRate = this.spawnrate(builder, 8);
        builder.pop();
        builder.push("landfish");
        this.landfishSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("leechLizard");
        this.leechLizardSpawnRate = this.spawnrate(builder, 8);
        builder.pop();
        builder.push("lizardman");
        this.lizardmanSpawnRate = this.spawnrate(builder, 2);
        builder.pop();
        builder.push("megalodon");
        this.megalodonSpawnRate = this.spawnrate(builder, 10);
        builder.pop();
        builder.push("oneEyedOwl");
        this.oneEyedOwlSpawnRate = this.spawnrate(builder, 15);
        builder.pop();
        builder.push("orc");
        this.orcSpawnRate = this.spawnrate(builder, 5);
        this.orcLordChance = this.buildInt(builder, "lordChance", "One of how many chances for an Orc Lord to spawn when an orc spawns.", 900);
        this.orcRoyalChance = this.buildInt(builder, "royalChance", "One of how many chances for an Orc to be an Royal Orc.", 100);
        this.orcRoyalLordChance = this.buildInt(builder, "royalLordChance", "One of how many chances for a Royal Orc to have Self-Regeneration.", 7);
        builder.pop();
        builder.push("salamander");
        this.salamanderSpawnRate = this.spawnrate(builder, 10);
        builder.pop();
        builder.push("sissie");
        this.sissieSpawnRate = this.spawnrate(builder, 20);
        builder.pop();
        builder.push("slime");
        this.slimeSpawnRate = this.spawnrate(builder, 10);
        this.slimeMetalChance = this.buildInt(builder, "metalChance", "One of how many chances for a metal slime to spawn when a slime spawns.", 500);
        this.slimeSupermassiveChance = this.buildInt(builder, "supermassiveChance", "One of how many chances for a supermassive slime to spawn when a slime spawns.", 1000);
        builder.pop();
        builder.push("spearToro");
        this.spearToroSpawnRate = this.spawnrate(builder, 30);
        builder.pop();
        builder.push("tempestSerpent");
        this.tempestSerpentSpawnRate = this.spawnrate(builder, 30);
        builder.pop();
        builder.push("unicorn");
        this.unicornSpawnRate = this.spawnrate(builder, 5);
        builder.pop();
        builder.push("winged_cat");
        this.wingedCatSpawnRate = this.spawnrate(builder, 40);
        builder.pop();
        builder.push("slimes");
        this.slimeAwarenessRange = this.buildInt(builder, "awarenessRange", "Range slimes get aggressive when another slime gets attacked", 16);
        builder.pop();
        builder.push("hellMothsAndCaterpillars");
        this.hellMothAwarenessRange = this.buildInt(builder, "awarenessRange", "Range hell moths get aggressive when a cocoon/hell caterpillar gets attacked", 16);
        builder.pop();
        builder.push("giantFish");
        this.giantFishAwarenessRange = this.buildInt(builder, "awarenessRange", "Range giant fish get aggressive when a small version gets attacked", 16);
        builder.pop();
    }

    private ForgeConfigSpec.IntValue spawnrate(ForgeConfigSpec.Builder builder, int defaultValue) {
        return builder.comment("How many times will the entity attempt to spawn before failing\n0 = disabled, 1 = guaranteed, higher = lower chance\ndefault = " + defaultValue).defineInRange("spawnAttempts", defaultValue, 0, 50);
    }

    private ForgeConfigSpec.IntValue buildInt(ForgeConfigSpec.Builder builder, String valueName, String comment, int defaultValue) {
        return builder.comment(comment).defineInRange(valueName, defaultValue, 0, 1024);
    }

    public static boolean rollSpawn(int rolls, RandomSource randomSource, MobSpawnType reason) {
        if (reason == MobSpawnType.SPAWNER || rolls == 1) {
            return true;
        }
        if (rolls <= 0) {
            return false;
        }
        return randomSource.m_188503_(rolls) == 1;
    }

    public static boolean rollChance(int rolls, RandomSource randomSource) {
        if (rolls == 1) {
            return true;
        }
        if (rolls <= 0) {
            return false;
        }
        return randomSource.m_188503_(rolls) == 1;
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(SpawnRateConfig::new);
        INSTANCE = (SpawnRateConfig)pair.getKey();
        SPEC = (ForgeConfigSpec)pair.getValue();
    }
}

