/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ItemsConfig {
    public final ForgeConfigSpec.IntValue elementalCoreCost;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyMilkEffects;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedScrolls;

    public ItemsConfig(ForgeConfigSpec.Builder builder) {
        builder.push("elementalCoreCost");
        this.elementalCoreCost = builder.comment("The amount of EP that an empty elemental core will take from the spirit when used").defineInRange("coreEPCost", 1000, 0, 1000000000);
        builder.pop();
        builder.push("HolyMilk");
        this.holyMilkEffects = builder.comment("List of harmful effects that get removed upon consumption").defineList("effects", Arrays.asList("minecraft:bad_omen", "minecraft:nausea", "minecraft:weakness", "minecraft:blindness", "minecraft:hunger", "minecraft:poison", "minecraft:darkness", "minecraft:mining_fatigue", "minecraft:levitation", "minecraft:slowness", "minecraft:unluck", "minecraft:wither", "tensura:burden", "tensura:chill", "tensura:fragility", "tensura:silence", "tensura:corrosion", "tensura:fatal_poison", "tensura:infection", "tensura:paralysis"), check -> true);
        builder.pop();
        builder.push("resetScrolls");
        this.allowedScrolls = builder.comment("List of Reset Scroll that can be used").defineList("scrolls", Arrays.asList("tensura:race_reset_scroll", "tensura:skill_reset_scroll", "tensura:character_reset_scroll"), check -> true);
        builder.pop();
    }
}

