/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class EntitiesConfig {
    public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> goblinClothingColors;
    public final ForgeConfigSpec.DoubleValue labyrinthMapChance;
    public final ForgeConfigSpec.DoubleValue hellGateMapChance;
    public final ForgeConfigSpec.DoubleValue tamedWanderRadius;
    public final ForgeConfigSpec.DoubleValue magicDespawnRange;
    public final ForgeConfigSpec.IntValue spearDespawn;
    public final ForgeConfigSpec.IntValue magicDespawn;
    public final ForgeConfigSpec.IntValue thrownItem;

    public EntitiesConfig(ForgeConfigSpec.Builder builder) {
        builder.push("tamedWanderRadius");
        this.tamedWanderRadius = builder.comment("The maximum distance the tamed entities can go from its wandering pos").defineInRange("wanderRadius", 50.0, 1.0, 256.0);
        builder.pop();
        builder.push("goblinClothingColors");
        this.goblinClothingColors = builder.comment("Random colors for goblins' Clothing").defineList("colors", Arrays.asList(13808780, 3154966, 8612179, 2105626, 3494666, 0x960000), check -> true);
        builder.pop();
        builder.push("structureMaps");
        this.labyrinthMapChance = builder.comment("The chance for Labyrinth Explorer Map to show up when the trades roll into it").defineInRange("labyrinthMapChance", 0.2, 0.0, 1.0);
        this.hellGateMapChance = builder.comment("The chance for Hell Gate Explorer Map to show up when the trades roll into it").defineInRange("hellGateMapChance", 0.2, 0.0, 1.0);
        builder.pop();
        builder.push("projectiles");
        this.spearDespawn = builder.comment("The number of ticks that a spear or kunai needs to be on ground to despawn").defineInRange("spearDespawnTick", 600, 0, 1000000);
        this.thrownItem = builder.comment("The number of ticks that a thrown item by Thrower needs to be on ground to despawn").defineInRange("thrownItemDespawnTick", 400, 0, 1000000);
        this.magicDespawn = builder.comment("The number of ticks that a magic projectile needs to despawn").defineInRange("magicProjectileDespawn", 400, 0, 1000000);
        this.magicDespawnRange = builder.comment("How many blocks that a magic projectile needs to be from the shooter to despawn\nSet to a value higher than 0 to enable this").defineInRange("magicProjectileDespawnRange", -1.0, 0.0, 1000000.0);
        builder.pop();
    }
}

