/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class AwakeningConfig {
    public final ForgeConfigSpec.DoubleValue majinPercentage;
    public final ForgeConfigSpec.DoubleValue epToSoulRate;
    public final ForgeConfigSpec.IntValue massNamingRaid;
    public final ForgeConfigSpec.IntValue massNamingHuman;
    public final ForgeConfigSpec.IntValue prayingTime;
    public final ForgeConfigSpec.IntValue prayingCooldown;
    public final ForgeConfigSpec.DoubleValue blessedPercentage;
    public final ForgeConfigSpec.DoubleValue lesserSpiritPercentage;
    public final ForgeConfigSpec.DoubleValue mediumSpiritPercentage;
    public final ForgeConfigSpec.DoubleValue greaterSpiritPercentage;
    public final ForgeConfigSpec.DoubleValue lordSpiritPercentage;
    public final ForgeConfigSpec.IntValue heroSpiritLevel;
    public final ForgeConfigSpec.IntValue heroSpiritNumber;

    public AwakeningConfig(ForgeConfigSpec.Builder builder) {
        this.majinPercentage = builder.comment("The percentage to become Majin when dying of Magicule Poison").defineInRange("majinPercentage", 5.0, 0.0, 100.0);
        this.blessedPercentage = builder.comment("The percentage to be blessed on reincarnation by 6 Greater Spirits when praying").defineInRange("blessedPercentage", 5.0, 0.0, 100.0);
        this.prayingTime = builder.comment("The number of ticks that players need to pray for spirits").defineInRange("prayingTime", 200, 0, Integer.MAX_VALUE);
        this.prayingCooldown = builder.comment("The number of seconds of cooldown between each time of Spirit Praying").defineInRange("prayingCooldown", 1200, 0, Integer.MAX_VALUE);
        this.lesserSpiritPercentage = builder.comment("The percentage to get a Lesser Spirit when praying in the labyrinth").defineInRange("lesserSpiritPercentage", 40.0, 0.0, 100.0);
        this.mediumSpiritPercentage = builder.comment("The percentage to get a Medium Spirit when praying in the labyrinth").defineInRange("mediumSpiritPercentage", 30.0, 0.0, 100.0);
        this.greaterSpiritPercentage = builder.comment("The percentage to get a Greater Spirit when praying in the labyrinth").defineInRange("greaterSpiritPercentage", 20.0, 0.0, 100.0);
        this.lordSpiritPercentage = builder.comment("The percentage to get a Spirit Lord when praying in the labyrinth if met the condition").defineInRange("lordSpiritPercentage", 1.0, 0.0, 100.0);
        this.heroSpiritLevel = builder.comment("The level of Spirit needed to be counted for Hero Egg").defineInRange("heroSpiritLevel", 3, 0, 5);
        this.heroSpiritNumber = builder.comment("The number of Spirits needed to be a Hero Egg").defineInRange("heroSpiritNumber", 6, 0, 8);
        this.epToSoulRate = builder.comment("The percentage of fallen targets' EP getting added into the attacker's soul points").defineInRange("epSoulRate", 50.0, 0.0, 100.0);
        this.massNamingRaid = builder.comment("The number of raids needed for Mass Naming").defineInRange("raids_for_mass_naming", 25, 1, 1000);
        this.massNamingHuman = builder.comment("The number of human kills needed for Mass Naming").defineInRange("human_kills_for_mass_naming", 1000, 1, 1000000000);
    }
}

