/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.command;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.RemoveSkillEvent;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.ability.magic.Magic;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.api.magicule.MagiculeAPI;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.magicule.MagiculeChunkCapabilityImpl;
import com.github.manasmods.tensura.capability.race.ITensuraPlayerCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.ITensuraSkillCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.capability.smithing.ISmithingCapability;
import com.github.manasmods.tensura.capability.smithing.SmithingCapability;
import com.github.manasmods.tensura.command.TensuraPermissions;
import com.github.manasmods.tensura.command.argument.RaceArgument;
import com.github.manasmods.tensura.command.argument.SkillArgument;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.item.custom.ResetScrollItem;
import com.github.manasmods.tensura.menu.RaceSelectionMenu;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.TensuraStats;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.PermissionHelper;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.github.manasmods.tensura.world.savedata.LabyrinthSaveData;
import com.github.manasmods.tensura.world.savedata.UniqueSkillSaveData;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TensuraCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tensura").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_RESET))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> TensuraCommand.resetEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets")))).then(Commands.m_82127_((String)"awakening").executes(context -> TensuraCommand.resetAwakening((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"race").executes(context -> TensuraCommand.resetRace((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), null))).then(Commands.m_82129_((String)"race", (ArgumentType)RaceArgument.race()).executes(context -> TensuraCommand.resetRace((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), RaceArgument.getRace((CommandContext<CommandSourceStack>)context, "race")))))).then(Commands.m_82127_((String)"skill").executes(context -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"targets")) {
                ResetScrollItem.resetSkill(player, true);
                TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.reset.skill", (Object[])new Object[]{player.m_7755_()}));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"schematics").executes(context -> TensuraCommand.resetSchematics((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))).then(Commands.m_82127_((String)"statistic").executes(context -> TensuraCommand.resetStat((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))))).then(Commands.m_82127_((String)"edit").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spirit").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_STAT))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"spirit", (ArgumentType)IntegerArgumentType.integer((int)0, (int)6)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            int spirit = IntegerArgumentType.getInteger((CommandContext)context, (String)"spirit");
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            TensuraSkillCapability.getFrom((Player)player).ifPresent(arg_0 -> TensuraCommand.lambda$register$9((Player)player, spirit, amount, arg_0));
            TensuraSkillCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.spirit.set", (Object[])new Object[]{player.m_7755_(), MagicElemental.byId(spirit).getName(), amount}));
            return 1;
        }))))).then(Commands.m_82127_((String)"clear").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            TensuraSkillCapability.getFrom((Player)player).ifPresent(ITensuraSkillCapability::clearSpiritLevel);
            TensuraSkillCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.spirit.clear", (Object[])new Object[]{player.m_7755_()}));
            return 1;
        }))).then(Commands.m_82127_((String)"cooldown").then(Commands.m_82129_((String)"second", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            int second = IntegerArgumentType.getInteger((CommandContext)context, (String)"second");
            TensuraSkillCapability.getFrom((Player)player).ifPresent(cap -> cap.setSpiritCooldown(second));
            TensuraSkillCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.spirit.cooldown.set", (Object[])new Object[]{player.m_7755_(), second}));
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"forceevo").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_RACE_OTHERS))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"race").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            if (RaceHelper.evolveRace((Player)player)) {
                TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.force_evo.race", (Object[])new Object[]{player.m_7755_()}));
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"tensura.command.force_evo.race.fail", (Object[])new Object[]{player.m_7755_()}));
            }
            return 1;
        })).then(Commands.m_82129_((String)"race", (ArgumentType)RaceArgument.race()).suggests(RaceArgument.getNextEvolutions()).executes(context -> {
            Race race;
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            if (RaceHelper.evolveRace((Player)player, race = RaceArgument.getRace((CommandContext<CommandSourceStack>)context, "race"), true)) {
                TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.force_evo.race", (Object[])new Object[]{player.m_7755_()}));
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"tensura.command.force_evo.race.fail_specific", (Object[])new Object[]{player.m_7755_(), race.getName()}));
            }
            return 1;
        })))).then(Commands.m_82127_((String)"demonlord").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setTrueDemonLord(true));
            RaceHelper.awakening((Player)player, false);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.force_evo.demon_lord", (Object[])new Object[]{player.m_7755_()}));
            return 1;
        }))).then(Commands.m_82127_((String)"hero").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setTrueHero(true));
            RaceHelper.awakening((Player)player, true);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.force_evo.hero", (Object[])new Object[]{player.m_7755_()}));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"awakening").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_AWAKENING))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"humanKill").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"targets");
            if (!(entity instanceof LivingEntity)) {
                return 1;
            }
            LivingEntity target = (LivingEntity)entity;
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            TensuraEPCapability.getFrom(target).ifPresent(data -> data.setHumanKill(amount));
            TensuraEPCapability.sync(target);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), entity, Component.m_237110_((String)"tensura.command.human_kill", (Object[])new Object[]{entity.m_7755_(), amount}));
            return 1;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"targets");
            if (!(entity instanceof LivingEntity)) {
                return 1;
            }
            LivingEntity target = (LivingEntity)entity;
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            TensuraEPCapability.getFrom(target).ifPresent(data -> {
                data.setHumanKill(data.getHumanKill() + amount);
                TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), entity, Component.m_237110_((String)"tensura.command.human_kill", (Object[])new Object[]{entity.m_7755_(), data.getHumanKill()}));
            });
            TensuraEPCapability.sync(target);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"demonlord").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"soul").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setSoulPoints(amount * 1000));
            TensuraPlayerCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.demon_lord.soul", (Object[])new Object[]{player.m_7755_(), amount}));
            return 1;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(arg_0 -> TensuraCommand.lambda$register$28(amount, context, (Player)player, arg_0));
            TensuraPlayerCapability.sync((Player)player);
            return 1;
        }))))).then(Commands.m_82127_((String)"seed").then(Commands.m_82129_((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            boolean b = BoolArgumentType.getBool((CommandContext)context, (String)"boolean");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setDemonLordSeed(b));
            TensuraPlayerCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.demon_lord.seed", (Object[])new Object[]{player.m_7755_(), b}));
            return 1;
        })))).then(Commands.m_82127_((String)"awakened").then(Commands.m_82129_((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            boolean b = BoolArgumentType.getBool((CommandContext)context, (String)"boolean");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrueDemonLord(b));
            TensuraPlayerCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.demon_lord.awakened", (Object[])new Object[]{player.m_7755_(), b}));
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hero").then(Commands.m_82127_((String)"blessed").then(Commands.m_82129_((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            boolean b = BoolArgumentType.getBool((CommandContext)context, (String)"boolean");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setBlessed(b));
            TensuraPlayerCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.spirit.blessed", (Object[])new Object[]{player.m_7755_(), b}));
            return 1;
        })))).then(Commands.m_82127_((String)"egg").then(Commands.m_82129_((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            boolean b = BoolArgumentType.getBool((CommandContext)context, (String)"boolean");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setHeroEgg(b));
            TensuraPlayerCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.hero.egg", (Object[])new Object[]{player.m_7755_(), b}));
            return 1;
        })))).then(Commands.m_82127_((String)"awakened").then(Commands.m_82129_((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            boolean b = BoolArgumentType.getBool((CommandContext)context, (String)"boolean");
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrueHero(b));
            TensuraPlayerCapability.sync((Player)player);
            TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.hero.awakened", (Object[])new Object[]{player.m_7755_(), b}));
            return 1;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"race").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_RACE_SELF))).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"targets");
            List<ResourceLocation> races = TensuraPlayerCapability.loadRaces();
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider(RaceSelectionMenu::new, (Component)Component.m_237115_((String)"tensura.race.selection")), buf -> {
                buf.writeBoolean(true);
                buf.m_236828_((Collection)races, FriendlyByteBuf::m_130085_);
            });
            ResetScrollItem.resetFlight((Player)player);
            return 1;
        })).requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_RACE_OTHERS))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"race", (ArgumentType)RaceArgument.race()).executes(context -> TensuraCommand.setRace((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), RaceArgument.getRace((CommandContext<CommandSourceStack>)context, "race"), false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"resetStat", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setRace((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), RaceArgument.getRace((CommandContext<CommandSourceStack>)context, "race"), BoolArgumentType.getBool((CommandContext)context, (String)"resetStat"), false))).then(Commands.m_82129_((String)"grantIntrinsic", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setRace((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), RaceArgument.getRace((CommandContext<CommandSourceStack>)context, "race"), BoolArgumentType.getBool((CommandContext)context, (String)"resetStat"), BoolArgumentType.getBool((CommandContext)context, (String)"grantIntrinsic"))))))).requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_RACE_OTHERS))).then(Commands.m_82127_((String)"majin").then(Commands.m_82129_((String)"boolean", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setMajin((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), BoolArgumentType.getBool((CommandContext)context, (String)"boolean"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_SKILL))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"grant").then(Commands.m_82129_((String)"skills", (ArgumentType)SkillArgument.skill()).executes(context -> TensuraCommand.grantSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"all").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), skill -> skill instanceof TensuraSkill))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), skill -> skill instanceof Skill))).then(Commands.m_82127_((String)"unique").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        })))).then(Commands.m_82127_((String)"extra").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        })))).then(Commands.m_82127_((String)"common").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        })))).then(Commands.m_82127_((String)"intrinsic").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        })))).then(Commands.m_82127_((String)"resistance").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        }))))).then(Commands.m_82127_((String)"magic").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> manasSkill instanceof Magic)))).then(Commands.m_82127_((String)"battlewill").executes(context -> TensuraCommand.grantAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> manasSkill instanceof Battewill))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"random").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> manasSkill instanceof Skill))).then(Commands.m_82127_((String)"resistance").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        })))).then(Commands.m_82127_((String)"intrinsic").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        })))).then(Commands.m_82127_((String)"common").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        })))).then(Commands.m_82127_((String)"extra").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        })))).then(Commands.m_82127_((String)"unique").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        })))).then(Commands.m_82127_((String)"ultimate").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        }))))).then(Commands.m_82127_((String)"magic").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> manasSkill instanceof Magic)))).then(Commands.m_82127_((String)"battlewill").executes(context -> TensuraCommand.grantRandomSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> manasSkill instanceof Battewill)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"revoke").then(Commands.m_82129_((String)"skills", (ArgumentType)SkillArgument.skill()).executes(context -> TensuraCommand.revokeSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"everything").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), skill -> skill instanceof Skill))).then(Commands.m_82127_((String)"ultimate").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        })))).then(Commands.m_82127_((String)"unique").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        })))).then(Commands.m_82127_((String)"extra").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        })))).then(Commands.m_82127_((String)"common").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        })))).then(Commands.m_82127_((String)"intrinsic").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        })))).then(Commands.m_82127_((String)"resistance").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        }))))).then(Commands.m_82127_((String)"magic").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), skill -> skill instanceof Magic)))).then(Commands.m_82127_((String)"battlewill").executes(context -> TensuraCommand.revokeAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), skill -> skill instanceof Battewill)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mastery").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"skills", (ArgumentType)SkillArgument.skill()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills").getMaxMastery()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"everything").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), skill -> true)))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), skill -> true)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> manasSkill instanceof Skill)))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> manasSkill instanceof Skill)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ultimate").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        })))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unique").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        })))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"extra").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        })))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"common").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        })))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"intrinsic").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        })))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resistance").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        })))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"magic").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> manasSkill instanceof Magic)))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> manasSkill instanceof Magic))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"battlewill").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.masterAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), manasSkill -> manasSkill instanceof Battewill)))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.masterMaxAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), manasSkill -> manasSkill instanceof Battewill))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cooldown").then(Commands.m_82129_((String)"skills", (ArgumentType)SkillArgument.skill()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.cooldownSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.m_82127_((String)"everything").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.cooldownAllSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"modeLearning").then(Commands.m_82127_((String)"all").executes(context -> TensuraCommand.learnSkillModeEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"skills", (ArgumentType)SkillArgument.skill()).then(Commands.m_82129_((String)"mode", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.learnSkillMode((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"), IntegerArgumentType.getInteger((CommandContext)context, (String)"mode"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> TensuraCommand.learnSkillModeAll((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle").then(Commands.m_82129_((String)"ability", (ArgumentType)SkillArgument.skill()).suggests(SkillArgument.getObtainedSkillSuggestions()).executes(context -> TensuraCommand.toggleSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "ability"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"everything").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, skill -> true)))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, skill -> true))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, skill -> skill instanceof Skill)))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, skill -> skill instanceof Skill))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resistance").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        })))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"intrinsic").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        })))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"common").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        })))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"extra").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        })))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unique").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        })))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ultimate").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        })))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"magic").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, manasSkill -> manasSkill instanceof Magic)))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, manasSkill -> manasSkill instanceof Magic))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"battlewill").then(Commands.m_82127_((String)"on").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), true, manasSkill -> manasSkill instanceof Battewill)))).then(Commands.m_82127_((String)"off").executes(context -> TensuraCommand.toggleEverything((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), false, manasSkill -> manasSkill instanceof Battewill))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stat").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_STAT))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"magicule").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"current").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> TensuraCommand.setMagicule((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false)))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.setMagicule((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), -1.0, false))))).then(Commands.m_82127_((String)"max").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> TensuraCommand.setMaxMagicule((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true, false))).then(Commands.m_82129_((String)"resetCurrent", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setMaxMagicule((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"resetCurrent"), false))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"current").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> TensuraCommand.setMagicule((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true))))).then(Commands.m_82127_((String)"max").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> TensuraCommand.setMaxMagicule((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true, true))).then(Commands.m_82129_((String)"resetCurrent", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setMaxMagicule((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"resetCurrent"), true)))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"aura").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"current").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> TensuraCommand.setAura((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false)))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.setAura((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), -1.0, false))))).then(Commands.m_82127_((String)"max").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> TensuraCommand.setMaxAura((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true, false))).then(Commands.m_82129_((String)"resetCurrent", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setMaxAura((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"resetCurrent"), false))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"current").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> TensuraCommand.setAura((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true))))).then(Commands.m_82127_((String)"max").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> TensuraCommand.setMaxAura((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true, true))).then(Commands.m_82129_((String)"resetCurrent", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setMaxAura((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), BoolArgumentType.getBool((CommandContext)context, (String)"resetCurrent"), true)))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spiritualHP").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> TensuraCommand.setSpiritualHP((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false)))).then(Commands.m_82127_((String)"max").executes(context -> TensuraCommand.setSpiritualHP((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), -1.0, false))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> TensuraCommand.setSpiritualHP((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"EP").then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> TensuraCommand.setEP((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false, false))).then(Commands.m_82129_((String)"updateStats", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setEP((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), false, BoolArgumentType.getBool((CommandContext)context, (String)"updateStats"))))))).then(Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> TensuraCommand.setEP((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true, false))).then(Commands.m_82129_((String)"updateStats", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.setEP((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), true, BoolArgumentType.getBool((CommandContext)context, (String)"updateStats")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"severance").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> {
            for (Entity entity : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                double amount = DoubleArgumentType.getDouble((CommandContext)context, (String)"amount");
                TensuraEffectsCapability.getFrom(living).ifPresent(cap -> {
                    if (amount != 0.0) {
                        int removeSec = (Integer)TensuraConfig.INSTANCE.skillsConfig.severanceRemoveSec.get();
                        if (cap.getSeveranceRemoveSec() < removeSec) {
                            cap.setSeveranceRemoveSec(removeSec);
                        }
                    } else {
                        cap.setSeveranceRemoveSec(0);
                    }
                    cap.setSeveranceAmount(amount);
                });
                TensuraEffectsCapability.sync(living);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.severance.set", (Object[])new Object[]{entity.m_7755_(), amount}).m_130940_(ChatFormatting.DARK_GREEN), false);
            }
            return 1;
        })))).then(Commands.m_82127_((String)"clear").executes(context -> {
            for (Entity entity : EntityArgument.m_91461_((CommandContext)context, (String)"targets")) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                double amount = 0.0;
                TensuraEffectsCapability.getFrom(living).ifPresent(cap -> {
                    cap.setSeveranceRemoveSec(0);
                    cap.setSeveranceAmount(amount);
                });
                TensuraEffectsCapability.sync(living);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.severance.set", (Object[])new Object[]{entity.m_7755_(), amount}).m_130940_(ChatFormatting.DARK_GREEN), false);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resetCounter").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> TensuraCommand.setResetCounter((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> TensuraCommand.setResetCounter((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"owner").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_EDIT_OWNER))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"name").then(Commands.m_82127_((String)"remove").executes(context -> TensuraCommand.setName((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), null)))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> TensuraCommand.setName((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"name"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"permanent").then(Commands.m_82127_((String)"remove").executes(context -> TensuraCommand.setOwner((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), null, false)))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"owner", (ArgumentType)EntityArgument.m_91449_()).executes(context -> TensuraCommand.setOwner((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), EntityArgument.m_91452_((CommandContext)context, (String)"owner"), false)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"temporary").then(Commands.m_82127_((String)"remove").executes(context -> TensuraCommand.setOwner((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), null, true)))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"owner", (ArgumentType)EntityArgument.m_91449_()).executes(context -> TensuraCommand.setOwner((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), EntityArgument.m_91452_((CommandContext)context, (String)"owner"), true)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"neutral").then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> TensuraCommand.setNeutral((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), EntityArgument.m_91452_((CommandContext)context, (String)"target"), false))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> TensuraCommand.setNeutral((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets"), EntityArgument.m_91452_((CommandContext)context, (String)"target"), true))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stat").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_CHECK_STAT))).then(Commands.m_82127_((String)"ep").executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"target");
            if (!(entity instanceof LivingEntity)) {
                return 1;
            }
            LivingEntity living = (LivingEntity)entity;
            Double amount = TensuraEPCapability.getEP(living);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.ep.get", (Object[])new Object[]{entity.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"spiritualHP").executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"target");
            if (!(entity instanceof LivingEntity)) {
                return 1;
            }
            LivingEntity living = (LivingEntity)entity;
            Double amount = TensuraEPCapability.getSpiritualHealth(living);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.spiritual.get", (Object[])new Object[]{living.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))).then(Commands.m_82127_((String)"awakening").then(Commands.m_82127_((String)"humanKill").executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"target");
            if (!(entity instanceof LivingEntity)) {
                return 1;
            }
            LivingEntity living = (LivingEntity)entity;
            int amount = TensuraEPCapability.getHumanKill(living);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.human_kill.get", (Object[])new Object[]{living.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_CHECK_SKILL))).then(Commands.m_82129_((String)"skills", (ArgumentType)SkillArgument.skill()).executes(context -> TensuraCommand.getSkill((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), skill -> skill instanceof TensuraSkill))).then(Commands.m_82129_((String)"excludeLearning", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), skill -> skill instanceof TensuraSkill, BoolArgumentType.getBool((CommandContext)context, (String)"excludeLearning"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), skill -> skill instanceof Skill))).then(Commands.m_82127_((String)"resistance").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        })))).then(Commands.m_82127_((String)"intrinsic").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        })))).then(Commands.m_82127_((String)"common").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        })))).then(Commands.m_82127_((String)"extra").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        })))).then(Commands.m_82127_((String)"unique").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        })))).then(Commands.m_82127_((String)"ultimate").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        }))))).then(Commands.m_82127_((String)"magic").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), skill -> skill instanceof Magic)))).then(Commands.m_82127_((String)"battlewill").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"target"), skill -> skill instanceof Battewill))))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stat").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_CHECK_STAT))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"magicule").then(Commands.m_82127_((String)"current").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            Double amount = TensuraPlayerCapability.getMagicule((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"max").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            Double amount = TensuraPlayerCapability.getBaseMagicule((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.get_max", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"aura").then(Commands.m_82127_((String)"current").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            Double amount = TensuraPlayerCapability.getAura((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.aura.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"max").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            Double amount = TensuraPlayerCapability.getBaseAura((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.aura.get_max", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resetCounter").then(Commands.m_82127_((String)"value").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            int amount = TensuraPlayerCapability.getResetCounter((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.reset_counter.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"check").executes(context -> TensuraCommand.checkCounterResetRequirement((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"awakening").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_CHECK_AWAKENING))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"demonLord").then(Commands.m_82127_((String)"soul").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            int amount = TensuraPlayerCapability.getSoulPoints((Player)player) / 1000;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.demon_lord.soul.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"seed").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.demon_lord.seed.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isDemonLordSeed((Player)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"awakened").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.demon_lord.awakened.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isTrueDemonLord((Player)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hero").then(Commands.m_82127_((String)"blessed").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.spirit.blessed.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isBlessed((Player)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"egg").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.hero.egg.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isHeroEgg((Player)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"awakened").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.hero.awakened.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isTrueHero((LivingEntity)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"race").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_CHECK_RACE))).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
            if (race == null) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.race.no_race", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.RED), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.race.get", (Object[])new Object[]{player.m_7755_(), race.getName()}).m_130940_(ChatFormatting.AQUA), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spirit").requires(commandSourceStack -> PermissionHelper.hasPermissionOrIsConsole(commandSourceStack, TensuraPermissions.PLAYER_CHECK_STAT))).executes(context -> TensuraCommand.getSpiritList((CommandSourceStack)context.getSource(), (Player)EntityArgument.m_91474_((CommandContext)context, (String)"target")))).then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"spirit", (ArgumentType)IntegerArgumentType.integer((int)0, (int)6)).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            int spirit = IntegerArgumentType.getInteger((CommandContext)context, (String)"spirit");
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.spirit.get", (Object[])new Object[]{player.m_7755_(), MagicElemental.byId(spirit).getName(), TensuraSkillCapability.getSpiritLevel((Player)player, spirit)}).m_130940_(ChatFormatting.AQUA), true);
            return 1;
        })))).then(Commands.m_82127_((String)"cooldown").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.spirit.cooldown.get", (Object[])new Object[]{player.m_7755_(), TensuraSkillCapability.getSpiritCooldown((Player)player)}).m_130940_(ChatFormatting.AQUA), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"race").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
            if (race == null) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.race.no_race", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.RED), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.race.get", (Object[])new Object[]{player.m_7755_(), race.getName()}).m_130940_(ChatFormatting.AQUA), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").then(Commands.m_82129_((String)"skills", (ArgumentType)SkillArgument.skill()).suggests(SkillArgument.getObtainedSkillSuggestions()).executes(context -> TensuraCommand.getSkill((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skills"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), skill -> skill instanceof TensuraSkill))).then(Commands.m_82129_((String)"excludeLearning", (ArgumentType)BoolArgumentType.bool()).executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), skill -> skill instanceof TensuraSkill, BoolArgumentType.getBool((CommandContext)context, (String)"excludeLearning"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), skill -> skill instanceof Skill))).then(Commands.m_82127_((String)"resistance").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        })))).then(Commands.m_82127_((String)"intrinsic").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        })))).then(Commands.m_82127_((String)"common").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        })))).then(Commands.m_82127_((String)"extra").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        })))).then(Commands.m_82127_((String)"unique").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        })))).then(Commands.m_82127_((String)"ultimate").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        }))))).then(Commands.m_82127_((String)"magic").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), skill -> skill instanceof Magic)))).then(Commands.m_82127_((String)"battlewill").executes(context -> TensuraCommand.getSkillList((CommandSourceStack)context.getSource(), (Entity)((CommandSourceStack)context.getSource()).m_230896_(), skill -> skill instanceof Battewill)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spirit").executes(context -> TensuraCommand.getSpiritList((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_230896_()))).then(Commands.m_82129_((String)"spirit", (ArgumentType)IntegerArgumentType.integer((int)0, (int)6)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            int spirit = IntegerArgumentType.getInteger((CommandContext)context, (String)"spirit");
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.spirit.get", (Object[])new Object[]{player.m_7755_(), MagicElemental.byId(spirit).getName(), TensuraSkillCapability.getSpiritLevel((Player)player, spirit)}).m_130940_(ChatFormatting.AQUA), true);
            return 1;
        }))).then(Commands.m_82127_((String)"cooldown").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.spirit.cooldown.get", (Object[])new Object[]{player.m_7755_(), TensuraSkillCapability.getSpiritCooldown((Player)player)}).m_130940_(ChatFormatting.AQUA), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stat").then(Commands.m_82127_((String)"ep").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            Double amount = TensuraEPCapability.getEP((LivingEntity)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.ep.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"magicule").then(Commands.m_82127_((String)"current").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            Double amount = TensuraPlayerCapability.getMagicule((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"max").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            Double amount = TensuraPlayerCapability.getBaseMagicule((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.get_max", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"aura").then(Commands.m_82127_((String)"current").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            Double amount = TensuraPlayerCapability.getAura((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.aura.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"max").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            Double amount = TensuraPlayerCapability.getBaseAura((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.aura.get_max", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))).then(Commands.m_82127_((String)"spiritualHP").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            Double amount = TensuraEPCapability.getSpiritualHealth((LivingEntity)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.spiritual.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resetCounter").then(Commands.m_82127_((String)"value").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            int amount = TensuraPlayerCapability.getResetCounter((Player)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.reset_counter.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"check").executes(context -> TensuraCommand.checkCounterResetRequirement((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_230896_())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"awakening").then(Commands.m_82127_((String)"humanKill").executes(context -> {
            ServerPlayer entity = ((CommandSourceStack)context.getSource()).m_230896_();
            int amount = TensuraEPCapability.getHumanKill((LivingEntity)entity);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.human_kill.get", (Object[])new Object[]{entity.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"demonLord").then(Commands.m_82127_((String)"soul").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            int amount = TensuraPlayerCapability.getSoulPoints((Player)player) / 1000;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.demon_lord.soul.get", (Object[])new Object[]{player.m_7755_(), amount}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"seed").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.demon_lord.seed.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isDemonLordSeed((Player)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"awakened").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.demon_lord.awakened.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isTrueDemonLord((Player)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hero").then(Commands.m_82127_((String)"blessed").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.spirit.blessed.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isBlessed((Player)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"egg").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.hero.egg.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isHeroEgg((Player)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        }))).then(Commands.m_82127_((String)"awakened").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.hero.awakened.get", (Object[])new Object[]{player.m_7755_(), TensuraPlayerCapability.isTrueHero((LivingEntity)player)}).m_130940_(ChatFormatting.AQUA), false);
            return 1;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"worldData").requires(stack -> stack.m_6761_(3))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"labyrinth").then(Commands.m_82127_((String)"regenerate").then(Commands.m_82129_((String)"regenerate", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            if (BoolArgumentType.getBool((CommandContext)context, (String)"regenerate")) {
                LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).setLoaded(false);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"tensura.command.labyrinth.regenerate"), true);
            } else {
                LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).setLoaded(true);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"tensura.command.labyrinth.regenerate.false"), true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"entrance").executes(context -> {
            Vec3 location = LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).getEntrancePos();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.entrance.get", (Object[])new Object[]{location.f_82479_, location.f_82480_, location.f_82481_}), true);
            return 1;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Vec3 location = Vec3Argument.m_120844_((CommandContext)context, (String)"location");
            LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).setEntrancePos(location);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.entrance.set", (Object[])new Object[]{location.f_82479_, location.f_82480_, location.f_82481_}), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"colossusPos").executes(context -> {
            Vec3 location = LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).getColossusPos();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.colossus_pos.get", (Object[])new Object[]{location.f_82479_, location.f_82480_, location.f_82481_}), true);
            return 1;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Vec3 location = Vec3Argument.m_120844_((CommandContext)context, (String)"location");
            LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).setColossusPos(location);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.colossus_pos.set", (Object[])new Object[]{location.f_82479_, location.f_82480_, location.f_82481_}), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"passing").then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            if (LabyrinthSaveData.isEntityPassedColossus((Entity)player)) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.passed_list.check_true", (Object[])new Object[]{player.m_7755_()}), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.passed_list.check_false", (Object[])new Object[]{player.m_7755_()}), false);
            }
            return 1;
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            LabyrinthSaveData.addPassedEntity((LivingEntity)player, false);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.passed_list.add", (Object[])new Object[]{player.m_7755_()}), true);
            return 1;
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            LabyrinthSaveData.removePassedEntity((LivingEntity)player, false);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.passed_list.remove", (Object[])new Object[]{player.m_7755_()}), true);
            return 1;
        })))).then(Commands.m_82127_((String)"won").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"won", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
            boolean won = BoolArgumentType.getBool((CommandContext)context, (String)"won");
            TensuraEffectsCapability.getFrom((LivingEntity)player).ifPresent(cap -> cap.setColossusWon(won));
            TensuraEffectsCapability.sync((LivingEntity)player);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.passed_list.won", (Object[])new Object[]{player.m_7755_(), won}), true);
            return 1;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"passedEntrance").executes(context -> {
            Vec3 location = LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).getPassedEntrance();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.passed_entrance.get", (Object[])new Object[]{location.f_82479_, location.f_82480_, location.f_82481_}), true);
            return 1;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Vec3 location = Vec3Argument.m_120844_((CommandContext)context, (String)"location");
            LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).setPassedEntrance(location);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.passed_entrance.set", (Object[])new Object[]{location.f_82479_, location.f_82480_, location.f_82481_}), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fallOff").executes(context -> {
            Vec3 location = LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).getFallOffPos();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.fall_off.get", (Object[])new Object[]{location.f_82479_, location.f_82480_, location.f_82481_}), true);
            return 1;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> {
            Vec3 location = Vec3Argument.m_120844_((CommandContext)context, (String)"location");
            LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).setFallOffPos(location);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.fall_off.set", (Object[])new Object[]{location.f_82479_, location.f_82480_, location.f_82481_}), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"height").executes(context -> {
            double y = LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).getStartFallOffY();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.fall_off_y.get", (Object[])new Object[]{y}), true);
            return 1;
        })).then(Commands.m_82129_((String)"height", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            double y = DoubleArgumentType.getDouble((CommandContext)context, (String)"height");
            LabyrinthSaveData.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).setStartFallOffY(y);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.labyrinth.fall_off_y.set", (Object[])new Object[]{y}), true);
            return 1;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"magicule").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.area_get", (Object[])new Object[]{MagiculeAPI.getMagicule((LivingEntity)player)}), true);
            return 1;
        })).then(Commands.m_82127_((String)"max").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.area_get.max", (Object[])new Object[]{MagiculeAPI.getMaxMagicule((LivingEntity)player)}), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reinitialize").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            TensuraCommand.reinitializeMagiculeAt(player.f_19853_.m_46745_(player.m_20183_()));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.reinitialized", (Object[])new Object[]{1}), true);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)context, (String)"center");
            TensuraCommand.reinitializeMagiculeAt(player.f_19853_.m_46745_(pos));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.reinitialized", (Object[])new Object[]{1}), true);
            return 1;
        })).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)context, (String)"center");
            int radius = IntegerArgumentType.getInteger((CommandContext)context, (String)"radius");
            HashSet<LevelChunk> chunks = new HashSet<LevelChunk>();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    chunks.add(player.f_19853_.m_46745_(pos.m_7918_(x, 0, z)));
                }
            }
            for (LevelChunk chunk : chunks) {
                TensuraCommand.reinitializeMagiculeAt(chunk);
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.magicule.reinitialized", (Object[])new Object[]{chunks.size()}), true);
            return 1;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trulyUnique").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TensuraCommand.trulyUniqueAdd((CommandSourceStack)context.getSource(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skill"), (Player)EntityArgument.m_91474_((CommandContext)context, (String)"player"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).executes(context -> TensuraCommand.trulyUniqueRemove((CommandSourceStack)context.getSource(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skill")))))).then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).executes(context -> TensuraCommand.trulyUniqueCheck((CommandSourceStack)context.getSource(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skill")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").then(Commands.m_82127_((String)"taken").executes(context -> TensuraCommand.getTrulyUniqueTakenList((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"remaining").executes(context -> TensuraCommand.getTrulyUniqueRemainList((CommandSourceStack)context.getSource())))))));
    }

    private static void reinitializeMagiculeAt(LevelChunk chunk) {
        ((MagiculeChunkCapabilityImpl)MagiculeChunkCapabilityImpl.get(chunk)).reinitialize();
    }

    private static int resetEverything(CommandSourceStack stack, Collection<? extends ServerPlayer> pTargets) {
        for (ServerPlayer serverPlayer : pTargets) {
            ResetScrollItem.resetEverything(serverPlayer);
            TensuraCommand.sendSuccess(stack, (Entity)serverPlayer, Component.m_237110_((String)"tensura.command.reset.all", (Object[])new Object[]{serverPlayer.m_7755_()}));
        }
        return 1;
    }

    private static int resetAwakening(CommandSourceStack stack, Collection<? extends Player> pTargets) {
        for (Player player : pTargets) {
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setDemonLordSeed(false);
                cap.setTrueDemonLord(false);
                cap.setHeroEgg(false);
                cap.setHeroEgg(false);
                cap.setSoulPoints(0);
            });
            TensuraPlayerCapability.sync(player);
            TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.reset.awakening", (Object[])new Object[]{player.m_7755_()}));
        }
        return 1;
    }

    private static int resetRace(CommandSourceStack stack, Collection<? extends ServerPlayer> pTargets, @Nullable Race race) {
        for (ServerPlayer serverPlayer : pTargets) {
            if (race == null) {
                ResetScrollItem.resetRace(serverPlayer);
                TensuraCommand.sendSuccess(stack, (Entity)serverPlayer, Component.m_237110_((String)"tensura.command.reset.race", (Object[])new Object[]{serverPlayer.m_7755_()}));
                continue;
            }
            MinecraftServer server = serverPlayer.m_20194_();
            if (server != null) {
                ServerStatsCounter stats = server.m_6846_().m_11239_((Player)serverPlayer);
                stats.m_12850_();
                for (Stat stat : stats.m_12851_()) {
                    stats.m_6085_((Player)serverPlayer, stat, 0);
                }
            }
            TensuraPlayerCapability.getFrom((Player)serverPlayer).ifPresent(cap -> {
                if (cap.getRace() != null) {
                    SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                    Iterator iterator = storage.getLearnedSkills().iterator();
                    while (iterator.hasNext()) {
                        Object patt160826$temp = iterator.next();
                        if (!(patt160826$temp instanceof TensuraSkillInstance)) continue;
                        TensuraSkillInstance instance = (TensuraSkillInstance)((Object)((Object)((Object)patt160826$temp)));
                        if (!ResetScrollItem.isIntrinsicSkills((Player)player, cap, cap.getRace(), instance) || MinecraftForge.EVENT_BUS.post((Event)new RemoveSkillEvent((ManasSkillInstance)instance, (Entity)player))) continue;
                        iterator.remove();
                    }
                    storage.syncAll();
                }
                cap.clearIntrinsicSkills();
            });
            TensuraPlayerCapability.sync((Player)serverPlayer);
            RaceSelectionMenu.setRace((Player)serverPlayer, race, true, false);
            TensuraEPCapability.getFrom((LivingEntity)serverPlayer).ifPresent(cap -> {
                cap.setName(null);
                cap.setTemporaryOwner(null);
                cap.setPermanentOwner(null);
            });
            TensuraEPCapability.sync((LivingEntity)serverPlayer);
            ResetScrollItem.resetFlight((Player)serverPlayer);
            TensuraCommand.sendSuccess(stack, (Entity)serverPlayer, Component.m_237110_((String)"tensura.command.reset.race", (Object[])new Object[]{serverPlayer.m_7755_()}));
        }
        return 1;
    }

    private static int resetSchematics(CommandSourceStack stack, Collection<? extends Player> pTargets) {
        for (Player player : pTargets) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TensuraAdvancementsHelper.revokeAllTensuraAdvancements(serverPlayer);
            }
            SmithingCapability.getFrom(player).ifPresent(ISmithingCapability::clearSchematics);
            SmithingCapability.sync(player);
            TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.reset.schematic", (Object[])new Object[]{player.m_7755_()}));
        }
        return 1;
    }

    private static int resetStat(CommandSourceStack stack, Collection<? extends Player> pTargets) {
        for (Player player : pTargets) {
            MinecraftServer server = player.m_20194_();
            if (server != null) {
                ServerStatsCounter stats = server.m_6846_().m_11239_(player);
                stats.m_12850_();
                for (Stat stat : stats.m_12851_()) {
                    stats.m_6085_(player, stat, 0);
                }
            }
            TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.reset.stat", (Object[])new Object[]{player.m_7755_()}));
        }
        return 1;
    }

    private static int trulyUniqueAdd(CommandSourceStack stack, ManasSkill skill, Player player) {
        ServerLevel level = stack.m_81372_();
        if (!level.m_46469_().m_46207_(TensuraGameRules.TRULY_UNIQUE)) {
            stack.m_81352_((Component)Component.m_237115_((String)"tensura.truly_unique.off"));
            return 1;
        }
        UniqueSkillSaveData saveData = UniqueSkillSaveData.get(level.m_7654_().m_129783_());
        if (saveData.hasSkill(skill.getRegistryName())) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.truly_unique.already_have", (Object[])new Object[]{skill.getName()}).m_130940_(ChatFormatting.RED));
        } else {
            saveData.addSkill(skill.getRegistryName(), player.m_20148_());
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.truly_unique.added", (Object[])new Object[]{skill.getName(), player.m_7755_()}).m_130940_(ChatFormatting.DARK_GREEN), true);
        }
        return 1;
    }

    private static int grantRandomSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, Predicate<ManasSkill> predicate) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            List<ManasSkill> list = SkillAPI.getSkillRegistry().getValues().stream().filter(manasSkill -> {
                if (storage.getSkill(manasSkill).isPresent() && ((ManasSkillInstance)storage.getSkill(manasSkill).get()).getMastery() > 0) {
                    return false;
                }
                return predicate.test((ManasSkill)manasSkill);
            }).toList();
            if (list.isEmpty()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.granted_all", (Object[])new Object[]{0, entity.m_7755_()}));
                continue;
            }
            ManasSkill skill = list.get(entity.m_9236_().f_46441_.m_188503_(list.size()));
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            TensuraSkillInstance instance = new TensuraSkillInstance(skill);
            instance.getOrCreateTag().m_128379_("NoMagiculeCost", true);
            if (SkillUtils.learnSkill(living, instance)) {
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.granted", (Object[])new Object[]{skill.getName(), entity.m_7755_()}));
                continue;
            }
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.already_has", (Object[])new Object[]{entity.m_7755_(), skill.getName()}));
        }
        return 1;
    }

    private static int grantSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, ManasSkill skill) {
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            TensuraSkillInstance instance = new TensuraSkillInstance(skill);
            instance.getOrCreateTag().m_128379_("NoMagiculeCost", true);
            if (SkillUtils.learnSkill(living, instance)) {
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.granted", (Object[])new Object[]{skill.getName(), entity.m_7755_()}));
                continue;
            }
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.already_has", (Object[])new Object[]{entity.m_7755_(), skill.getName()}));
        }
        return 1;
    }

    private static int grantAllSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, Predicate<ManasSkill> predicate) {
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            int i = 0;
            List<ManasSkill> newSkills = SkillAPI.getSkillRegistry().getValues().stream().filter(skill -> predicate.test((ManasSkill)skill) && !SkillUtils.hasSkill(entity, skill)).toList();
            for (ManasSkill skill2 : newSkills) {
                TensuraSkillInstance instance = new TensuraSkillInstance(skill2);
                instance.getOrCreateTag().m_128379_("NoMagiculeCost", true);
                if (!SkillUtils.learnSkill(living, instance)) continue;
                ++i;
            }
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.granted_all", (Object[])new Object[]{i, entity.m_7755_()}));
        }
        return 1;
    }

    private static int revokeSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, ManasSkill skill) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            if (storage.getSkill(skill).isPresent()) {
                storage.forgetSkill(skill);
                storage.syncAll();
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.revoked", (Object[])new Object[]{skill.getName(), entity.m_7755_()}), ChatFormatting.RED);
                continue;
            }
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{entity.m_7755_(), skill.getName()}));
        }
        return 1;
    }

    private static int revokeAllSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, Predicate<ManasSkill> predicate) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            int i = 0;
            Iterator iterator = storage.getLearnedSkills().iterator();
            while (iterator.hasNext()) {
                TensuraSkillInstance instance;
                Object e = iterator.next();
                if (!(e instanceof TensuraSkillInstance) || !predicate.test((instance = (TensuraSkillInstance)((Object)e)).getSkill()) || MinecraftForge.EVENT_BUS.post((Event)new RemoveSkillEvent((ManasSkillInstance)instance, entity))) continue;
                iterator.remove();
                ++i;
            }
            if (i > 0) {
                storage.syncAll();
            }
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.revoked_all", (Object[])new Object[]{i, entity.m_7755_()}), ChatFormatting.RED);
        }
        return 1;
    }

    private static int masterSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, ManasSkill skill, int amount) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            Optional optional = storage.getSkill(skill);
            if (optional.isEmpty()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{entity.m_7755_(), skill.getName()}));
                continue;
            }
            if (amount > skill.getMaxMastery()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.mastery.above_max", (Object[])new Object[]{((ManasSkillInstance)optional.get()).getSkill().getName(), skill.getMaxMastery()}));
                continue;
            }
            ((ManasSkillInstance)optional.get()).setMastery(amount);
            ((ManasSkillInstance)optional.get()).markDirty();
            storage.syncChanges();
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.mastery_point", (Object[])new Object[]{skill.getName(), entity.m_7755_(), amount}));
            if (amount != skill.getMaxMastery()) continue;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ((ManasSkillInstance)optional.get()).onSkillMastered(livingEntity);
            }
            entity.m_213846_((Component)Component.m_237110_((String)"tensura.skill.mastery", (Object[])new Object[]{((ManasSkillInstance)optional.get()).getSkill().getName()}).m_130940_(ChatFormatting.GREEN));
        }
        return 1;
    }

    private static int masterAllSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, int amount, Predicate<ManasSkill> predicate) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            if (storage.getLearnedSkills().isEmpty()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.empty_storage", (Object[])new Object[]{entity.m_7755_()}));
                continue;
            }
            int i = 0;
            int j = 0;
            for (ManasSkillInstance instance : List.copyOf(storage.getLearnedSkills())) {
                if (instance == null || !predicate.test(instance.getSkill())) continue;
                ManasSkill skill = instance.getSkill();
                instance.setMastery(Math.min(amount, skill.getMaxMastery()));
                instance.markDirty();
                ++i;
                if (amount < skill.getMaxMastery()) continue;
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    instance.onSkillMastered(livingEntity);
                }
                ++j;
            }
            if (i > 0) {
                storage.syncChanges();
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.mastery_point.all", (Object[])new Object[]{entity.m_7755_(), i, amount}));
                if (j <= 0) continue;
                entity.m_213846_((Component)Component.m_237110_((String)"tensura.skill.mastery.all", (Object[])new Object[]{entity.m_7755_(), j}).m_130940_(ChatFormatting.GREEN));
                continue;
            }
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.mastery.no_changes", (Object[])new Object[]{entity.m_7755_()}));
        }
        return 1;
    }

    private static int masterMaxAllSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, Predicate<ManasSkill> predicate) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            if (storage.getLearnedSkills().isEmpty()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.empty_storage", (Object[])new Object[]{entity.m_7755_()}));
                continue;
            }
            int i = 0;
            for (ManasSkillInstance instance : List.copyOf(storage.getLearnedSkills())) {
                if (instance == null || !predicate.test(instance.getSkill())) continue;
                ManasSkill skill = instance.getSkill();
                instance.setMastery(skill.getMaxMastery());
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    instance.onSkillMastered(living);
                }
                instance.markDirty();
                ++i;
            }
            if (i > 0) {
                storage.syncChanges();
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.mastery.all", (Object[])new Object[]{entity.m_7755_(), i}).m_130940_(ChatFormatting.GREEN));
                continue;
            }
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.mastery.no_changes", (Object[])new Object[]{entity.m_7755_()}));
        }
        return 1;
    }

    private static int cooldownSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, ManasSkill skill, int amount) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            Optional optional = storage.getSkill(skill);
            if (optional.isEmpty()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{entity.m_7755_(), skill.getName()}));
                continue;
            }
            if (amount < 0) {
                amount = 0;
            }
            ((ManasSkillInstance)optional.get()).setCoolDown(amount);
            ((ManasSkillInstance)optional.get()).markDirty();
            storage.syncChanges();
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.set_cooldown", (Object[])new Object[]{skill.getName(), entity.m_7755_(), amount}));
        }
        return 1;
    }

    private static int cooldownAllSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, int amount) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            if (storage.getLearnedSkills().isEmpty()) {
                stack.m_81352_((Component)Component.m_237115_((String)"tensura.skill.empty_storage"));
            }
            int i = 0;
            for (ManasSkillInstance skillInstance : storage.getLearnedSkills()) {
                if (skillInstance == null) continue;
                if (amount < 0) {
                    amount = 0;
                }
                skillInstance.setCoolDown(amount);
                skillInstance.markDirty();
                ++i;
            }
            if (i > 0) {
                storage.syncChanges();
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.set_cooldown.all", (Object[])new Object[]{entity.m_7755_(), amount}));
                continue;
            }
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.set_cooldown.all.no_changes", (Object[])new Object[]{entity.m_7755_()}));
        }
        return 1;
    }

    private static int learnSkillMode(CommandSourceStack stack, Collection<? extends Entity> pTargets, ManasSkill manasSkill, int mode, int amount) {
        if (!(manasSkill instanceof TensuraSkill)) {
            stack.m_81352_((Component)Component.m_237115_((String)"tensura.argument.skill.invalid"));
            return 1;
        }
        TensuraSkill skill = (TensuraSkill)manasSkill;
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            Optional optional = storage.getSkill((ManasSkill)skill);
            if (optional.isEmpty()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{entity.m_7755_(), skill.getName()}));
                continue;
            }
            if (mode > skill.modes()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.mode_learning.no_mode", (Object[])new Object[]{skill.getName(), mode}));
                continue;
            }
            String id = skill.modeLearningId(mode);
            if (id.equals("None")) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.mode_learning.no_learn", (Object[])new Object[]{skill.getModeName(mode), skill.getName()}));
                continue;
            }
            ((ManasSkillInstance)optional.get()).getOrCreateTag().m_128405_(id, amount);
            ((ManasSkillInstance)optional.get()).markDirty();
            storage.syncChanges();
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.mode_learning.success", (Object[])new Object[]{skill.getModeName(mode), skill.getName(), amount, entity.m_7755_()}));
        }
        return 1;
    }

    private static int learnSkillModeAll(CommandSourceStack stack, Collection<? extends Entity> pTargets, ManasSkill manasSkill, int amount) {
        if (!(manasSkill instanceof TensuraSkill)) {
            stack.m_81352_((Component)Component.m_237115_((String)"tensura.argument.skill.invalid"));
            return 1;
        }
        TensuraSkill skill = (TensuraSkill)manasSkill;
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            Optional optional = storage.getSkill((ManasSkill)skill);
            if (optional.isEmpty()) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{entity.m_7755_(), skill.getName()}));
                continue;
            }
            int j = 0;
            for (int i = 1; i <= skill.modes(); ++i) {
                String id = skill.modeLearningId(i);
                if (id.equals("None")) continue;
                ((ManasSkillInstance)optional.get()).getOrCreateTag().m_128405_(id, amount);
                ((ManasSkillInstance)optional.get()).markDirty();
                ++j;
            }
            if (j > 0) {
                storage.syncChanges();
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.mode_learning.success_all", (Object[])new Object[]{j, skill.getName(), amount, entity.m_7755_()}));
                continue;
            }
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.mode_learning.no_learn_all", (Object[])new Object[]{skill.getName()}));
        }
        return 1;
    }

    private static int learnSkillModeEverything(CommandSourceStack stack, Collection<? extends Entity> pTargets) {
        for (Entity entity : pTargets) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
            if (storage.getLearnedSkills().isEmpty()) {
                stack.m_81352_((Component)Component.m_237115_((String)"tensura.skill.empty_storage"));
                continue;
            }
            int i = 0;
            for (ManasSkillInstance skillInstance : storage.getLearnedSkills()) {
                ManasSkill manasSkill;
                if (skillInstance == null || !((manasSkill = skillInstance.getSkill()) instanceof TensuraSkill)) continue;
                TensuraSkill skill = (TensuraSkill)manasSkill;
                int j = 0;
                for (int k = 1; k <= skill.modes(); ++k) {
                    String id = skill.modeLearningId(k);
                    if (id.equals("None")) continue;
                    skillInstance.getOrCreateTag().m_128405_(id, 200);
                    skillInstance.markDirty();
                    ++j;
                }
                if (j <= 0) continue;
                ++i;
            }
            if (i > 0) {
                storage.syncChanges();
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.skill.mode_learning.success_everything", (Object[])new Object[]{entity.m_7755_()}));
                continue;
            }
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.set_cooldown.all.no_changes", (Object[])new Object[]{entity.m_7755_()}));
        }
        return 1;
    }

    private static int toggleSkill(CommandSourceStack stack, Collection<? extends Entity> pTargets, ManasSkill skill) {
        for (Entity entity : pTargets) {
            ManasSkillInstance skillInstance;
            LivingEntity living;
            SkillStorage storage;
            Optional instance;
            if (skill.getRegistryName() == null || !(entity instanceof LivingEntity) || (instance = (storage = SkillAPI.getSkillsFrom((Entity)(living = (LivingEntity)entity))).getSkill(skill)).isEmpty() || !skill.canBeToggled(skillInstance = (ManasSkillInstance)instance.get(), living) || !skillInstance.canInteractSkill(living)) continue;
            if (skillInstance.isToggled()) {
                skillInstance.setToggled(false);
                skillInstance.onToggleOff(living);
                stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.toggle_off", (Object[])new Object[]{skill.getName(), living.m_7755_()}), false);
            } else {
                skillInstance.setToggled(true);
                skillInstance.onToggleOn(living);
                stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.toggle_on", (Object[])new Object[]{skill.getName(), living.m_7755_()}), false);
            }
            storage.syncChanges();
        }
        return 1;
    }

    private static int toggleEverything(CommandSourceStack stack, Collection<? extends Entity> pTargets, boolean toggle, Predicate<ManasSkill> predicate) {
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            int i = 0;
            for (ManasSkillInstance instance : SkillAPI.getSkillsFrom((Entity)living).getLearnedSkills()) {
                if (!predicate.test(instance.getSkill()) || !instance.getSkill().canBeToggled(instance, living) || !instance.getSkill().canInteractSkill(instance, living) || instance.isToggled() == toggle) continue;
                instance.setToggled(toggle);
                if (toggle) {
                    instance.onToggleOn(living);
                } else {
                    instance.onToggleOff(living);
                }
                ++i;
            }
            String message = toggle ? "tensura.skill.toggle_all.on" : "tensura.skill.toggle_all.off";
            stack.m_81354_((Component)Component.m_237110_((String)message, (Object[])new Object[]{i, living.m_7755_()}), false);
        }
        return 1;
    }

    private static int setRace(CommandSourceStack stack, Collection<? extends Player> pTargets, Race race, boolean resetEP, boolean grantIntrinsic) {
        for (Player player : pTargets) {
            List<TensuraSkill> intrinsic;
            TensuraPlayerCapability.getFrom(player).ifPresent(data -> {
                data.setRace((LivingEntity)player, race, resetEP);
                data.setTrackedEvolution(player, null);
            });
            if (grantIntrinsic && !(intrinsic = race.getIntrinsicSkills(player)).isEmpty()) {
                for (ManasSkill manasSkill : intrinsic) {
                    ManasSkillInstance instance = new ManasSkillInstance(manasSkill);
                    if (!SkillAPI.getSkillsFrom((Entity)player).learnSkill(instance)) continue;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    if (!instance.canBeToggled((LivingEntity)player)) continue;
                    instance.setToggled(true);
                    instance.onToggleOn((LivingEntity)player);
                }
            }
            ResetScrollItem.resetFlight(player);
            TensuraPlayerCapability.sync(player);
            TensuraEPCapability.getEP((LivingEntity)player);
            TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.race.edit", (Object[])new Object[]{player.m_7755_(), Objects.requireNonNull(race.getName())}));
        }
        return 1;
    }

    private static int setMajin(CommandSourceStack stack, Collection<? extends Entity> pTargets, boolean majin) {
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity entity2 = (LivingEntity)entity;
            TensuraEPCapability.setMajin(entity2, majin);
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.command.race.majin", (Object[])new Object[]{entity2.m_7755_(), majin}));
        }
        return 1;
    }

    private static int setMagicule(CommandSourceStack stack, Collection<? extends Player> pTargets, double magicule, boolean add) {
        for (Player player : pTargets) {
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setMagicule(magicule == -1.0 ? player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()) : (add ? cap.getMagicule() + magicule : magicule));
                TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.magicule.set", (Object[])new Object[]{player.m_7755_(), cap.getMagicule()}));
            });
            TensuraPlayerCapability.sync(player);
        }
        return 1;
    }

    private static int setMaxMagicule(CommandSourceStack stack, Collection<? extends Player> pTargets, double magicule, boolean resetCurrent, boolean add) {
        for (Player player : pTargets) {
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setBaseMagicule(add ? cap.getMagicule() + magicule : magicule, (LivingEntity)player);
                if (resetCurrent) {
                    cap.setMagicule(cap.getBaseMagicule());
                }
                TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.magicule.set_max", (Object[])new Object[]{player.m_7755_(), cap.getBaseMagicule()}));
            });
            TensuraPlayerCapability.sync(player);
            TensuraEPCapability.updateEP((LivingEntity)player);
        }
        return 1;
    }

    private static int setAura(CommandSourceStack stack, Collection<? extends Player> pTargets, double aura, boolean add) {
        for (Player player : pTargets) {
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setAura(aura == -1.0 ? player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()) : (add ? cap.getAura() + aura : aura));
                TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.aura.set", (Object[])new Object[]{player.m_7755_(), cap.getAura()}));
            });
            TensuraPlayerCapability.sync(player);
        }
        return 1;
    }

    private static int setMaxAura(CommandSourceStack stack, Collection<? extends Player> pTargets, double aura, boolean resetCurrent, boolean add) {
        for (Player player : pTargets) {
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setBaseAura(add ? cap.getAura() + aura : aura, (LivingEntity)player);
                if (resetCurrent) {
                    cap.setAura(cap.getBaseAura());
                }
                TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.aura.set_max", (Object[])new Object[]{player.m_7755_(), cap.getBaseAura()}));
            });
            TensuraPlayerCapability.sync(player);
            TensuraEPCapability.updateEP((LivingEntity)player);
        }
        return 1;
    }

    private static int setSpiritualHP(CommandSourceStack stack, Collection<? extends Entity> pTargets, double HP, boolean add) {
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            TensuraEPCapability.getFrom(living).ifPresent(cap -> {
                cap.setSpiritualHealth(HP == -1.0 ? living.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) : (add ? cap.getSpiritualHealth() + HP : HP));
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.command.spiritual.set", (Object[])new Object[]{entity.m_7755_(), cap.getSpiritualHealth()}));
            });
            TensuraEPCapability.sync(living);
        }
        return 1;
    }

    private static int setEP(CommandSourceStack stack, Collection<? extends Entity> pTargets, double EP, boolean add, boolean update) {
        for (Entity entity : pTargets) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                double half = EP / 2.0;
                TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                    cap.setBaseMagicule(add ? cap.getBaseMagicule() + half : half, (LivingEntity)player);
                    cap.setMagicule(cap.getBaseMagicule());
                    cap.setBaseAura(add ? cap.getBaseAura() + half : half, (LivingEntity)player);
                    cap.setAura(cap.getBaseAura());
                    TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.command.ep.set", (Object[])new Object[]{entity.m_7755_(), cap.getBaseMagicule() + cap.getBaseAura()}));
                });
                TensuraPlayerCapability.sync(player);
                continue;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            TensuraEPCapability.getFrom(living).ifPresent(cap -> {
                cap.setEP(living, add ? cap.getEP() + EP : EP, update);
                cap.setCurrentEP(living, cap.getEP());
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.command.ep.set", (Object[])new Object[]{entity.m_7755_(), cap.getEP()}));
            });
        }
        return 1;
    }

    private static int setResetCounter(CommandSourceStack stack, Collection<? extends Player> pTargets, int i, boolean add) {
        for (Player player : pTargets) {
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                cap.setResetCounter(add ? cap.getResetCounter() + i : i);
                TensuraCommand.sendSuccess(stack, (Entity)player, Component.m_237110_((String)"tensura.command.reset_counter.set", (Object[])new Object[]{player.m_7755_(), cap.getResetCounter()}));
                TensuraPlayerCapability.sync(player);
            });
        }
        return 1;
    }

    private static int setName(CommandSourceStack stack, Collection<? extends Entity> pTargets, @Nullable String name) {
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity entity2 = (LivingEntity)entity;
            TensuraEPCapability.getFrom(entity2).ifPresent(cap -> cap.setName(name));
            TensuraEPCapability.sync(entity2);
            if (name != null) {
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.command.owner.name.set", (Object[])new Object[]{entity2.m_7755_(), name}));
                continue;
            }
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)"tensura.command.owner.name.remove", (Object[])new Object[]{entity2.m_7755_()}), ChatFormatting.RED);
        }
        return 1;
    }

    private static int setOwner(CommandSourceStack stack, Collection<? extends Entity> pTargets, @Nullable Entity owner, boolean temp) {
        for (Entity entity : pTargets) {
            String component;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity entity2 = (LivingEntity)entity;
            UUID uuid = owner == null ? null : owner.m_20148_();
            TensuraEPCapability.getFrom(entity2).ifPresent(cap -> {
                if (temp) {
                    cap.setTemporaryOwner(uuid);
                } else {
                    cap.setPermanentOwner(uuid);
                }
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    if (pEntity instanceof TamableAnimal) {
                        TamableAnimal animal = (TamableAnimal)pEntity;
                        animal.m_21828_(player);
                    } else if (pEntity instanceof TensuraHorseEntity) {
                        TensuraHorseEntity horse = (TensuraHorseEntity)pEntity;
                        horse.m_30637_(player);
                    }
                }
            });
            TensuraEPCapability.sync(entity2);
            if (owner != null) {
                component = temp ? "tensura.command.owner.temporary.set" : "tensura.command.owner.permanent.set";
                TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)component, (Object[])new Object[]{entity2.m_7755_(), owner.m_7755_()}));
                continue;
            }
            component = temp ? "tensura.command.owner.temporary.remove" : "tensura.command.owner.permanent.remove";
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)component, (Object[])new Object[]{entity2.m_7755_()}), ChatFormatting.RED);
        }
        return 1;
    }

    private static int setNeutral(CommandSourceStack stack, Collection<? extends Entity> pTargets, Entity target, boolean neutral) {
        for (Entity entity : pTargets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity entity2 = (LivingEntity)entity;
            UUID uuid = target.m_20148_();
            TensuraEPCapability.getFrom(entity2).ifPresent(cap -> {
                if (neutral) {
                    cap.addNeutralTarget(uuid);
                } else {
                    cap.removeNeutralTarget(uuid);
                }
            });
            TensuraEPCapability.sync(entity2);
            String component = neutral ? "tensura.command.owner.neutral.add" : "tensura.command.owner.neutral.remove";
            TensuraCommand.sendSuccess(stack, entity, Component.m_237110_((String)component, (Object[])new Object[]{entity2.m_7755_(), target.m_7755_()}));
        }
        return 1;
    }

    private static int getSkill(CommandSourceStack stack, @Nullable Entity entity, ManasSkill skill) {
        if (entity == null) {
            return 1;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        Optional optional = storage.getSkill(skill);
        if (optional.isEmpty()) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{entity.m_7755_(), skill.getName()}));
        } else {
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.skill_get", (Object[])new Object[]{entity.m_7755_(), skill.getName(), ((ManasSkillInstance)optional.get()).toNBT().m_7916_()}).m_130940_(ChatFormatting.AQUA), true);
        }
        return 1;
    }

    private static int getSkillList(CommandSourceStack stack, @Nullable Entity entity, Predicate<ManasSkill> predicate) {
        return TensuraCommand.getSkillList(stack, entity, predicate, false);
    }

    private static int getSkillList(CommandSourceStack stack, @Nullable Entity entity, Predicate<ManasSkill> predicate, boolean excludeLearning) {
        if (entity == null) {
            return 1;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        MutableComponent component = null;
        ArrayList<ManasSkill> filteredSkillList = new ArrayList<ManasSkill>(storage.getLearnedSkills().stream().filter(skill -> !excludeLearning || skill.getMastery() >= 0).map(ManasSkillInstance::getSkill).filter(skill -> skill.getName() != null).filter(predicate).sorted(Comparator.comparing(skill -> Objects.requireNonNull(SkillAPI.getSkillRegistry().getKey(skill)))).toList());
        for (ManasSkill manasSkill : filteredSkillList) {
            MutableComponent name = manasSkill.getName();
            if (manasSkill instanceof TensuraSkill) {
                TensuraSkill skill2 = (TensuraSkill)manasSkill;
                name = skill2.getColoredName();
            }
            if (name == null) continue;
            if (component == null) {
                component = name;
                continue;
            }
            component = component.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)name);
        }
        if (component == null) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.skill_list.empty", (Object[])new Object[]{entity.m_7755_()}));
        } else {
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.skill_list", (Object[])new Object[]{entity.m_7755_(), component}), false);
        }
        return 1;
    }

    private static int getSpiritList(CommandSourceStack stack, @Nullable Player player) {
        if (player == null) {
            return 1;
        }
        MutableComponent component = null;
        for (MagicElemental elemental : MagicElemental.values()) {
            int level = TensuraSkillCapability.getSpiritLevel(player, elemental.getId());
            if (level <= 0) continue;
            MutableComponent name = elemental.getName().m_130940_(elemental.getChatFormatting()).m_130946_(": " + level);
            component = component == null ? name : component.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)name);
        }
        if (component == null) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.command.spirit.list.empty", (Object[])new Object[]{player.m_7755_()}));
        } else {
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.command.spirit.list", (Object[])new Object[]{player.m_7755_(), component}), false);
        }
        return 1;
    }

    private static int checkCounterResetRequirement(CommandSourceStack stack, @Nullable ServerPlayer player) {
        boolean hinata;
        if (player == null) {
            return 1;
        }
        Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
        boolean finalRace = race != null && race.getNextEvolutions((Player)player).isEmpty();
        boolean awakened = TensuraPlayerCapability.isTrueHero((LivingEntity)player) || TensuraPlayerCapability.isTrueDemonLord((Player)player);
        boolean ifrit = player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.IFRIT.get()))) >= 1;
        boolean orc = player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.ORC_DISASTER.get()))) >= 1;
        boolean colossus = player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.ELEMENTAL_COLOSSUS.get()))) >= 1;
        boolean charybdis = player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.CHARYBDIS.get()))) >= 1;
        boolean bl = hinata = player.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)TensuraEntityTypes.HINATA_SAKAGUCHI.get()))) >= 1;
        if (finalRace && awakened && ifrit && orc && colossus && charybdis && hinata) {
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.command.reset_counter.check.met", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.GOLD), false);
        } else {
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.command.reset_counter.check", (Object[])new Object[]{player.m_7755_(), finalRace, awakened, ifrit, orc, colossus, charybdis, hinata}).m_130940_(ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int trulyUniqueRemove(CommandSourceStack stack, ManasSkill skill) {
        ServerLevel level = stack.m_81372_();
        if (!level.m_46469_().m_46207_(TensuraGameRules.TRULY_UNIQUE)) {
            stack.m_81352_((Component)Component.m_237115_((String)"tensura.truly_unique.off"));
            return 1;
        }
        UniqueSkillSaveData saveData = UniqueSkillSaveData.get(level.m_7654_().m_129783_());
        if (!saveData.hasSkill(skill.getRegistryName())) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.truly_unique.do_not_have", (Object[])new Object[]{skill.getName()}).m_130940_(ChatFormatting.RED));
        } else {
            saveData.removeSkill(skill.getRegistryName());
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.truly_unique.removed", (Object[])new Object[]{skill.getName()}).m_130940_(ChatFormatting.DARK_GREEN), true);
        }
        return 1;
    }

    private static int trulyUniqueCheck(CommandSourceStack stack, ManasSkill skill) {
        ResourceLocation location;
        ServerLevel level = stack.m_81372_();
        if (!level.m_46469_().m_46207_(TensuraGameRules.TRULY_UNIQUE)) {
            stack.m_81352_((Component)Component.m_237115_((String)"tensura.truly_unique.off"));
            return 1;
        }
        UniqueSkillSaveData saveData = UniqueSkillSaveData.get(level.m_7654_().m_129783_());
        if (saveData.hasSkill(location = skill.getRegistryName())) {
            UUID uuid = saveData.getSkillMap().get(location);
            Optional player = level.m_7654_().m_129927_().m_11002_(uuid);
            String playerUUID = player.isPresent() ? ((GameProfile)player.get()).getName() : String.valueOf(uuid);
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.truly_unique.already_have", (Object[])new Object[]{skill.getName(), playerUUID}).m_130940_(ChatFormatting.DARK_GREEN), true);
        } else {
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.truly_unique.do_not_have", (Object[])new Object[]{skill.getName()}).m_130940_(ChatFormatting.RED), true);
        }
        return 1;
    }

    private static int getTrulyUniqueTakenList(CommandSourceStack stack) {
        ServerLevel level = stack.m_81372_();
        MutableComponent component = null;
        Map<ResourceLocation, UUID> skillMap = UniqueSkillSaveData.get(level.m_7654_().m_129783_()).getSkillMap();
        List list = skillMap.keySet().stream().toList();
        for (ResourceLocation location : list) {
            ManasSkill manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(location);
            if (manasSkill == null) continue;
            MutableComponent name = manasSkill.getName();
            if (manasSkill instanceof TensuraSkill) {
                TensuraSkill skill = (TensuraSkill)manasSkill;
                name = skill.getColoredName();
            }
            if (name == null) continue;
            UUID uuid = skillMap.get(location);
            Optional player = level.m_7654_().m_129927_().m_11002_(uuid);
            String playerUUID = player.isPresent() ? ((GameProfile)player.get()).getName() : String.valueOf(uuid);
            name = name.m_130946_(" - ").m_7220_((Component)Component.m_237113_((String)playerUUID).m_130940_(ChatFormatting.LIGHT_PURPLE));
            if (component == null) {
                component = name;
                continue;
            }
            component = component.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)name);
        }
        if (component == null) {
            stack.m_81352_((Component)Component.m_237115_((String)"tensura.truly_unique.list.taken.empty"));
        } else {
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.truly_unique.list.taken", (Object[])new Object[]{component}), false);
        }
        return 1;
    }

    private static int getTrulyUniqueRemainList(CommandSourceStack stack) {
        MutableComponent component = null;
        ServerLevel level = stack.m_81372_();
        List<ManasSkill> filteredSkillList = RaceSelectionMenu.getReincarnationSkills(level, true, null);
        for (ManasSkill manasSkill : filteredSkillList) {
            MutableComponent name = manasSkill.getName();
            if (manasSkill instanceof TensuraSkill) {
                TensuraSkill skill = (TensuraSkill)manasSkill;
                name = skill.getColoredName();
            }
            if (name == null) continue;
            if (component == null) {
                component = name;
                continue;
            }
            component = component.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)name);
        }
        if (component == null) {
            stack.m_81352_((Component)Component.m_237115_((String)"tensura.truly_unique.list.remain.empty"));
        } else {
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.truly_unique.list.remain", (Object[])new Object[]{component}), false);
        }
        return 1;
    }

    private static void sendSuccess(CommandSourceStack stack, Entity entity, MutableComponent component) {
        TensuraCommand.sendSuccess(stack, entity, component, ChatFormatting.DARK_GREEN);
    }

    private static void sendSuccess(CommandSourceStack stack, Entity entity, MutableComponent component, ChatFormatting formatting) {
        if (stack.m_230896_() != entity) {
            entity.m_213846_((Component)component);
        }
        stack.m_81354_((Component)component.m_130940_(formatting), true);
    }

    private static /* synthetic */ void lambda$register$28(int amount, CommandContext context, Player player, ITensuraPlayerCapability data) {
        data.setSoulPoints(data.getSoulPoints() + amount * 1000);
        TensuraCommand.sendSuccess((CommandSourceStack)context.getSource(), (Entity)player, Component.m_237110_((String)"tensura.command.demon_lord.soul", (Object[])new Object[]{player.m_7755_(), data.getSoulPoints()}));
    }

    private static /* synthetic */ void lambda$register$9(Player player, int spirit, int amount, ITensuraSkillCapability data) {
        data.setSpiritLevel(player, spirit, amount);
    }
}

