/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.command;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.ability.magic.Magic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.command.argument.SkillArgument;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkillCommand {
    private static final SuggestionProvider<CommandSourceStack> SLOT_SUGGEST = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"1", "2", "3"}, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> PRESET_SUGGEST = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}, (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void register(RegisterCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"checkFlight").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            for (Player player : EntityArgument.m_91477_((CommandContext)context, (String)"players").stream().toList()) {
                if (SkillUtils.canFlyLegit(player)) {
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.skill.check_flight", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.DARK_GREEN), true);
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.skill.check_flight.false", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.RED), true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"storage").then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).suggests(SkillArgument.getObtainedSpatialStorageSuggestions()).executes(context -> SkillCommand.openSpatialStorage((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skill"))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).suggests(SkillArgument.getObtainedSpatialStorageSuggestions()).executes(context -> SkillCommand.addToSpatialStorage((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skill"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).suggests(SkillArgument.getObtainedSkillSuggestions()).then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).suggests(SLOT_SUGGEST).executes(context -> SkillCommand.setSkill((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "skill"), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle").then(Commands.m_82129_((String)"ability", (ArgumentType)SkillArgument.skill()).suggests(SkillArgument.getObtainedSkillSuggestions()).executes(context -> SkillCommand.toggleSkill((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "ability"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"everything").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, skill -> true)))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, skill -> true))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, skill -> skill instanceof Skill)))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, skill -> skill instanceof Skill))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resistance").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        })))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.RESISTANCE);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"intrinsic").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        })))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.INTRINSIC);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"common").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        })))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.COMMON);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"extra").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        })))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.EXTRA);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unique").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        })))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.UNIQUE);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ultimate").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        })))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, manasSkill -> {
            Skill skill;
            return manasSkill instanceof Skill && (skill = (Skill)((Object)((Object)manasSkill))).getType().equals((Object)Skill.SkillType.ULTIMATE);
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"magic").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, manasSkill -> manasSkill instanceof Magic)))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, manasSkill -> manasSkill instanceof Magic))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"battlewill").then(Commands.m_82127_((String)"on").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), true, manasSkill -> manasSkill instanceof Battewill)))).then(Commands.m_82127_((String)"off").executes(context -> SkillCommand.toggleEverything((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), false, manasSkill -> manasSkill instanceof Battewill)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"preset").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).suggests(PRESET_SUGGEST).executes(context -> SkillCommand.setPreset((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(Commands.m_82127_((String)"name").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).suggests(PRESET_SUGGEST).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> SkillCommand.setPresetName((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"))))))));
    }

    private static int openSpatialStorage(CommandSourceStack stack, Player player, ManasSkill manasSkill) {
        if (!(manasSkill instanceof ISpatialStorage)) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.spatial_storage.failed", (Object[])new Object[]{manasSkill.getName()}));
            return 1;
        }
        ISpatialStorage spatialStorage = (ISpatialStorage)manasSkill;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional instance = storage.getSkill(manasSkill);
        if (instance.isEmpty()) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{player.m_7755_(), manasSkill.getName()}));
        } else {
            spatialStorage.openSpatialStorage((LivingEntity)player, (ManasSkillInstance)instance.get());
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return 1;
    }

    private static int addToSpatialStorage(CommandSourceStack stack, Player player, ManasSkill manasSkill) {
        if (!(manasSkill instanceof ISpatialStorage)) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.spatial_storage.failed", (Object[])new Object[]{manasSkill.getName()}));
            return 1;
        }
        ISpatialStorage spatialStorage = (ISpatialStorage)manasSkill;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional instance = storage.getSkill(manasSkill);
        if (instance.isEmpty()) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{player.m_7755_(), manasSkill.getName()}));
        } else if (spatialStorage.addItemToSpatialStorage((ManasSkillInstance)instance.get(), (LivingEntity)player, player.m_21205_())) {
            player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.spatial_storage.full", (Object[])new Object[]{manasSkill.getName()}));
        }
        return 1;
    }

    private static int setSkill(CommandSourceStack stack, Player player, ManasSkill manasSkill, int slot) {
        if (manasSkill.getRegistryName() == null || !(manasSkill instanceof TensuraSkill)) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.invalid", (Object[])new Object[]{Component.m_237115_((String)manasSkill.toString())}));
            return 1;
        }
        TensuraSkill skill = (TensuraSkill)manasSkill;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional instance = storage.getSkill(manasSkill);
        if (instance.isEmpty() || !(instance.get() instanceof TensuraSkillInstance)) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{player.m_7755_(), manasSkill.getName()}));
        } else {
            if (!skill.canBeSlotted((ManasSkillInstance)instance.get())) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.skill_set.failed", (Object[])new Object[]{manasSkill.getName()}));
                return 1;
            }
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                cap.setInstanceInSlot((ManasSkillInstance)instance.get(), slot - 1);
                stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.skill_set", (Object[])new Object[]{manasSkill.getName(), slot}), false);
                TensuraSkillCapability.sync(player);
            });
        }
        return 1;
    }

    private static int toggleSkill(CommandSourceStack stack, Player player, ManasSkill skill) {
        Object t;
        if (skill.getRegistryName() == null) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.invalid", (Object[])new Object[]{Component.m_237115_((String)skill.toString())}));
            return 1;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional instance = storage.getSkill(skill);
        if (instance.isEmpty() || !((t = instance.get()) instanceof TensuraSkillInstance)) {
            stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.do_not_have", (Object[])new Object[]{player.m_7755_(), skill.getName()}));
        } else {
            TensuraSkillInstance skillInstance = (TensuraSkillInstance)((Object)t);
            if (!skill.canBeToggled((ManasSkillInstance)skillInstance, (LivingEntity)player)) {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.toggle.failed", (Object[])new Object[]{skill.getName()}));
                return 1;
            }
            if (skillInstance.canInteractSkill((LivingEntity)player)) {
                if (skillInstance.isToggled()) {
                    skillInstance.setToggled(false);
                    skillInstance.onToggleOff((LivingEntity)player);
                    stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.toggle_off", (Object[])new Object[]{skill.getName(), player.m_7755_()}), false);
                } else {
                    skillInstance.setToggled(true);
                    skillInstance.onToggleOn((LivingEntity)player);
                    stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.toggle_on", (Object[])new Object[]{skill.getName(), player.m_7755_()}), false);
                }
                storage.syncChanges();
            }
        }
        return 1;
    }

    private static int toggleEverything(CommandSourceStack stack, Player player, boolean toggle, Predicate<ManasSkill> predicate) {
        int i = 0;
        for (ManasSkillInstance instance : SkillAPI.getSkillsFrom((Entity)player).getLearnedSkills()) {
            if (!predicate.test(instance.getSkill()) || !instance.getSkill().canBeToggled(instance, (LivingEntity)player) || !instance.getSkill().canInteractSkill(instance, (LivingEntity)player) || instance.isToggled() == toggle) continue;
            instance.setToggled(toggle);
            if (toggle) {
                instance.onToggleOn((LivingEntity)player);
            } else {
                instance.onToggleOff((LivingEntity)player);
            }
            ++i;
        }
        String message = toggle ? "tensura.skill.toggle_all.on" : "tensura.skill.toggle_all.off";
        stack.m_81354_((Component)Component.m_237110_((String)message, (Object[])new Object[]{i, player.m_7755_()}), false);
        return 1;
    }

    private static int setPreset(CommandSourceStack stack, Player player, int number) {
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
            int newPreset = number - 1;
            if (cap.getActivePreset() != newPreset) {
                cap.setActivePreset(newPreset);
                stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.preset.changed", (Object[])new Object[]{cap.getPresetName(newPreset)}), false);
            } else {
                stack.m_81352_((Component)Component.m_237110_((String)"tensura.skill.preset.no_change", (Object[])new Object[]{cap.getPresetName(newPreset)}));
            }
            TensuraSkillCapability.sync(player);
        });
        return 1;
    }

    private static int setPresetName(CommandSourceStack stack, Player player, String name, int number) {
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
            int preset = number - 1;
            cap.setPresetName(preset, name);
            stack.m_81354_((Component)Component.m_237110_((String)"tensura.skill.preset.changed", (Object[])new Object[]{name}), false);
            TensuraSkillCapability.sync(player);
        });
        return 1;
    }
}

