/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.screen;

import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.client.screen.widget.SettingsButton;
import com.github.manasmods.tensura.client.screen.widget.SettingsEditBox;
import com.github.manasmods.tensura.client.screen.widget.SettingsOption;
import com.github.manasmods.tensura.config.client.DisplayConfig;
import com.github.manasmods.tensura.config.client.TensuraClientConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.GUISwitchPacket;
import com.github.manasmods.tensura.util.SimpleScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class SettingsScreen
extends SimpleScreen {
    private DisplayConfig cfg;
    private List<Pair<SettingsOption, Widget>> settings;
    private SettingsButton nextPage;
    private SettingsButton previousPage;
    private SettingsButton resetAll;
    private SettingsButton returnToMenu;
    private SettingsEditBox editBoxFocused = null;
    private int screenWidth;
    private int screenHeight;
    private int posY;
    private int tempX;
    private int tempY;
    private int startIndex = 0;
    private int actualEndIndex;
    private int endIndex = this.itemsPerPage;
    private int pageNumber = 1;
    private int totalPages;
    private int hudVariant;
    private int appraisalOpacity;
    private boolean resetWarned = false;
    private boolean titleScreen;
    private boolean arachnophobia;
    private boolean leftSideStats;
    private boolean flippedSkills;
    private boolean leftSideAnalysis;
    private double hudSize;
    private final int itemsPerPage;
    private static int hudX;
    private static int hudY;
    private static int skillsX;
    private static int skillsY;
    private static boolean editingStatPositions;
    private static boolean editingSkillPositions;

    public SettingsScreen() {
        super((Component)Component.m_237119_(), Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        this.itemsPerPage = 5;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.cfg = TensuraClientConfig.INSTANCE.displayConfig;
        this.screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        this.screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        this.guiLeft = 0;
        this.guiRight = this.screenWidth;
        this.guiTop = 0;
        this.guiBottom = this.screenHeight;
        this.guiCenterX = this.guiRight / 2;
        this.guiCenterY = this.guiBottom / 2;
        this.resetEverything(false);
        this.totalPages = (int)Math.ceil((double)this.settings.size() / (double)this.itemsPerPage);
        int i = 0;
        while (true) {
            if (i >= this.settings.size()) break;
            i += this.itemsPerPage;
        }
        this.actualEndIndex = i;
        this.nextPage = this.simpleButton(this.guiCenterX + 20, this.screenHeight - 75, 10, (Component)Component.m_237113_((String)">"), onPress -> {
            if (this.pageNumber >= this.totalPages) {
                this.pageNumber = 1;
                this.startIndex = 0;
                this.endIndex = this.itemsPerPage;
            } else {
                ++this.pageNumber;
                this.startIndex += this.itemsPerPage;
                this.endIndex += this.itemsPerPage;
            }
            this.switchStatesForButtons();
        });
        this.previousPage = this.simpleButton(this.guiCenterX - 30, this.screenHeight - 75, 10, (Component)Component.m_237113_((String)"<"), onPress -> {
            if (this.pageNumber <= 1) {
                this.pageNumber = this.totalPages;
                this.endIndex = this.actualEndIndex;
            } else {
                --this.pageNumber;
                this.endIndex -= this.itemsPerPage;
            }
            this.startIndex = Math.max(this.endIndex - this.itemsPerPage, 0);
            this.switchStatesForButtons();
        });
        this.resetAll = this.simpleButton(this.guiRight - 240, this.screenHeight - 25, () -> {
            if (this.resetWarned) {
                return Component.m_237115_((String)"tensura.settings.reset.warn").m_130940_(ChatFormatting.DARK_RED);
            }
            return Component.m_237115_((String)"tensura.settings.reset").m_130940_(ChatFormatting.RED);
        }, onPress -> {
            if (this.resetWarned) {
                DisplayConfig.resetEverything();
                this.resetEverything(true);
                this.resetWarned = false;
            } else {
                this.resetWarned = true;
            }
        });
        this.returnToMenu = this.simpleButton(this.guiRight - 120, this.screenHeight - 25, 100, (Component)Component.m_237115_((String)"tooltip.tensura.return"), onPress -> TensuraNetwork.INSTANCE.sendToServer((Object)new GUISwitchPacket(0, true)));
        this.m_142416_((GuiEventListener)this.nextPage);
        this.m_142416_((GuiEventListener)this.previousPage);
        this.m_142416_((GuiEventListener)this.resetAll);
        this.m_142416_((GuiEventListener)this.returnToMenu);
    }

    @Override
    protected void renderWidgets(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (editingStatPositions || editingSkillPositions) {
            return;
        }
        if (this.editBoxFocused != null) {
            this.editBoxFocused.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            return;
        }
        super.renderWidgets(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    protected void renderBg(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.poseStack = pPoseStack;
        if (this.editBoxFocused != null || editingStatPositions || editingSkillPositions) {
            return;
        }
        this.m_7333_(this.poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93179_(this.poseStack, 0, this.screenHeight - 50, this.screenWidth, this.screenHeight, -1072689136, -804253680);
        MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered((Screen)this, this.poseStack));
        int iteration = 0;
        int posY = this.guiTop + 26;
        for (int optionIndex = this.startIndex; optionIndex < this.endIndex && optionIndex < this.settings.size(); ++optionIndex) {
            SettingsOption option = (SettingsOption)this.settings.get(optionIndex).getFirst();
            if (TensuraGUIHelper.mouseOver(this.mouseX, this.mouseY, this.guiLeft + 39, this.guiRight - 20, this.guiTop + 19 + 30 * (++iteration - 1), this.guiTop + 40 + 30 * (iteration - 1))) {
                this.m_93179_(this.poseStack, this.guiLeft + 40, this.guiTop + 20 + 30 * (iteration - 1), this.guiRight - 20, this.guiTop + 40 + 30 * (iteration - 1), -1072689136, -804253680);
                option.renderDescription(this.f_96547_, this.poseStack, this.guiLeft + 20, this.screenHeight - 40);
            }
            option.renderText(this.f_96547_, this.poseStack, this.guiLeft + 60, posY);
            posY += 30;
            Widget widget = (Widget)this.settings.get(optionIndex).getSecond();
            if (widget == null) continue;
            widget.m_6305_(this.poseStack, pMouseX, pMouseY, pPartialTick);
        }
        this.f_96547_.m_92883_(this.poseStack, String.format("%s / %s", this.pageNumber, this.totalPages), (float)(this.guiCenterX - 12), (float)(this.screenHeight - 69), Color.WHITE.getRGB());
        this.renderTooltip(this.poseStack, pMouseX, pMouseY);
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    public void m_7522_(@Nullable GuiEventListener pListener) {
        super.m_7522_(pListener);
        if (pListener instanceof SettingsEditBox) {
            SettingsEditBox editBox;
            this.editBoxFocused = editBox = (SettingsEditBox)pListener;
            this.editBoxFocused.moveBox(true);
            this.switchStatesForGeneral(false);
        }
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (editingStatPositions) {
            hudX = (int)pMouseX;
            hudY = (int)pMouseY;
        } else if (editingSkillPositions) {
            skillsX = (int)pMouseX;
            skillsY = (int)pMouseY;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.editBoxFocused != null && !this.editBoxFocused.m_5953_(pMouseX, pMouseY)) {
            this.editBoxFocused.m_94178_(false);
            this.editBoxFocused = null;
            this.switchStatesForGeneral(true);
            return true;
        }
        if (editingStatPositions && pButton == 0) {
            hudX = (int)pMouseX;
            hudY = (int)pMouseY;
            return true;
        }
        if (editingSkillPositions) {
            if (pButton == 0) {
                skillsX = (int)pMouseX;
                skillsY = (int)pMouseY;
            } else if (pButton == 1) {
                this.flippedSkills = !this.flippedSkills;
                this.cfg.leftSideSkills.set((Object)this.flippedSkills);
            }
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256 || pKeyCode == 257 || pKeyCode == 259 || pKeyCode == 335) {
            if (editingStatPositions) {
                editingStatPositions = false;
                if (pKeyCode == 259) {
                    hudX = this.tempX;
                    hudY = this.tempY;
                    return true;
                }
                this.cfg.hudX.set((Object)hudX);
                this.cfg.hudY.set((Object)hudY);
                return true;
            }
            if (editingSkillPositions) {
                editingSkillPositions = false;
                if (pKeyCode == 259) {
                    skillsX = this.tempX;
                    skillsY = this.tempY;
                    return true;
                }
                this.cfg.skillsX.set((Object)skillsX);
                this.cfg.skillsY.set((Object)skillsY);
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private List<Pair<SettingsOption, Widget>> getSettings() {
        ArrayList<Pair<SettingsOption, Widget>> settings = new ArrayList<Pair<SettingsOption, Widget>>();
        this.posY = this.guiTop + 20;
        SettingsButton tensuraScreen = this.commonButton(() -> Component.m_237115_((String)(this.titleScreen ? "tensura.true" : "tensura.false")), onPress -> {
            this.titleScreen = !this.titleScreen;
            this.cfg.titleScreen.set((Object)this.titleScreen);
        }, reset -> {
            this.titleScreen = (Boolean)this.cfg.titleScreen.getDefault();
            this.cfg.titleScreen.set((Object)this.titleScreen);
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.titleScreen"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.titleScreen.description0"), Component.m_237115_((String)"tensura.settings.titleScreen.description1")}), (Object)((Object)tensuraScreen)));
        SettingsButton hudVariant = this.commonButton(() -> switch (this.hudVariant) {
            case 0 -> Component.m_237115_((String)"tensura.settings.hud_vanilla");
            case 1 -> Component.m_237115_((String)"tensura.settings.hud_tensura");
            case 2 -> Component.m_237115_((String)"tensura.settings.hud_combined_a");
            case 3 -> Component.m_237115_((String)"tensura.settings.hud_combined_b");
            default -> Component.m_237115_((String)"argument.range.empty");
        }, onPress -> {
            this.hudVariant = this.hudVariant >= 3 ? 0 : ++this.hudVariant;
            this.cfg.hudVariant.set((Object)this.hudVariant);
        }, reset -> {
            this.hudVariant = (Integer)this.cfg.hudVariant.getDefault();
            this.cfg.hudVariant.set((Object)this.hudVariant);
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.tensuraHud"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.tensuraHud.description0"), Component.m_237115_((String)"tensura.settings.tensuraHud.description1")}), (Object)((Object)hudVariant)));
        SettingsButton arachnophobia = this.commonButton(() -> Component.m_237115_((String)(this.arachnophobia ? "tensura.true" : "tensura.false")), onPress -> {
            this.arachnophobia = !this.arachnophobia;
            this.cfg.arachnophobia.set((Object)this.arachnophobia);
        }, reset -> {
            this.arachnophobia = (Boolean)this.cfg.arachnophobia.getDefault();
            this.cfg.arachnophobia.set((Object)this.arachnophobia);
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.arachnophobia"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.arachnophobia.description0"), Component.m_237115_((String)"tensura.settings.arachnophobia.description1")}), (Object)((Object)arachnophobia)));
        SettingsButton statsSide = this.commonButton(() -> Component.m_237115_((String)(this.leftSideStats ? "tensura.settings.left" : "tensura.settings.right")), onPress -> {
            this.leftSideStats = !this.leftSideStats;
            this.cfg.leftSideStats.set((Object)this.leftSideStats);
        }, reset -> {
            this.leftSideStats = (Boolean)this.cfg.leftSideStats.getDefault();
            this.cfg.leftSideStats.set((Object)this.leftSideStats);
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.leftSideStats"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.leftSideStats.description0"), Component.m_237115_((String)"tensura.settings.leftSideStats.description1")}), (Object)((Object)statsSide)));
        SettingsButton skillsSide = this.commonButton(() -> Component.m_237115_((String)(this.flippedSkills ? "tensura.settings.right" : "tensura.settings.left")), onPress -> {
            this.flippedSkills = !this.flippedSkills;
            this.cfg.leftSideSkills.set((Object)this.flippedSkills);
            skillsX = this.flippedSkills ? -2 : 0;
            skillsY = (Integer)this.cfg.skillsY.getDefault();
            this.cfg.skillsX.set((Object)skillsX);
            this.cfg.skillsY.set((Object)skillsY);
        }, reset -> {
            this.flippedSkills = (Boolean)this.cfg.leftSideSkills.getDefault();
            this.cfg.leftSideSkills.set((Object)this.flippedSkills);
            skillsX = (Integer)this.cfg.skillsX.getDefault();
            skillsY = (Integer)this.cfg.skillsY.getDefault();
            this.cfg.skillsX.set((Object)skillsX);
            this.cfg.skillsY.set((Object)skillsY);
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.flippedSkills"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.flippedSkills.description0"), Component.m_237115_((String)"tensura.settings.flippedSkills.description1"), Component.m_237115_((String)"tensura.settings.flippedSkills.description2")}), (Object)((Object)skillsSide)));
        SettingsButton analysisSide = this.commonButton(() -> Component.m_237115_((String)(this.leftSideAnalysis ? "tensura.settings.left" : "tensura.settings.right")), onPress -> {
            this.leftSideAnalysis = !this.leftSideAnalysis;
            this.cfg.leftSideAnalysis.set((Object)this.leftSideAnalysis);
        }, reset -> {
            this.leftSideAnalysis = (Boolean)this.cfg.leftSideAnalysis.getDefault();
            this.cfg.leftSideAnalysis.set((Object)this.leftSideAnalysis);
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.leftSideAnalysis"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.leftSideAnalysis.description0"), Component.m_237115_((String)"tensura.settings.leftSideAnalysis.description1")}), (Object)((Object)analysisSide)));
        SettingsEditBox hudSize = this.commonEditBox(this.hudSize, string -> {
            try {
                double value;
                this.hudSize = value = Double.parseDouble(string);
                this.cfg.size.set((Object)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addResetForEditBox(hudSize, reset -> {
            this.hudSize = (Double)this.cfg.size.getDefault();
            this.cfg.size.set((Object)this.hudSize);
            hudSize.m_94144_(String.valueOf(this.hudSize));
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.hudSize"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.hudSize.description0"), Component.m_237115_((String)"tensura.settings.hudSize.description1"), Component.m_237115_((String)"tensura.settings.hudSize.description2")}), (Object)((Object)hudSize)));
        SettingsEditBox appraisal = this.commonEditBox(this.appraisalOpacity, string -> {
            try {
                int value;
                this.appraisalOpacity = value = Integer.parseInt(string);
                this.cfg.appraisalOpacity.set((Object)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addResetForEditBox(appraisal, reset -> {
            this.appraisalOpacity = (Integer)this.cfg.appraisalOpacity.getDefault();
            this.cfg.appraisalOpacity.set((Object)this.appraisalOpacity);
            appraisal.m_94144_(String.valueOf(this.appraisalOpacity));
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.appraisalOpacity"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.appraisalOpacity.description0"), Component.m_237115_((String)"tensura.settings.appraisalOpacity.description1"), Component.m_237115_((String)"tensura.settings.appraisalOpacity.description2")}), (Object)((Object)appraisal)));
        SettingsButton statPos = this.commonButton(() -> Component.m_237115_((String)"tensura.settings.edit"), onPress -> {
            if (this.hudVariant == 3) {
                editingStatPositions = true;
                this.tempX = hudX;
                this.tempY = hudY;
            }
        }, reset -> {
            hudX = (Integer)this.cfg.hudX.getDefault();
            hudY = (Integer)this.cfg.hudY.getDefault();
            this.cfg.hudX.set((Object)hudX);
            this.cfg.hudY.set((Object)hudY);
        }, (Component)Component.m_237115_((String)"tensura.settings.hud_position.desc1"));
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.hud_position"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.edit_desc1"), Component.m_237115_((String)"tensura.settings.edit_desc2")}), (Object)((Object)statPos)));
        SettingsButton skillPos = this.commonButton(() -> Component.m_237115_((String)"tensura.settings.edit"), onPress -> {
            editingSkillPositions = true;
            this.tempX = skillsX;
            this.tempY = skillsY;
        }, reset -> {
            skillsX = (Integer)this.cfg.skillsX.getDefault();
            skillsY = (Integer)this.cfg.skillsY.getDefault();
            this.cfg.skillsX.set((Object)skillsX);
            this.cfg.skillsY.set((Object)skillsY);
        });
        settings.add(Pair.of((Object)new SettingsOption((Component)Component.m_237115_((String)"tensura.settings.skill_position"), (Component[])new MutableComponent[]{Component.m_237115_((String)"tensura.settings.edit_desc1"), Component.m_237115_((String)"tensura.settings.edit_desc2")}), (Object)((Object)skillPos)));
        return settings;
    }

    private SettingsEditBox commonEditBox(double value, Consumer<String> charTyped) {
        SettingsEditBox editBox = new SettingsEditBox(this.f_96547_, this.guiRight - 190, this.posY(), this.guiCenterX, this.guiCenterY, 100, 20, (Component)Component.m_237119_());
        editBox.m_94144_(String.valueOf(value));
        editBox.m_94151_(charTyped);
        this.m_7787_((GuiEventListener)editBox);
        return editBox;
    }

    private void addResetForEditBox(SettingsEditBox editBox, Button.OnPress reset) {
        Button button;
        editBox.resetButton = button = new Button(editBox.f_93620_ + 110, editBox.f_93621_, 40, 20, (Component)Component.m_237115_((String)"controls.reset").m_130940_(ChatFormatting.RED), reset, (button1, poseStack, x, y) -> {});
        this.m_7787_((GuiEventListener)button);
    }

    private SettingsButton commonButton(Supplier<Component> text, Button.OnPress onPress, Button.OnPress reset) {
        SettingsButton button = new SettingsButton(this.guiRight - 190, this.posY(), 100, 20, text, onPress, reset, (pButton, pPoseStack, pMouseX, pMouseY) -> {});
        this.m_7787_((GuiEventListener)button);
        this.m_7787_((GuiEventListener)button.resetButton);
        return button;
    }

    private SettingsButton commonButton(Supplier<Component> text, Button.OnPress onPress, Button.OnPress reset, Component tooltip) {
        SettingsButton button = new SettingsButton(this.guiRight - 190, this.posY(), 100, 20, text, onPress, reset, (button1, poseStack1, x, y) -> this.m_96602_(this.poseStack, tooltip, x, y));
        this.m_7787_((GuiEventListener)button);
        this.m_7787_((GuiEventListener)button.resetButton);
        return button;
    }

    private SettingsButton simpleButton(int x, int y, int width, Component text, Button.OnPress onPress) {
        SettingsButton button = new SettingsButton(x, y, width, 20, text, onPress, (pButton, pPoseStack, pMouseX, pMouseY) -> {});
        this.m_7787_((GuiEventListener)button);
        return button;
    }

    private SettingsButton simpleButton(int x, int y, Supplier<Component> text, Button.OnPress onPress) {
        SettingsButton button = new SettingsButton(x, y, 100, 20, text, onPress, (pButton, pPoseStack, pMouseX, pMouseY) -> {});
        this.m_7787_((GuiEventListener)button);
        return button;
    }

    private void switchStatesForGeneral(boolean state) {
        if (this.nextPage == null) {
            return;
        }
        this.nextPage.f_93623_ = state;
        this.nextPage.f_93624_ = state;
        this.previousPage.f_93623_ = state;
        this.previousPage.f_93624_ = state;
        this.resetAll.f_93623_ = state;
        this.resetAll.f_93624_ = state;
        this.returnToMenu.f_93623_ = state;
        this.returnToMenu.f_93624_ = state;
    }

    private void switchStatesForButtons() {
        for (int i = 0; i < this.settings.size(); ++i) {
            Widget widget = (Widget)this.settings.get(i).getSecond();
            if (widget instanceof SettingsButton) {
                SettingsButton settingsButton = (SettingsButton)widget;
                settingsButton.switchStates(i >= this.startIndex && i <= this.endIndex);
                continue;
            }
            if (!(widget instanceof SettingsEditBox)) continue;
            SettingsEditBox settingsEditBox = (SettingsEditBox)widget;
            settingsEditBox.switchStates(i >= this.startIndex && i <= this.endIndex);
        }
    }

    private int posY() {
        if (this.posY >= this.guiTop + 20 + 30 * this.itemsPerPage) {
            this.posY = this.guiTop + 20;
        }
        this.posY += 30;
        return this.posY - 30;
    }

    private void resetEverything(boolean widgets) {
        this.titleScreen = (Boolean)this.cfg.titleScreen.get();
        this.hudVariant = (Integer)this.cfg.hudVariant.get();
        this.arachnophobia = (Boolean)this.cfg.arachnophobia.get();
        this.leftSideStats = (Boolean)this.cfg.leftSideStats.get();
        this.flippedSkills = (Boolean)this.cfg.leftSideSkills.get();
        this.leftSideAnalysis = (Boolean)this.cfg.leftSideAnalysis.get();
        this.hudSize = (Double)this.cfg.size.get();
        this.appraisalOpacity = (Integer)this.cfg.appraisalOpacity.get();
        hudX = (Integer)this.cfg.hudX.get();
        hudY = (Integer)this.cfg.hudY.get();
        skillsX = (Integer)this.cfg.skillsX.get();
        skillsY = (Integer)this.cfg.skillsY.get();
        this.tempX = 0;
        this.tempY = 0;
        this.editBoxFocused = null;
        editingStatPositions = false;
        editingSkillPositions = false;
        if (widgets) {
            this.f_169369_.clear();
            this.m_6702_().clear();
            this.m_142416_((GuiEventListener)this.nextPage);
            this.m_142416_((GuiEventListener)this.previousPage);
            this.m_142416_((GuiEventListener)this.resetAll);
            this.m_142416_((GuiEventListener)this.returnToMenu);
        }
        this.settings = this.getSettings();
        this.switchStatesForButtons();
        this.switchStatesForGeneral(true);
    }

    public static int getHudX() {
        return hudX;
    }

    public static int getHudY() {
        return hudY;
    }

    public static int getSkillsX() {
        return skillsX;
    }

    public static int getSkillsY() {
        return skillsY;
    }

    public static boolean isEditingStatPositions() {
        return editingStatPositions;
    }

    public static boolean isEditingSkillPositions() {
        return editingSkillPositions;
    }
}

