/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.screen;

import com.github.manasmods.manascore.api.client.gui.widget.ImagePredicateButton;
import com.github.manasmods.tensura.ability.skill.unique.ResearcherSkill;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.menu.ResearcherEnchantmentMenu;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.RequestMenuSwitchPacket;
import com.github.manasmods.tensura.network.play2server.skill.RequestResearcherEnchantmentPacket;
import com.github.manasmods.tensura.util.ITensuraScrollbar;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class ResearcherEnchantmentScreen
extends AbstractContainerScreen<ResearcherEnchantmentMenu>
implements ITensuraScrollbar {
    private final ResourceLocation BACKGROUND = new ResourceLocation("tensura", "textures/gui/researcher/researcher_enchant.png");
    private final ResourceLocation NAME_BAR = new ResourceLocation("tensura", "textures/gui/researcher/enchantment_name.png");
    private final ResourceLocation ENCHANT_BUTTON = new ResourceLocation("tensura", "textures/gui/researcher/enchant_button.png");
    private final ResourceLocation LEVEL_BOX = new ResourceLocation("tensura", "textures/gui/researcher/enchantment_level.png");
    private final ResourceLocation CHECKBOX = new ResourceLocation("tensura", "textures/gui/checkbox.png");
    private float scrollOffs;
    private int startIndex;
    private int offscreenRows;

    public ResearcherEnchantmentScreen(ResearcherEnchantmentMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 227;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
        this.offscreenRows = ResearcherSkill.getAllEnchantments((LivingEntity)((ResearcherEnchantmentMenu)this.f_97732_).getPlayer(), ((ResearcherEnchantmentMenu)this.f_97732_).getSkill()).size() - 5;
        this.initScrollbar(this.f_97735_ + 126, this.f_97736_ + 67, 65, this.scrollOffs, false, false);
        ImagePredicateButton enchantButton = new ImagePredicateButton(this.f_97735_ + 145, this.f_97736_ + 44, 20, 18, this.ENCHANT_BUTTON, onPress -> {
            if (((ResearcherEnchantmentMenu)this.f_97732_).getItemInput().m_7983_() || (long)((ResearcherEnchantmentMenu)this.f_97732_).getExperienceCost() > ResearcherEnchantmentMenu.getTotalXp(((ResearcherEnchantmentMenu)this.f_97732_).getPlayer())) {
                return;
            }
            TensuraNetwork.INSTANCE.sendToServer((Object)new RequestResearcherEnchantmentPacket());
            TensuraGUIHelper.playSound(SoundEvents.f_11887_, 1.0f);
        }, (button, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)"container.enchant"), x, y), ((ResearcherEnchantmentMenu)this.f_97732_)::check);
        this.m_142416_((GuiEventListener)enchantButton);
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
        this.renderTabIcons();
    }

    private void renderTabIcons() {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91291_().m_115203_(new ItemStack((ItemLike)Items.f_42108_), this.getGuiLeft() + 8, this.getGuiTop() + 6);
        this.f_96541_.m_91291_().m_115203_(new ItemStack((ItemLike)Items.f_42100_), this.getGuiLeft() + 34, this.getGuiTop() + 5);
    }

    public void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        TensuraGUIHelper.renderScaledCenteredXText(this.f_96547_, pPoseStack, (Component)Component.m_237115_((String)"tensura.researcher_menu.enchantment_tab"), 2, 31, 145, 9, Color.WHITE, false);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mX, int mY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderScrollbar(poseStack);
        SCROLLBAR_DATA.setActive(this.offscreenRows >= 1);
        this.renderEnchantments(poseStack, mX, mY);
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        if (TensuraGUIHelper.mouseOver(pX, pY, this.f_97735_ + 3, this.f_97735_ + 28, this.f_97736_ + 1, this.f_97736_ + 23)) {
            this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"tensura.researcher_menu.storage_tab"), pX, pY);
            return;
        }
        if (TensuraGUIHelper.mouseOver(pX, pY, this.f_97735_ + 29, this.f_97735_ + 54, this.f_97736_ - 1, this.f_97736_ + 23)) {
            this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"tensura.researcher_menu.enchantment_tab"), pX, pY);
            return;
        }
        if (TensuraGUIHelper.mouseOver(pX, pY, this.f_97735_ + 149, this.f_97735_ + 160, this.f_97736_ + 91, this.f_97736_ + 106)) {
            int cost = ((ResearcherEnchantmentMenu)this.f_97732_).getExperienceCost();
            ChatFormatting formatting = ResearcherEnchantmentMenu.getTotalXp(((ResearcherEnchantmentMenu)this.f_97732_).getPlayer()) >= (long)cost ? ChatFormatting.GREEN : ChatFormatting.RED;
            this.m_96602_(pPoseStack, (Component)Component.m_237110_((String)"tensura.researcher_menu.enchantment_tab.xp_cost", (Object[])new Object[]{cost}).m_130940_(formatting), pX, pY);
            return;
        }
        int slotClicked = this.getSlotUnderMouse(pX, pY);
        if (slotClicked >= 0 && pX <= this.f_97735_ + 106) {
            int id = slotClicked + this.startIndex;
            Map<Enchantment, Integer> map = ResearcherSkill.getAllEnchantments((LivingEntity)((ResearcherEnchantmentMenu)this.f_97732_).getPlayer(), ((ResearcherEnchantmentMenu)this.f_97732_).getSkill());
            if (!map.isEmpty() && id < map.entrySet().size()) {
                Enchantment enchantment = (Enchantment)map.keySet().stream().toList().get(id);
                this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)enchantment.m_44704_()).m_130940_(this.getColor(enchantment)), pX, pY);
                return;
            }
        }
        super.m_7025_(pPoseStack, pX, pY);
    }

    private ChatFormatting getColor(Enchantment enchantment) {
        ChatFormatting color;
        if (enchantment.m_6589_()) {
            color = ChatFormatting.RED;
        } else if (enchantment instanceof EngravingEnchantment) {
            color = ChatFormatting.GOLD;
        } else {
            color = switch (enchantment.m_44699_()) {
                default -> throw new IncompatibleClassChangeError();
                case Enchantment.Rarity.COMMON -> ChatFormatting.YELLOW;
                case Enchantment.Rarity.UNCOMMON -> ChatFormatting.GREEN;
                case Enchantment.Rarity.RARE -> ChatFormatting.AQUA;
                case Enchantment.Rarity.VERY_RARE -> ChatFormatting.LIGHT_PURPLE;
            };
        }
        return color;
    }

    private void renderEnchantments(PoseStack poseStack, int mX, int mY) {
        ArrayList enchantments = new ArrayList();
        ArrayList levels = new ArrayList();
        this.getAllEnchantments().forEach((key, value) -> {
            enchantments.add(key);
            levels.add(value);
        });
        int pos = 0;
        int endIndex = this.startIndex + 5;
        for (int i = this.startIndex; i < endIndex && i < enchantments.size(); ++i) {
            Enchantment enchantment = (Enchantment)enchantments.get(i);
            int level = (Integer)levels.get(i);
            MutableComponent name = Component.m_237115_((String)enchantment.m_44704_());
            ChatFormatting color = this.getColor(enchantment);
            Map<Enchantment, Integer> map = ResearcherSkill.getSelectedEnchantments((LivingEntity)((ResearcherEnchantmentMenu)this.f_97732_).getPlayer(), ((ResearcherEnchantmentMenu)this.f_97732_).getSkill());
            boolean flag = TensuraGUIHelper.mouseOver(mX, mY, this.f_97735_ + 21, this.f_97735_ + 107, this.f_97736_ + 66 + pos * 13, this.f_97736_ + 80 + pos * 13);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.NAME_BAR);
            ResearcherEnchantmentScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 22), (int)(this.f_97736_ + 67 + pos * 13), (float)0.0f, (float)(flag ? 13.0f : 0.0f), (int)86, (int)13, (int)85, (int)26);
            ResearcherEnchantmentScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)TensuraGUIHelper.shortenTextComponent((Component)name.m_6881_().m_130940_(color), 14), (int)(this.f_97735_ + 27), (int)(this.f_97736_ + 70 + pos * 13), (int)(color.m_126665_() == null ? 0 : color.m_126665_()));
            int offsetX = 0;
            boolean hovering = TensuraGUIHelper.mouseOver(mX, mY, this.f_97735_ + 8, this.f_97735_ + 22, this.f_97736_ + 67 + pos * 13, this.f_97736_ + 81 + pos * 13);
            if (hovering) {
                offsetX = 13;
            }
            int offsetY = map.containsKey(enchantment) ? 13 : 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.CHECKBOX);
            ResearcherEnchantmentScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 8), (int)(this.f_97736_ + 67 + pos * 13), (float)offsetX, (float)offsetY, (int)13, (int)13, (int)26, (int)26);
            hovering = TensuraGUIHelper.mouseOver(mX, mY, this.f_97735_ + 107, this.f_97735_ + 123, this.f_97736_ + 67 + pos * 13, this.f_97736_ + 81 + pos * 13);
            offsetY = hovering ? 13 : 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.LEVEL_BOX);
            ResearcherEnchantmentScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 107), (int)(this.f_97736_ + 67 + pos * 13), (float)0.0f, (float)offsetY, (int)15, (int)13, (int)15, (int)26);
            int selectedLevel = map.getOrDefault(enchantment, level);
            MutableComponent levelComponent = selectedLevel <= 10 ? Component.m_237115_((String)("enchantment.level." + selectedLevel)) : Component.m_237113_((String)String.valueOf(selectedLevel));
            TensuraGUIHelper.renderCenteredXText(this.f_96547_, poseStack, (Component)levelComponent, this.f_97735_ + 108, this.f_97736_ + 70 + pos * 13, 15, Color.LIGHT_GRAY, false);
            ++pos;
        }
    }

    private int getSlotUnderMouse(double pX, double pY) {
        for (int i = 0; i < 5; ++i) {
            if (!TensuraGUIHelper.mouseOver(pX, pY, this.f_97735_ + 8, this.f_97735_ + 123, this.f_97736_ + 66 + i * 13, this.f_97736_ + 80 + i * 13)) continue;
            return i;
        }
        if (TensuraGUIHelper.mouseOver(pX, pY, this.f_97735_ + 145, this.f_97735_ + 163, this.f_97736_ + 44, this.f_97736_ + 62)) {
            return -2;
        }
        return -1;
    }

    private Map<Enchantment, Integer> getAllEnchantments() {
        Map<Enchantment, Integer> enchantments = ResearcherSkill.getAllEnchantments((LivingEntity)((ResearcherEnchantmentMenu)this.f_97732_).getPlayer(), ((ResearcherEnchantmentMenu)this.f_97732_).getSkill());
        this.offscreenRows = enchantments.size() - 5;
        if (this.startIndex > enchantments.size()) {
            this.startIndex = 0;
        }
        return enchantments;
    }

    public boolean m_6375_(double pX, double pY, int pButton) {
        this.handleScrollbarMouseClicked(pX, pY);
        int slotClicked = this.getSlotUnderMouse(pX, pY);
        if (!((ResearcherEnchantmentMenu)this.f_97732_).getItemInput().m_7983_() && slotClicked >= 0) {
            int id = slotClicked + this.startIndex;
            Map<Enchantment, Integer> mapAll = ResearcherSkill.getAllEnchantments((LivingEntity)((ResearcherEnchantmentMenu)this.f_97732_).getPlayer(), ((ResearcherEnchantmentMenu)this.f_97732_).getSkill());
            if (!mapAll.isEmpty() && id < mapAll.entrySet().size()) {
                Enchantment enchantment = (Enchantment)mapAll.keySet().stream().toList().get(id);
                if (pX > (double)(this.f_97735_ + 106)) {
                    Map<Enchantment, Integer> map = ResearcherSkill.getSelectedEnchantments((LivingEntity)((ResearcherEnchantmentMenu)this.f_97732_).getPlayer(), ((ResearcherEnchantmentMenu)this.f_97732_).getSkill());
                    if (enchantment != null && map.containsKey(enchantment)) {
                        int maxEnchantLevel;
                        int level = map.get(enchantment) + 1;
                        if (level > (maxEnchantLevel = Math.min(((ResearcherEnchantmentMenu)this.f_97732_).getMaxStoredLevel(enchantment), ResearcherEnchantmentMenu.getMaxEnchantLevel(enchantment, ((ResearcherEnchantmentMenu)this.f_97732_).getPlayer())))) {
                            level = 1;
                        }
                        TensuraNetwork.INSTANCE.sendToServer((Object)new RequestResearcherEnchantmentPacket(id, level));
                        TensuraGUIHelper.playSound(SoundEvents.f_12088_, 1.0f);
                    }
                    return true;
                }
            }
            TensuraNetwork.INSTANCE.sendToServer((Object)new RequestResearcherEnchantmentPacket(id));
            TensuraGUIHelper.playSound(SoundEvents.f_12013_, 1.0f);
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pX, pY, this.f_97735_ + 4, this.f_97735_ + 28, this.f_97736_ + 2, this.f_97736_ + 23)) {
            TensuraNetwork.INSTANCE.sendToServer((Object)new RequestMenuSwitchPacket(RequestMenuSwitchPacket.SwitchType.RESEARCHER_TAB_2_TO_TAB_1));
            return true;
        }
        return super.m_6375_(pX, pY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        this.handleScrollbarMouseScrolled(pDelta, 1);
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.handleScrollbarMouseDragged(pMouseY, 1)) {
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public float getScrollOffs() {
        return this.scrollOffs;
    }

    public void setScrollOffs(float scrollOffs) {
        this.scrollOffs = scrollOffs;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getOffscreenRows() {
        return this.offscreenRows;
    }

    @Override
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setOffscreenRows(int offscreenRows) {
        this.offscreenRows = offscreenRows;
    }
}

