/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.screen;

import com.github.manasmods.manascore.api.client.gui.FontRenderHelper;
import com.github.manasmods.manascore.api.client.gui.widget.ImagePredicateButton;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.magic.Magic;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.client.screen.SkillScreen;
import com.github.manasmods.tensura.menu.MagicSelectionMenu;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.skill.RequestAbilityPresetPacket;
import com.github.manasmods.tensura.util.Cached;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MagicSelectionScreen
extends AbstractContainerScreen<MagicSelectionMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tensura", "textures/gui/magic/magic_gui.png");
    private static final ResourceLocation CHECKBOX = new ResourceLocation("tensura", "textures/gui/checkbox.png");
    private static final ResourceLocation SKILL_BUTTON = new ResourceLocation("tensura", "textures/gui/skill_button.png");
    private static final ResourceLocation SCROLL_BAR = new ResourceLocation("tensura", "textures/gui/scroll_bar.png");
    private static final ResourceLocation COOLDOWN_CLOCK = new ResourceLocation("tensura", "textures/gui/skill_selection/cooldown_clock.png");
    private List<String> presetNames = new ArrayList<String>();
    private Cached<List<ManasSkill>, String> filteredSkills;
    private EditBox searchField;
    private ManasSkill slot1;
    private ManasSkill slot2;
    private ManasSkill slot3;
    private ManasSkill selectedSkill = null;
    private int selectedPreset = 0;
    private final Player player;
    private boolean scrolling;
    private float scrollOffs;
    private int startIndex;
    private int slot;

    public MagicSelectionScreen(MagicSelectionMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 256;
        this.f_97727_ = 163;
        this.player = pPlayerInventory.f_35978_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
        this.slot = 0;
        this.searchField = new EditBox(this.f_96547_, this.getGuiLeft() + 27, this.getGuiTop() + 31, 79, 9, (Component)Component.m_237119_());
        this.searchField.m_94182_(false);
        this.searchField.m_94151_(s -> {
            if (s.isEmpty()) {
                return;
            }
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        });
        this.m_142416_((GuiEventListener)this.searchField);
        this.filteredSkills = new Cached(() -> {
            ArrayList<ManasSkill> filteredSkillList = new ArrayList<ManasSkill>(SkillAPI.getSkillsFrom((Entity)this.player).getLearnedSkills().stream().map(ManasSkillInstance::getSkill).sorted(Comparator.comparing(skill -> Objects.requireNonNull(SkillAPI.getSkillRegistry().getKey(skill)))).filter((? super T skill) -> skill instanceof Magic && skill.getName() != null).toList());
            String filterValue = this.searchField.m_94155_();
            filteredSkillList.removeIf(this.filter(filterValue));
            return filteredSkillList;
        }, info -> {
            if (info.lastCallbackReference == null || !((String)info.lastCallbackReference).equals(this.searchField.m_94155_())) {
                info.lastCallbackReference = this.searchField.m_94155_();
                info.needsUpdate = true;
            }
            return info;
        });
        TensuraSkillCapability.getFrom(this.player).ifPresent(cap -> {
            this.selectedPreset = cap.getActivePreset();
            this.presetNames = cap.getPresetNames();
        });
        for (int i = 0; i < 9; ++i) {
            int j = i;
            ImagePredicateButton imagePredicateButton = new ImagePredicateButton(0, 0, 10, 11, SkillScreen.PRESET_BUTTON, pButton -> {
                if (this.selectedPreset == j) {
                    TensuraNetwork.INSTANCE.sendToServer((Object)new RequestAbilityPresetPacket(j, true));
                } else {
                    this.selectedPreset = j;
                    this.loadPreset();
                }
            }, (pButton, pPoseStack1, pMouseX1, pMouseY1) -> this.m_96602_(pPoseStack1, (Component)Component.m_237113_((String)this.presetNames.get(j)), pMouseX1, pMouseY1), ((MagicSelectionMenu)this.f_97732_)::check);
            imagePredicateButton.f_93620_ = this.getGuiLeft() + 14 + i * 10;
            imagePredicateButton.f_93621_ = this.getGuiTop() + 98;
            this.m_142416_((GuiEventListener)imagePredicateButton);
        }
        ImmutableList<ImagePredicateButton> buttons = TensuraGUIHelper.addMenuTabs(this, 5, true);
        for (ImagePredicateButton button : buttons) {
            this.m_142416_((GuiEventListener)button);
        }
        this.loadPreset();
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pX, int pY) {
        boolean hovering;
        this.m_7333_(pPoseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(pPoseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        TensuraGUIHelper.renderTabIcon(pPoseStack, this, 5, pX, pY);
        if (this.selectedSkill != null) {
            ManasSkillInstance instance = this.getSkillInstance(this.selectedSkill);
            if (instance == null) {
                return;
            }
            ManasSkill skill = instance.getSkill();
            int masteryBar = (int)((float)(106 * instance.getMastery()) / (float)skill.getMaxMastery());
            int barY = 164;
            if (instance.getMastery() < 0) {
                masteryBar = (int)((float)(106 * (instance.getMastery() + 100)) / 100.0f);
                barY += 9;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
            this.m_93228_(pPoseStack, this.getGuiLeft() + 119, this.getGuiTop() + 146, 1, barY, masteryBar, 9);
            ResourceLocation location = skill.getSkillIcon();
            if (location != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)skill.getSkillIcon());
                MagicSelectionScreen.m_93133_((PoseStack)pPoseStack, (int)(this.getGuiLeft() + 162), (int)(this.getGuiTop() + 32), (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
            }
            Component description = skill.getSkillDescription();
            FontRenderHelper.renderScaledTextInArea((PoseStack)pPoseStack, (Font)this.f_96547_, (FormattedText)description, (float)(this.getGuiLeft() + 125), (float)(this.getGuiTop() + 67), (float)94.0f, (float)66.0f, (Color)Color.LIGHT_GRAY);
            if (instance.canBeToggled((LivingEntity)this.player)) {
                boolean hovering2;
                int offsetX = 0;
                boolean bl = hovering2 = pX >= this.f_97735_ + 190 && pY >= this.f_97736_ + 35 && pX < this.f_97735_ + 203 && pY < y + 48;
                if (hovering2) {
                    offsetX = 13;
                }
                int offsetY = instance.isToggled() ? 13 : 0;
                RenderSystem.m_157456_((int)0, (ResourceLocation)CHECKBOX);
                MagicSelectionScreen.m_93133_((PoseStack)pPoseStack, (int)(this.f_97735_ + 190), (int)(this.f_97736_ + 35), (float)offsetX, (float)offsetY, (int)13, (int)13, (int)26, (int)26);
            }
            boolean bl = hovering = pX > this.getGuiLeft() + 158 && pX < this.getGuiLeft() + 185 && pY > this.getGuiTop() + 29 && pY < this.getGuiTop() + 55;
            if (hovering && skill.getName() != null) {
                this.m_96602_(pPoseStack, (Component)skill.getName(), pX, pY);
            }
            if (instance.onCoolDown()) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)COOLDOWN_CLOCK);
                MagicSelectionScreen.m_93133_((PoseStack)pPoseStack, (int)(this.getGuiLeft() + 142), (int)(this.getGuiTop() + 34), (float)0.0f, (float)0.0f, (int)12, (int)14, (int)12, (int)14);
            }
            if (pX > this.getGuiLeft() + 141 && pX < this.getGuiLeft() + 154 && pY > this.getGuiTop() + 33 && pY < this.getGuiTop() + 48) {
                this.m_96602_(pPoseStack, (Component)Component.m_237110_((String)"tensura.skill.on_cooldown", (Object[])new Object[]{instance.getCoolDown()}), pX, pY);
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (i < 3) {
                ManasSkill manasSkill = i == 0 ? this.slot1 : (i == 1 ? this.slot2 : this.slot3);
                MutableComponent name = this.skillName(manasSkill);
                ManasSkillInstance instance = this.getSkillInstance(manasSkill);
                name = instance != null && instance.getMastery() < 0 ? name.m_130940_(ChatFormatting.GRAY) : name.m_130940_(ChatFormatting.DARK_AQUA);
                int xName = this.getGuiLeft() + 10;
                int yName = this.getGuiTop() + 115 + i * 16;
                FontRenderHelper.renderScaledTextInArea((PoseStack)pPoseStack, (Font)this.f_96547_, (FormattedText)TensuraGUIHelper.shortenTextComponent((Component)name, 15), (float)xName, (float)yName, (float)100.0f, (float)11.0f, (Color)Color.CYAN);
                boolean bl = hovering = pX > xName - 6 && pX < xName + 99 && pY > yName - 5 && pY < yName + 11;
                if (hovering) {
                    this.m_96602_(pPoseStack, (Component)name, pX, pY);
                }
            }
            Color presetColor = this.selectedPreset == i ? Color.ORANGE : Color.LIGHT_GRAY;
            TensuraGUIHelper.renderScaledCenteredXText(this.f_96547_, pPoseStack, (Component)Component.m_237113_((String)String.valueOf(i + 1)), this.getGuiLeft() + 15 + i * 10, this.getGuiTop() + 100, 10, 11, presetColor, true);
        }
        int k = (int)(26.0f * this.scrollOffs);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCROLL_BAR);
        MagicSelectionScreen.m_93133_((PoseStack)pPoseStack, (int)(this.f_97735_ + 98), (int)(this.f_97736_ + 48 + k), (float)0.0f, (float)(this.isScrollBarActive() ? 13.0f : 0.0f), (int)10, (int)13, (int)10, (int)26);
        List<ManasSkill> filteredSkills = this.filteredSkills.getValue();
        int lastVisibleElementIndex = Math.min(this.startIndex + 3, filteredSkills.size());
        this.renderButtons(pPoseStack, pX, pY, lastVisibleElementIndex, filteredSkills);
    }

    private void renderButtons(PoseStack pPoseStack, int pMouseX, int pMouseY, int pLastVisibleElementIndex, List<ManasSkill> list) {
        for (int i = this.startIndex; i < pLastVisibleElementIndex && i < list.size(); ++i) {
            boolean hovering;
            int x = this.getGuiLeft() + 6;
            int y = this.getGuiTop() + 48 + (i - this.startIndex) * 13;
            int offset = 0;
            boolean bl = hovering = pMouseX >= x && pMouseY >= y && pMouseX < x + 89 && pMouseY < y + 13;
            if (hovering) {
                offset = 13;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_BUTTON);
            MagicSelectionScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)offset, (int)89, (int)13, (int)89, (int)26);
            ManasSkill manasSkill = list.get(i);
            MutableComponent name = this.skillName(manasSkill);
            ManasSkillInstance instance = this.getSkillInstance(manasSkill);
            name = instance != null && instance.getMastery() < 0 ? name.m_130940_(ChatFormatting.GRAY) : name.m_130940_(ChatFormatting.DARK_AQUA);
            TensuraGUIHelper.renderScaledShadowText(pPoseStack, this.f_96547_, (FormattedText)TensuraGUIHelper.shortenTextComponent((Component)name, 14), this.getGuiLeft() + 9, this.getGuiTop() + 51 + (i - this.startIndex) * 13, 87.0f, 13.0f, Color.WHITE.getRGB(), 2.0f, 0.01f);
            if (!hovering) continue;
            this.m_96602_(pPoseStack, (Component)name, pMouseX, pMouseY);
        }
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        if (pX > this.getGuiLeft() + 5 && pX < this.getGuiLeft() + 23 && pY > this.getGuiTop() + 28 && pY < this.getGuiTop() + 38) {
            this.m_96602_(pPoseStack, (Component)Component.m_237115_((String)"tooltip.tensura.return"), pX, pY);
        }
        if (this.selectedSkill != null) {
            ManasSkillInstance instance = this.getSkillInstance(this.selectedSkill);
            if (instance == null) {
                return;
            }
            if (pX > this.getGuiLeft() + 189 && pX < this.getGuiLeft() + 203 && pY > this.getGuiTop() + 35 && pY < this.getGuiTop() + 48) {
                MutableComponent component = instance.isToggled() ? Component.m_237115_((String)"options.on") : Component.m_237115_((String)"options.off");
                this.m_96602_(pPoseStack, (Component)(instance.canBeToggled((LivingEntity)this.player) && instance.canInteractSkill((LivingEntity)this.player) ? component : Component.m_237115_((String)"tensura.skill_selection_screen.untoggleable")), pX, pY);
            } else if (pX > this.getGuiLeft() + 115 & pX < this.getGuiLeft() + 228 && pY > this.getGuiTop() + 143 && pY < this.getGuiTop() + 158) {
                MutableComponent component;
                int mastery = instance.getMastery();
                if (mastery < 0) {
                    int points = mastery + 100;
                    component = Component.m_237110_((String)"tensura.skill_selection_screen.skill_learning", (Object[])new Object[]{points});
                } else {
                    mastery = mastery * 100 / instance.getMaxMastery();
                    component = Component.m_237110_((String)"tensura.skill_selection_screen.skill_mastery", (Object[])new Object[]{mastery + "%"});
                }
                this.m_96602_(pPoseStack, (Component)component, pX, pY);
            }
        }
        super.m_7025_(pPoseStack, pX, pY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchField.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.searchField.m_93696_() && this.searchField.m_94213_() && pKeyCode != 256) {
            return true;
        }
        if (this.f_96541_ != null) {
            if (TensuraKeybinds.MAIN_GUI.m_90832_(pKeyCode, pScanCode)) {
                this.f_96541_.m_91152_(null);
                this.f_96541_.f_91067_.m_91601_();
                return true;
            }
            if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    /*
     * Exception decompiling
     */
    public boolean m_6375_(double pX, double pY, int pButton) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int mouseOverSkillSlot(double pX, double pY) {
        if (pX > (double)(this.getGuiLeft() + 5) && pX < (double)(this.getGuiLeft() + 109) && pY > (double)(this.getGuiTop() + 111) && pY < (double)(this.getGuiTop() + 126)) {
            return 1;
        }
        if (pX > (double)(this.getGuiLeft() + 5) && pX < (double)(this.getGuiLeft() + 109) && pY > (double)(this.getGuiTop() + 127) && pY < (double)(this.getGuiTop() + 142)) {
            return 2;
        }
        if (pX > (double)(this.getGuiLeft() + 5) && pX < (double)(this.getGuiLeft() + 109) && pY > (double)(this.getGuiTop() + 143) && pY < (double)(this.getGuiTop() + 158)) {
            return 3;
        }
        return 0;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, Math.min(this.startIndex - (int)pDelta, this.filteredSkills.getValue().size() - 3));
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.getGuiTop() + 48;
            int j = i + 34;
            this.scrollOffs = (float)((pMouseY - (double)i - 6.5) / (double)((float)(j - i) - 13.0f));
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private boolean isScrollBarActive() {
        return this.filteredSkills.getValue().size() > 3;
    }

    private int getOffscreenRows() {
        return this.filteredSkills.getValue().size() - 3;
    }

    private MutableComponent skillName(@Nullable ManasSkill skill) {
        if (skill == null || skill.getName() == null) {
            return Component.m_237115_((String)"tensura.race.selection.skills.empty");
        }
        return skill.getName();
    }

    private void loadPreset() {
        TensuraSkillCapability.getFrom(this.player).ifPresent(cap -> {
            this.slot1 = cap.getSkillInPresetSlot(this.selectedPreset, 0);
            this.slot2 = cap.getSkillInPresetSlot(this.selectedPreset, 1);
            this.slot3 = cap.getSkillInPresetSlot(this.selectedPreset, 2);
        });
    }

    @Nullable
    private ManasSkillInstance getSkillInstance(ManasSkill skill) {
        Optional instance = SkillAPI.getSkillsFrom((Entity)this.player).getSkill(skill);
        return instance.orElse(null);
    }

    private Predicate<? super ManasSkill> filter(String filter) {
        Predicate<ManasSkill> predicate = manasSkill -> {
            if (!(manasSkill instanceof Magic)) {
                return true;
            }
            Magic magic = (Magic)((Object)manasSkill);
            ManasSkillInstance instance = this.getSkillInstance((ManasSkill)manasSkill);
            if (instance == null) {
                return true;
            }
            return switch (filter.toLowerCase()) {
                case "f:" -> false;
                case "f:active" -> {
                    if (!magic.canBeSlotted(instance)) {
                        yield true;
                    }
                    yield false;
                }
                case "f:passive" -> magic.canBeSlotted(instance);
                case "f:mastered" -> {
                    if (!instance.isMastered((LivingEntity)this.player)) {
                        yield true;
                    }
                    yield false;
                }
                case "f:unmastered" -> instance.isMastered((LivingEntity)this.player);
                case "f:learned" -> {
                    if (instance.getMastery() < 0 || !instance.isMastered((LivingEntity)this.player)) {
                        yield true;
                    }
                    yield false;
                }
                case "f:learning" -> {
                    if (instance.getMastery() >= 0) {
                        yield true;
                    }
                    yield false;
                }
                case "f:temporary" -> {
                    if (!instance.isTemporarySkill()) {
                        yield true;
                    }
                    yield false;
                }
                case "f:toggleable" -> {
                    if (!instance.canBeToggled((LivingEntity)this.player)) {
                        yield true;
                    }
                    yield false;
                }
                case "f:toggledon" -> {
                    if (!instance.isToggled()) {
                        yield true;
                    }
                    yield false;
                }
                case "f:toggledoff" -> {
                    if (!instance.canBeToggled((LivingEntity)this.player) || instance.isToggled()) {
                        yield true;
                    }
                    yield false;
                }
                case "f:oncooldown" -> {
                    if (!instance.onCoolDown()) {
                        yield true;
                    }
                    yield false;
                }
                case "f:offcooldown" -> instance.onCoolDown();
                default -> {
                    if (!filter.isEmpty() || !filter.isBlank()) {
                        if (!magic.getName().getString().toLowerCase().contains(filter.toLowerCase())) {
                            yield true;
                        }
                        yield false;
                    }
                    yield magic.getType() != ((MagicSelectionMenu)this.f_97732_).getMagicType();
                }
            };
        };
        return predicate;
    }
}

