/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.screen;

import com.github.manasmods.tensura.ability.skill.unique.FalsifierSkill;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.skill.RequestFalsifierItemPacket;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.Cached;
import com.github.manasmods.tensura.util.SimpleScreen;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Wearable;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class FalsifierScreen
extends SimpleScreen {
    private final ResourceLocation BACKGROUND = new ResourceLocation("tensura", "textures/gui/falsifier/falsifier.png");
    private EditBox searchField;
    private EquipmentSlot selectedSlot = null;
    private int listX = -1;
    private int listY = -1;
    private int startIndex = 0;
    private ItemStack headSlot;
    private ItemStack chestSlot;
    private ItemStack legsSlot;
    private ItemStack feetSlot;
    private ItemStack mainHand;
    private ItemStack offHand;
    private float scrollOffs = 0.0f;
    private boolean scrolling = false;
    private final Cached<List<ItemStack>, String> items = new Cached(() -> {
        if (this.selectedSlot == null) {
            return new ArrayList();
        }
        List<ItemStack> registries = ForgeRegistries.ITEMS.getValues().stream().toList().stream().filter(item -> item != Items.f_41852_).sorted(Comparator.comparing(item -> ForgeRegistries.ITEMS.getKey(item).m_135815_())).map(Item::m_7968_).toList();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(Items.f_41852_.m_7968_());
        list.addAll(registries);
        String search = this.searchField.m_94155_();
        list.removeIf(item -> {
            if (!this.isCorrectEquipmentSlot((ItemStack)item)) {
                return true;
            }
            if (search.isEmpty() || search.isBlank()) {
                return false;
            }
            return !item.m_41611_().getString().toLowerCase().contains(search.toLowerCase());
        });
        return list;
    }, info -> {
        if (info.lastCallbackReference == null || !((String)info.lastCallbackReference).equals(this.searchField.m_94155_())) {
            info.lastCallbackReference = this.searchField.m_94155_();
            info.needsUpdate = true;
        }
        return info;
    });

    public FalsifierScreen() {
        super((Component)Objects.requireNonNull(((FalsifierSkill)((Object)UniqueSkills.FALSIFIER.get())).getName()), 105, 103);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.searchField = new EditBox(this.f_96547_, 0, 0, 65, 10, (Component)Component.m_237119_());
        this.searchField.m_94182_(false);
        this.searchField.m_94151_(s -> {
            this.startIndex = 0;
            this.scrollOffs = 0.0f;
        });
        this.m_142416_((GuiEventListener)this.searchField);
        this.headSlot = RequestFalsifierItemPacket.getFalsifierItem((LivingEntity)this.player, EquipmentSlot.HEAD);
        this.chestSlot = RequestFalsifierItemPacket.getFalsifierItem((LivingEntity)this.player, EquipmentSlot.CHEST);
        this.legsSlot = RequestFalsifierItemPacket.getFalsifierItem((LivingEntity)this.player, EquipmentSlot.LEGS);
        this.feetSlot = RequestFalsifierItemPacket.getFalsifierItem((LivingEntity)this.player, EquipmentSlot.FEET);
        this.mainHand = RequestFalsifierItemPacket.getFalsifierItem((LivingEntity)this.player, EquipmentSlot.MAINHAND);
        this.offHand = RequestFalsifierItemPacket.getFalsifierItem((LivingEntity)this.player, EquipmentSlot.OFFHAND);
    }

    @Override
    protected void renderBg(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
        this.m_93228_(pPoseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
        TensuraGUIHelper.renderCenteredXText(this.f_96547_, pPoseStack, this.f_96539_, this.guiLeft, this.guiTop + 7, this.imageWidth, Color.WHITE, false);
        float sizeMultiplier = RaceHelper.getSizeMultiplier((LivingEntity)this.player);
        sizeMultiplier = sizeMultiplier > 1.0f ? 1.0f / sizeMultiplier : 1.0f;
        TensuraGUIHelper.renderEntityOnScreen(this.guiLeft + 51, this.guiTop + 87, 28.0f * sizeMultiplier, 0.0f, 0.0f, (LivingEntity)this.player);
        if (this.selectedSlot != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
            FalsifierScreen.m_93133_((PoseStack)pPoseStack, (int)this.listX, (int)this.listY, (float)106.0f, (float)(this.selectedArmor() ? 23.0f : 0.0f), (int)93, (int)22, (int)256, (int)256);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
            FalsifierScreen.m_93133_((PoseStack)pPoseStack, (int)(this.selectedArmor() ? this.listX + 12 : this.listX + 2), (int)(this.listY + 22), (float)106.0f, (float)46.0f, (int)79, (int)72, (int)256, (int)256);
            int posY = (int)(42.0f * this.scrollOffs);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
            FalsifierScreen.m_93133_((PoseStack)pPoseStack, (int)(this.selectedArmor() ? this.listX + 80 : this.listX + 70), (int)(this.listY + 24 + posY), (float)(this.isScrollBarActive() ? 93.0f : 87.0f), (float)104.0f, (int)6, (int)23, (int)256, (int)256);
        }
        this.displayItems(pPoseStack, pMouseX, pMouseY);
        this.renderTooltip(pPoseStack, pMouseX, pMouseY);
        super.renderWidgets(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void displayItems(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderItemTexture(this.headSlot, this.guiLeft + 10, this.guiTop + 23);
        this.renderItemTexture(this.chestSlot, this.guiLeft + 10, this.guiTop + 41);
        this.renderItemTexture(this.legsSlot, this.guiLeft + 10, this.guiTop + 59);
        this.renderItemTexture(this.feetSlot, this.guiLeft + 10, this.guiTop + 77);
        this.renderItemTexture(this.mainHand, this.guiLeft + 79, this.guiTop + 59);
        this.renderItemTexture(this.offHand, this.guiLeft + 79, this.guiTop + 77);
        if (this.selectedSlot == null) {
            return;
        }
        boolean hoverClear = TensuraGUIHelper.mouseOver(mouseX, mouseY, this.selectedArmor() ? this.listX + 4 : this.listX + 76, this.selectedArmor() ? this.listX + 17 : this.listX + 89, this.listY + 7, this.listY + 18);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
        FalsifierScreen.m_93133_((PoseStack)poseStack, (int)(this.selectedArmor() ? this.listX + 4 : this.listX + 76), (int)(this.listY + 7), (float)0.0f, (float)(hoverClear ? 115.0f : 104.0f), (int)13, (int)11, (int)256, (int)256);
        if (this.items.getValue().isEmpty()) {
            return;
        }
        for (int i = this.startIndex; i < this.startIndex + 5 && i < this.items.getValue().size(); ++i) {
            int buttonY = this.listY + 24 + 13 * (i - this.startIndex);
            boolean isHovered = TensuraGUIHelper.mouseOver(mouseX, mouseY, this.selectedArmor() ? this.listX + 16 : this.listX + 6, this.selectedArmor() ? this.listX + 78 : this.listX + 68, buttonY - 1, buttonY + 13);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
            FalsifierScreen.m_93133_((PoseStack)poseStack, (int)(this.selectedArmor() ? this.listX + 17 : this.listX + 7), (int)buttonY, (float)26.0f, (float)(isHovered ? 117.0f : 104.0f), (int)61, (int)13, (int)256, (int)256);
            ItemStack item = this.items.getValue().get(i);
            MutableComponent component = item.m_41619_() ? Component.m_237115_((String)"tensura.skill.falsifier.empty") : item.m_41786_();
            this.f_96547_.m_92889_(poseStack, TensuraGUIHelper.shortenTextComponent(component.getString(), 8), this.selectedArmor() ? (float)(this.listX + 20) : (float)(this.listX + 10), (float)(buttonY + 3), item.m_41619_() ? Color.LIGHT_GRAY.getRGB() : Color.WHITE.getRGB());
        }
    }

    @Override
    protected void renderTooltip(PoseStack poseStack, int pMouseX, int pMouseY) {
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 8, this.getGuiLeft() + 27, this.getGuiTop() + 21, this.getGuiTop() + 40)) {
            this.renderItemTooltip(poseStack, this.headSlot, pMouseX, pMouseY, true);
        } else if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 8, this.getGuiLeft() + 27, this.getGuiTop() + 39, this.getGuiTop() + 58)) {
            this.renderItemTooltip(poseStack, this.chestSlot, pMouseX, pMouseY, true);
        } else if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 8, this.getGuiLeft() + 27, this.getGuiTop() + 57, this.getGuiTop() + 76)) {
            this.renderItemTooltip(poseStack, this.legsSlot, pMouseX, pMouseY, true);
        } else if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 8, this.getGuiLeft() + 27, this.getGuiTop() + 75, this.getGuiTop() + 94)) {
            this.renderItemTooltip(poseStack, this.feetSlot, pMouseX, pMouseY, true);
        } else if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 77, this.getGuiLeft() + 96, this.getGuiTop() + 57, this.getGuiTop() + 76)) {
            this.renderItemTooltip(poseStack, this.mainHand, pMouseX, pMouseY, true);
        } else if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 77, this.getGuiLeft() + 96, this.getGuiTop() + 75, this.getGuiTop() + 94)) {
            this.renderItemTooltip(poseStack, this.offHand, pMouseX, pMouseY, true);
        } else if (this.selectedSlot != null && this.selectedSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.listX + 76, this.listX + 89, this.listY + 7, this.listY + 18)) {
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)"tensura.skill.falsifier.clear_slot").m_130940_(ChatFormatting.RED), pMouseX, pMouseY);
        } else if (this.selectedSlot != null && this.selectedSlot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR) && TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.listX + 4, this.listX + 17, this.listY + 7, this.listY + 18)) {
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)"tensura.skill.falsifier.clear_slot").m_130940_(ChatFormatting.RED), pMouseX, pMouseY);
        }
        for (int i = this.startIndex; i < this.startIndex + 5 && i < this.items.getValue().size(); ++i) {
            int posY = this.listY + 24 + 13 * (i - this.startIndex);
            if (!TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.selectedArmor() ? this.listX + 16 : this.listX + 6, this.selectedArmor() ? this.listX + 78 : this.listX + 68, posY - 1, posY + 13)) continue;
            this.renderItemTooltip(poseStack, this.items.getValue().get(i), pMouseX, pMouseY, false);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.selectedArmor() ? this.listX + 80 : this.listX + 70, this.selectedArmor() ? this.listX + 86 : this.listX + 76, this.listY + 24, this.listY + 67)) {
            this.scrolling = true;
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 8, this.getGuiLeft() + 27, this.getGuiTop() + 21, this.getGuiTop() + 40)) {
            this.updateSelectedSlot(EquipmentSlot.HEAD);
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 8, this.getGuiLeft() + 27, this.getGuiTop() + 39, this.getGuiTop() + 58)) {
            this.updateSelectedSlot(EquipmentSlot.CHEST);
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 8, this.getGuiLeft() + 27, this.getGuiTop() + 57, this.getGuiTop() + 76)) {
            this.updateSelectedSlot(EquipmentSlot.LEGS);
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 8, this.getGuiLeft() + 27, this.getGuiTop() + 75, this.getGuiTop() + 94)) {
            this.updateSelectedSlot(EquipmentSlot.FEET);
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 77, this.getGuiLeft() + 96, this.getGuiTop() + 57, this.getGuiTop() + 76)) {
            this.updateSelectedSlot(EquipmentSlot.MAINHAND);
            return true;
        }
        if (TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.getGuiLeft() + 77, this.getGuiLeft() + 96, this.getGuiTop() + 75, this.getGuiTop() + 94)) {
            this.updateSelectedSlot(EquipmentSlot.OFFHAND);
            return true;
        }
        if (this.selectedSlot != null && this.selectedSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) && TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.listX + 76, this.listX + 89, this.listY + 7, this.listY + 18)) {
            TensuraGUIHelper.playSound(SoundEvents.f_12490_, 1.0f);
            this.setItem(new ItemStack((ItemLike)Items.f_41852_), this.selectedSlot);
            return true;
        }
        if (this.selectedSlot != null && this.selectedSlot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR) && TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.listX + 4, this.listX + 17, this.listY + 7, this.listY + 18)) {
            TensuraGUIHelper.playSound(SoundEvents.f_12490_, 1.0f);
            this.setItem(new ItemStack((ItemLike)Items.f_41852_), this.selectedSlot);
            return true;
        }
        for (int i = this.startIndex; i < this.startIndex + 5 && i < this.items.getValue().size(); ++i) {
            int posY = this.listY + 24 + 13 * (i - this.startIndex);
            if (!TensuraGUIHelper.mouseOver(pMouseX, pMouseY, this.selectedArmor() ? this.listX + 16 : this.listX + 6, this.selectedArmor() ? this.listX + 78 : this.listX + 68, posY - 1, posY + 13)) continue;
            TensuraGUIHelper.playSound(SoundEvents.f_12490_, 1.0f);
            ItemStack item = this.items.getValue().get(i);
            if (item.m_41619_()) {
                item = RequestFalsifierItemPacket.getEmptyStack();
            }
            this.setItem(item, this.selectedSlot);
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            float scrollBarHeight = 23.0f;
            int scrollBarBeginPos = this.listY + 24;
            int fullLength = scrollBarBeginPos + 65;
            this.scrollOffs = (float)((pMouseY - (double)scrollBarBeginPos - (double)(scrollBarHeight / 2.0f)) / (double)((float)(fullLength - scrollBarBeginPos) - scrollBarHeight));
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive() && this.selectedSlot != null) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, Math.min(this.startIndex - (int)pDelta, this.items.getValue().size() - 5));
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchField.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.searchField.m_93696_() && this.searchField.m_94213_() && pKeyCode != 256) {
            return true;
        }
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    private void updateSelectedSlot(EquipmentSlot slot) {
        TensuraGUIHelper.playSound(SoundEvents.f_12490_, 1.0f);
        this.selectedSlot = slot;
        this.listX = this.selectedArmor() ? this.getGuiLeft() - 93 : this.getGuiLeft() + 105;
        this.listY = this.getGuiTop() + 21 + 18 * (this.selectedArmor() ? 4 - this.selectedSlot.m_20750_() : 2 + this.selectedSlot.m_20749_());
        this.searchField.f_93620_ = this.selectedArmor() ? this.listX + 21 : this.listX + 7;
        this.searchField.f_93621_ = this.listY + 7;
        this.searchField.m_94144_("");
    }

    private void renderItemTooltip(PoseStack poseStack, ItemStack stack, int pMouseX, int pMouseY, boolean checkEmpty) {
        if (checkEmpty && stack.m_41619_()) {
            return;
        }
        if (stack.m_41619_() || stack.m_41783_() != null && stack.m_41783_().m_128471_("Empty")) {
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)"tensura.skill.falsifier.empty").m_130940_(ChatFormatting.RED), pMouseX, pMouseY);
        } else {
            this.m_6057_(poseStack, stack, pMouseX, pMouseY);
        }
    }

    private void renderItemTexture(ItemStack stack, int x, int y) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128471_("Empty")) {
            stack = new ItemStack((ItemLike)Items.f_42127_);
        }
        this.f_96542_.m_115203_(stack, x, y);
    }

    private boolean isScrollBarActive() {
        return this.items.getValue().size() > 5;
    }

    private int getOffscreenRows() {
        return this.items.getValue().size() - 5;
    }

    private boolean selectedArmor() {
        if (this.selectedSlot == null) {
            return false;
        }
        return this.selectedSlot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR);
    }

    private boolean isCorrectEquipmentSlot(ItemStack stack) {
        ArmorItem armorItem;
        BlockItem blockItem;
        Item item;
        if (this.selectedSlot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) {
            return true;
        }
        if (stack.m_150930_(Items.f_41852_)) {
            return true;
        }
        if (stack.getEquipmentSlot() == this.selectedSlot) {
            return true;
        }
        if (this.selectedSlot.equals((Object)EquipmentSlot.HEAD) && (item = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof Wearable) {
            return true;
        }
        item = stack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_().equals((Object)this.selectedSlot);
    }

    private void setItem(ItemStack item, EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                this.headSlot = item;
                break;
            }
            case CHEST: {
                this.chestSlot = item;
                break;
            }
            case LEGS: {
                this.legsSlot = item;
                break;
            }
            case FEET: {
                this.feetSlot = item;
                break;
            }
            case MAINHAND: {
                this.mainHand = item;
                break;
            }
            case OFFHAND: {
                this.offHand = item;
            }
        }
        TensuraNetwork.INSTANCE.sendToServer((Object)new RequestFalsifierItemPacket(item, slot));
    }
}

