/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client.screen;

import com.github.manasmods.manascore.api.client.gui.widget.ImagePredicateButton;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.github.manasmods.tensura.menu.DegenerateEnchantmentMenu;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.RequestDisenchantPacket;
import com.github.manasmods.tensura.network.play2server.RequestMenuSwitchPacket;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class DegenerateEnchantmentScreen
extends AbstractContainerScreen<DegenerateEnchantmentMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tensura", "textures/gui/degenerate/degenerate_tab_2.png");
    private static final ResourceLocation ENCHANTMENT_BUTTON = new ResourceLocation("tensura", "textures/gui/skill_button.png");
    private static final ResourceLocation SCROLL_BAR = new ResourceLocation("tensura", "textures/gui/scroll_bar.png");
    private static final ResourceLocation BLANK = new ResourceLocation("tensura", "textures/blank_texture.png");
    private List<Enchantment> enchantments = new ArrayList<Enchantment>();
    private List<Integer> levels = new ArrayList<Integer>();
    private boolean scrolling;
    private float scrollOffs;
    private int startIndex;

    public DegenerateEnchantmentScreen(DegenerateEnchantmentMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, (Component)pTitle.m_6881_().m_130940_(ChatFormatting.WHITE));
        pMenu.registerUpdateListener(this::containerChanged);
        this.f_97726_ = 210;
        this.f_97727_ = 199;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
        ImagePredicateButton tabSwitch = new ImagePredicateButton(0, 0, 26, 22, BLANK, pButton -> TensuraNetwork.INSTANCE.sendToServer((Object)new RequestMenuSwitchPacket(RequestMenuSwitchPacket.SwitchType.DEGENERATE_TAB_2_TO_TAB_1)), (button, poseStack, i, i1) -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)"tooltip.tensura.degenerate_menu.tab_1"), i, i1), ((DegenerateEnchantmentMenu)this.f_97732_)::check);
        tabSwitch.f_93620_ = this.getGuiLeft() + 5;
        tabSwitch.f_93621_ = this.getGuiTop() + 2;
        this.m_142416_((GuiEventListener)tabSwitch);
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        this.f_96547_.m_92889_(pPoseStack, (Component)Component.m_237115_((String)"tensura.degenerate_menu.synthesis"), 10.0f, (float)this.f_97729_ + 28.0f, new Color(225, 225, 225).getRGB());
        this.f_96547_.m_92889_(pPoseStack, (Component)Component.m_237115_((String)"tensura.degenerate_menu.separation"), 10.0f, (float)this.f_97729_ + 48.0f, new Color(225, 225, 225).getRGB());
        this.f_96547_.m_92889_(pPoseStack, this.f_169604_, 80.0f, (float)this.f_97731_ + 35.0f, new Color(63, 63, 64).getRGB());
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        this.m_7333_(pPoseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(pPoseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(26.0f * this.scrollOffs);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCROLL_BAR);
        DegenerateEnchantmentScreen.m_93133_((PoseStack)pPoseStack, (int)(this.f_97735_ + 161), (int)(this.f_97736_ + 63 + k), (float)0.0f, (float)(this.isScrollBarActive() ? 13.0f : 0.0f), (int)10, (int)13, (int)10, (int)26);
        int lastVisibleElementIndex = this.startIndex + 3;
        this.enchantments = ((DegenerateEnchantmentMenu)this.f_97732_).getInputEnchantments().keySet().stream().toList();
        this.levels = ((DegenerateEnchantmentMenu)this.f_97732_).getInputEnchantments().values().stream().toList();
        this.renderButtons(pPoseStack, pMouseX, pMouseY, lastVisibleElementIndex);
        this.renderTabIcons();
    }

    private void renderButtons(PoseStack pPoseStack, int pMouseX, int pMouseY, int pLastVisibleElementIndex) {
        for (int i = this.startIndex; i < pLastVisibleElementIndex && i < this.enchantments.size(); ++i) {
            boolean hovering;
            int x = this.getGuiLeft() + 69;
            int y = this.getGuiTop() + 63 + (i - this.startIndex) * 13;
            int offset = 0;
            boolean bl = hovering = pMouseX >= x && pMouseY >= y && pMouseX < x + 89 && pMouseY < y + 13;
            if (hovering) {
                offset = 13;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)ENCHANTMENT_BUTTON);
            DegenerateEnchantmentScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)offset, (int)89, (int)13, (int)89, (int)26);
            Enchantment enchantment = this.enchantments.get(i);
            Component name = enchantment.m_44700_(this.levels.get(i).intValue());
            if (!enchantment.m_6589_()) {
                name = name.m_6881_().m_130940_(ChatFormatting.WHITE);
            }
            TensuraGUIHelper.renderScaledShadowText(pPoseStack, this.f_96547_, (FormattedText)TensuraGUIHelper.shortenTextComponent(name, 16), this.getGuiLeft() + 72, this.getGuiTop() + 67 + (i - this.startIndex) * 13, 84.0f, 9.0f, Color.WHITE.getRGB(), 2.0f, 0.01f);
            if (!hovering) continue;
            this.m_96602_(pPoseStack, name, pMouseX, pMouseY);
        }
    }

    private void renderTabIcons() {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91291_().m_115203_(new ItemStack((ItemLike)Items.f_41960_), this.getGuiLeft() + 10, this.getGuiTop() + 7);
        this.f_96541_.m_91291_().m_115203_(new ItemStack((ItemLike)Items.f_42690_), this.getGuiLeft() + 38, this.getGuiTop() + 6);
    }

    protected void m_7025_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        if (((DegenerateEnchantmentMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.m_6057_(pPoseStack, this.f_97734_.m_7993_(), pMouseX, pMouseY);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        int lastDisplayedRecipeIndex = this.startIndex + 3;
        for (int i = this.startIndex; i < lastDisplayedRecipeIndex; ++i) {
            int x = this.getGuiLeft() + 69;
            int y = this.getGuiTop() + 63 + (i - this.startIndex) * 13;
            if (this.enchantments.size() <= i) break;
            if (!(pMouseX >= (double)x) || !(pMouseY >= (double)y) || !(pMouseX < (double)(x + 89)) || !(pMouseY < (double)(y + 13))) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11887_, (float)1.0f));
            TensuraNetwork.INSTANCE.sendToServer((Object)new RequestDisenchantPacket(this.enchantments.get(i), this.levels.get(i)));
            return true;
        }
        if (pMouseX >= (double)(this.getGuiLeft() + 161) && pMouseX < (double)(this.getGuiLeft() + 172) && pMouseY >= (double)(this.getGuiTop() + 63) && pMouseY < (double)(this.getGuiTop() + 102)) {
            this.scrolling = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, Math.min(this.startIndex - (int)pDelta, this.enchantments.size() - 3));
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.getGuiTop() + 63;
            int j = i + 34;
            this.scrollOffs = (float)((pMouseY - (double)i - 6.5) / (double)((float)(j - i) - 13.0f));
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private boolean isScrollBarActive() {
        return this.enchantments.size() > 3;
    }

    private int getOffscreenRows() {
        return this.enchantments.size() - 3;
    }

    private void containerChanged() {
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

