/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.client;

import com.github.manasmods.manascore.api.client.gui.widget.ImagePredicateButton;
import com.github.manasmods.manascore.api.client.gui.widget.RenderCheck;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2server.GUISwitchPacket;
import com.github.manasmods.tensura.network.play2server.RequestContainerButtonClickPacket;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TensuraGUIHelper {
    public static final ResourceLocation SETTINGS_TAB = new ResourceLocation("tensura", "textures/gui/settings_tab_button.png");
    public static final ResourceLocation COMING_SOON_TAB = new ResourceLocation("tensura", "textures/gui/coming_soon_tab.png");
    public static final ResourceLocation COMING_SOON_ICON = new ResourceLocation("tensura", "textures/gui/coming_soon_tab_icon.png");

    public static void spawnMarkerParticle(Level pLevel, BlockState pState, BlockPos pos, Predicate<Item> predicate) {
        if (!pLevel.m_5776_()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!predicate.test(player.m_21205_().m_41720_()) && !predicate.test(player.m_21206_().m_41720_())) {
            return;
        }
        pLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, pState), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
    }

    public static void spawnMarkerParticle(Level pLevel, BlockState pState, BlockPos pos, Item item) {
        TensuraGUIHelper.spawnMarkerParticle(pLevel, pState, pos, (Item pItem) -> pItem == item);
    }

    public static ImmutableList<ImagePredicateButton> addMenuTabs(AbstractContainerScreen<?> screen, int currentMenu, boolean renderCheck) {
        ArrayList<ImagePredicateButton> buttons = new ArrayList<ImagePredicateButton>();
        for (int i = 0; i < 7; ++i) {
            int height;
            int width;
            int pY;
            int pX;
            int j = (i + 4) % 7;
            int left = screen.getGuiLeft();
            int top = screen.getGuiTop();
            if (i < 3) {
                pX = left + 4 + i * 26;
                pY = top + 2;
                width = 24;
                height = 21;
            } else {
                pX = left + 233;
                pY = top + 30 + (i - 3) * 26;
                width = 21;
                height = 24;
            }
            if (j == currentMenu) continue;
            ResourceLocation texture = TensuraGUIHelper.getTabButtonIcon(j);
            RenderCheck check = () -> renderCheck;
            ImagePredicateButton button = new ImagePredicateButton(pX, pY, width, height, texture, onPress -> TensuraNetwork.INSTANCE.sendToServer((Object)new GUISwitchPacket(j)), (button1, poseStack1, x, y) -> screen.m_96602_(poseStack1, TensuraGUIHelper.getMenuName(j), x, y), check);
            buttons.add(button);
        }
        buttons.add(TensuraGUIHelper.addSettingsButton(screen));
        return ImmutableList.copyOf(buttons);
    }

    public static ImagePredicateButton addSettingsButton(AbstractContainerScreen<?> screen) {
        int pX = screen.getGuiLeft() + 202;
        int pY = screen.getGuiTop() + 2;
        int width = 24;
        int height = 21;
        return new ImagePredicateButton(pX, pY, width, height, SETTINGS_TAB, onPress -> TensuraNetwork.INSTANCE.sendToServer((Object)new GUISwitchPacket(8)), (button1, poseStack1, x, y) -> screen.m_96602_(poseStack1, (Component)Component.m_237115_((String)"tensura.settings"), x, y), () -> true);
    }

    public static void renderTabIcon(PoseStack poseStack, AbstractContainerScreen<?> screen, int menu, int mouseX, int mouseY) {
        int tooltipY;
        int tooltipX;
        int y;
        int x;
        int guiLeft = screen.getGuiLeft();
        int guiTop = screen.getGuiTop();
        boolean top = false;
        if (menu < 4) {
            x = guiLeft + 234;
            y = guiTop + 34 + menu * 26;
            tooltipX = x - 2;
            tooltipY = y - 5;
        } else {
            x = guiLeft + 8 + (menu - 4) * 26;
            y = guiTop + 5;
            tooltipX = x - 5;
            tooltipY = guiTop - 1;
            top = true;
        }
        int width = top ? 25 : 24;
        int height = top ? 24 : 25;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TensuraGUIHelper.getTabIcon(menu));
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        if (TensuraGUIHelper.mouseOver(mouseX, mouseY, tooltipX, tooltipX + width, tooltipY, tooltipY + height)) {
            screen.m_96602_(poseStack, TensuraGUIHelper.getMenuName(menu), mouseX, mouseY);
        }
    }

    public static Component getMenuName(int menu) {
        return switch (menu) {
            case 0 -> Component.m_237115_((String)"tensura.main_menu");
            case 4 -> Component.m_237115_((String)"tensura.skill_menu");
            case 5 -> Component.m_237115_((String)"tensura.magic_menu");
            case 6 -> Component.m_237115_((String)"tensura.battlewill_menu");
            default -> SkillHelper.comingSoon();
        };
    }

    public static ResourceLocation getTabIcon(int menu) {
        return switch (menu) {
            case 0 -> new ResourceLocation("tensura", "textures/gui/main/status_icon.png");
            case 4 -> new ResourceLocation("tensura", "textures/gui/skill/skill_tab_icon.png");
            case 5 -> new ResourceLocation("tensura", "textures/gui/magic/magic_tab_icon.png");
            case 6 -> new ResourceLocation("tensura", "textures/item/battlewill_manual.png");
            default -> COMING_SOON_ICON;
        };
    }

    public static ResourceLocation getTabButtonIcon(int menu) {
        return switch (menu) {
            case 0 -> new ResourceLocation("tensura", "textures/gui/main/status_tab.png");
            case 4 -> new ResourceLocation("tensura", "textures/gui/skill/skill_tab_button.png");
            case 5 -> new ResourceLocation("tensura", "textures/gui/magic/magic_tab_button.png");
            case 6 -> new ResourceLocation("tensura", "textures/gui/battlewill/battlewill_tab_button.png");
            default -> COMING_SOON_TAB;
        };
    }

    public static void playSound(SoundEvent event, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)pitch));
    }

    public static boolean buttonClick(Player player, AbstractContainerScreen<?> screen, @Nullable SoundEvent soundEvent, int id) {
        screen.m_6262_().m_6366_(player, id);
        if (soundEvent != null && player.f_19853_.m_5776_()) {
            TensuraGUIHelper.playSound(soundEvent, 1.0f);
        }
        TensuraNetwork.INSTANCE.sendToServer((Object)new RequestContainerButtonClickPacket(screen.m_6262_().f_38840_, id));
        return true;
    }

    public static boolean mouseOver(double mouseX, double mouseY, int x1, int x2, int y1, int y2) {
        return TensuraGUIHelper.mouseOver((int)mouseX, (int)mouseY, x1, x2, y1, y2);
    }

    public static boolean mouseOver(int mouseX, int mouseY, int x1, int x2, int y1, int y2) {
        return mouseX > x1 && mouseX < x2 && mouseY > y1 && mouseY < y2;
    }

    public static Component shortenTextComponent(Component text, int length) {
        return TensuraGUIHelper.shortenTextComponent(text.getString(), length).m_6881_().m_130948_(text.m_7383_());
    }

    public static Component shortenTextComponent(String text, int length) {
        if (text.length() > length) {
            String shorten = text.substring(0, length);
            if (String.valueOf(shorten.charAt(length - 1)).equals(" ")) {
                shorten = text.substring(0, length - 1);
            }
            return Component.m_237113_((String)(shorten + "..."));
        }
        return Component.m_237113_((String)text);
    }

    public static Component shortenNumberComponent(double number) {
        if (number < 1000000.0) {
            return Component.m_237113_((String)new DecimalFormat("#").format(number));
        }
        DecimalFormat decimal = new DecimalFormat("#.##");
        if (number < 1.0E9) {
            return Component.m_237110_((String)"tensura.main_menu.million_index", (Object[])new Object[]{decimal.format(number / 1000000.0)});
        }
        return Component.m_237110_((String)"tensura.main_menu.billion_index", (Object[])new Object[]{decimal.format(number / 1.0E9)});
    }

    public static void renderCenteredXText(Font font, PoseStack poseStack, Component text, int x, int y, int width, Color color, boolean shadow) {
        int centered = x + (width - font.m_92852_((FormattedText)text)) / 2;
        if (shadow) {
            font.m_92763_(poseStack, text, (float)centered, (float)y, color.getRGB());
        } else {
            font.m_92889_(poseStack, text, (float)centered, (float)y, color.getRGB());
        }
    }

    public static void renderScaledCenteredXText(Font font, PoseStack poseStack, Component text, int x, int y, int width, int height, Color color, boolean shadow) {
        TensuraGUIHelper.renderScaledCenteredXText(poseStack, font, (FormattedText)text, x, y, width, height, color.getRGB(), 0.0f, 0.01f, shadow);
    }

    public static void renderScaledCenteredXText(Font font, PoseStack poseStack, Component text, int x, int y, int width, int height, int color, boolean shadow) {
        TensuraGUIHelper.renderScaledCenteredXText(poseStack, font, (FormattedText)text, x, y, width, height, color, 0.0f, 0.01f, shadow);
    }

    private static void renderScaledCenteredXText(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, float height, int color, float spacePerLine, float scalingSteps, boolean shadow) {
        float scaling = 1.0f;
        while (true) {
            List formattedCharSequences = font.m_92923_(text, Math.round(width / scaling));
            float var10000 = formattedCharSequences.size();
            Objects.requireNonNull(font);
            if (!(var10000 * (9.0f + spacePerLine) * scaling > height)) {
                int centered = (int)(x + (width - (float)font.m_92852_(text)) / 2.0f);
                TensuraGUIHelper.renderScaledShadowText(poseStack, font, scaling, font.m_92923_(text, Math.round(width / scaling)), centered, y, color, spacePerLine);
                return;
            }
            scaling -= scalingSteps;
        }
    }

    public static void renderScaledShadowText(PoseStack poseStack, Font font, FormattedText text, float x, float y, float width, float height, int color, float spacePerLine, float scalingSteps) {
        float scaling = 1.0f;
        while (true) {
            List formattedCharSequences = font.m_92923_(text, Math.round(width / scaling));
            float var10000 = formattedCharSequences.size();
            Objects.requireNonNull(font);
            if (!(var10000 * (9.0f + spacePerLine) * scaling > height)) {
                TensuraGUIHelper.renderScaledShadowText(poseStack, font, scaling, font.m_92923_(text, Math.round(width / scaling)), x, y, color, spacePerLine);
                return;
            }
            scaling -= scalingSteps;
        }
    }

    private static void renderScaledShadowText(PoseStack poseStack, Font font, float scaling, List<FormattedCharSequence> text, float x, float y, int color, float spacePerLine) {
        poseStack.m_85841_(scaling, scaling, scaling);
        for (FormattedCharSequence charSequence : text) {
            font.m_92744_(poseStack, charSequence, x / scaling, y / scaling, color);
            Objects.requireNonNull(font);
            y += (9.0f + spacePerLine) * scaling;
        }
        poseStack.m_85841_(1.0f / scaling, 1.0f / scaling, 1.0f / scaling);
    }

    public static int renderWrappedText(PoseStack poseStack, Font font, FormattedText text, int x, int y, int width, int color, int spacePerLine) {
        return TensuraGUIHelper.renderWrappedText(poseStack, font, font.m_92923_(text, width), x, y, color, spacePerLine);
    }

    public static int renderCenteredWrappedText(PoseStack poseStack, Font font, FormattedText text, int x, int y, int width, int color, int spacePerLine) {
        return TensuraGUIHelper.renderCenteredWrappedText(poseStack, font, font.m_92923_(text, width), x, y, width, color, spacePerLine);
    }

    public static int renderWrappedText(PoseStack poseStack, Font font, List<FormattedCharSequence> text, int x, int y, int color, int spacePerLine) {
        for (FormattedCharSequence charSequence : text) {
            font.m_92877_(poseStack, charSequence, (float)x, (float)y, color);
            y += 9 + spacePerLine;
        }
        return y;
    }

    public static int renderCenteredWrappedText(PoseStack poseStack, Font font, List<FormattedCharSequence> text, int x, int y, int width, int color, int spacePerLine) {
        for (FormattedCharSequence charSequence : text) {
            int centered = x + (width - font.m_92724_(charSequence)) / 2;
            font.m_92877_(poseStack, charSequence, (float)centered, (float)y, color);
            y += 9 + spacePerLine;
        }
        return y;
    }

    public static void renderTextureOverlay(ResourceLocation pTextureLocation, float pAlpha, double screenHeight, double screenWidth) {
        TensuraGUIHelper.renderTextureOverlay(pTextureLocation, 1.0f, 1.0f, 1.0f, pAlpha, screenHeight, screenWidth);
    }

    public static void renderTextureOverlay(ResourceLocation pTextureLocation, int pColor, float pAlpha, double screenHeight, double screenWidth) {
        TensuraGUIHelper.renderTextureOverlay(pTextureLocation, (float)(pColor >> 16 & 0xFF) / 255.0f, (float)(pColor >> 8 & 0xFF) / 255.0f, (float)(pColor & 0xFF) / 255.0f, pAlpha, screenHeight, screenWidth);
    }

    public static void renderTextureOverlay(ResourceLocation pTextureLocation, float red, float green, float blue, float pAlpha, double screenHeight, double screenWidth) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)pAlpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)pTextureLocation);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_(screenWidth, screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_(screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderFadingTextureWithDuration(int duration, int startFade, ResourceLocation pTextureLocation, double screenHeight, double screenWidth) {
        float alphaValue = 1.0f;
        if (duration < startFade) {
            alphaValue = (float)duration / 200.0f;
        }
        TensuraGUIHelper.renderTextureOverlay(pTextureLocation, alphaValue, screenHeight, screenWidth);
    }

    public static void renderFadingTextureWithDuration(int duration, int startFade, int color, ResourceLocation pTextureLocation, double screenHeight, double screenWidth) {
        float alphaValue = 1.0f;
        if (duration < startFade) {
            alphaValue = (float)duration / 200.0f;
        }
        TensuraGUIHelper.renderTextureOverlay(pTextureLocation, color, alphaValue, screenHeight, screenWidth);
    }

    public static void renderFadingTextureWithDuration(int duration, int startFade, float red, float green, float blue, ResourceLocation pTextureLocation, double screenHeight, double screenWidth) {
        float alphaValue = 1.0f;
        if (duration < startFade) {
            alphaValue = (float)duration / 200.0f;
        }
        TensuraGUIHelper.renderTextureOverlay(pTextureLocation, red, green, blue, alphaValue, screenHeight, screenWidth);
    }

    public static void renderEntityOnScreen(double pPosX, double pPosY, float pScale, float angleXComponent, float angleYComponent, LivingEntity pLivingEntity) {
        angleXComponent = (float)Math.atan(angleXComponent / 40.0f);
        angleYComponent = (float)Math.atan(angleYComponent / 40.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_(pPosX, pPosY, 1050.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        posestack1.m_85841_(pScale, pScale, pScale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(angleYComponent * 20.0f);
        quaternion.m_80148_(quaternion1);
        posestack1.m_85845_(quaternion);
        float yBodyRot = pLivingEntity.f_20883_;
        float yRot = pLivingEntity.m_146908_();
        float xRot = pLivingEntity.m_146909_();
        float yHeadRotO = pLivingEntity.f_20886_;
        float yHeadRot = pLivingEntity.f_20885_;
        pLivingEntity.f_20883_ = 180.0f + angleXComponent * 20.0f;
        pLivingEntity.m_146922_(180.0f + angleXComponent * 40.0f);
        pLivingEntity.m_146926_(-angleYComponent * 20.0f);
        pLivingEntity.f_20885_ = pLivingEntity.m_146908_();
        pLivingEntity.f_20886_ = pLivingEntity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.m_80157_();
        entityrenderdispatcher.m_114412_(quaternion1);
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityrenderdispatcher.m_114384_((Entity)pLivingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        pLivingEntity.f_20883_ = yBodyRot;
        pLivingEntity.m_146922_(yRot);
        pLivingEntity.m_146926_(xRot);
        pLivingEntity.f_20886_ = yHeadRotO;
        pLivingEntity.f_20885_ = yHeadRot;
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }
}

