/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.capability.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.capability.skill.ITensuraSkillCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapabilityProvider;
import com.github.manasmods.tensura.event.SpiritLevelUpdateEvent;
import com.github.manasmods.tensura.handler.CapabilityHandler;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.SyncSkillCapabilityPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TensuraSkillCapability
implements ITensuraSkillCapability {
    public static final Capability<ITensuraSkillCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITensuraSkillCapability>(){});
    private static final ResourceLocation IDENTIFIER = new ResourceLocation("tensura", "presets");
    private int activePreset = 0;
    private int analysisLevel;
    private int analysisMode;
    private int analysisDistance;
    private int spiritCooldown = 0;
    private double waterPoint = 0.0;
    private double lavaPoint;
    private final List<String> presetNames = new ArrayList<String>();
    private final NonNullList<NonNullList<ResourceLocation>> presets = NonNullList.m_122780_((int)9, (Object)NonNullList.m_122780_((int)3, (Object)new ResourceLocation("tensura:none")));
    private List<String> warpNames = new ArrayList<String>();
    private NonNullList<NonNullList<Double>> warps = NonNullList.m_122780_((int)3, (Object)NonNullList.m_122780_((int)3, (Object)0.0));
    private final List<Integer> spiritLevels = new ArrayList<Integer>();

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Player) {
            e.addCapability(IDENTIFIER, (ICapabilityProvider)new TensuraSkillCapabilityProvider());
        }
    }

    public static LazyOptional<ITensuraSkillCapability> getFrom(Player player) {
        return player.getCapability(CAPABILITY);
    }

    public static void sync(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        TensuraSkillCapability.getFrom((Player)serverPlayer).ifPresent(data -> TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SyncSkillCapabilityPacket((ITensuraSkillCapability)data, serverPlayer.m_19879_())));
    }

    public TensuraSkillCapability() {
        int i;
        for (i = 1; i <= 9; ++i) {
            this.presetNames.add("Preset " + i);
        }
        for (i = 1; i <= 3; ++i) {
            this.warpNames.add("Warp " + i);
        }
        for (i = 1; i <= 7; ++i) {
            this.spiritLevels.add(0);
        }
        this.analysisLevel = 0;
        this.analysisMode = 0;
        this.analysisDistance = 5;
    }

    @Override
    public int getSpiritLevel(int spirit) {
        return this.spiritLevels.get(spirit);
    }

    @Override
    public boolean setSpiritLevel(Player player, int spirit, int level) {
        SpiritLevelUpdateEvent event = new SpiritLevelUpdateEvent(player, spirit, level);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        this.spiritLevels.set(event.getElemental().getId(), event.getSpiritLevel().getId());
        return true;
    }

    @Override
    public void clearSpiritLevel() {
        Collections.fill(this.spiritLevels, 0);
    }

    @Override
    @Nullable
    public ManasSkill getSkillInSlot(int slot) {
        ResourceLocation skillId = (ResourceLocation)((NonNullList)this.presets.get(this.activePreset)).get(slot);
        return (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillId);
    }

    @Override
    @Nullable
    public ManasSkill getSkillInPresetSlot(int preset, int slot) {
        ResourceLocation skillId = (ResourceLocation)((NonNullList)this.presets.get(preset)).get(slot);
        return (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillId);
    }

    @Override
    public boolean isSkillInSlots(ManasSkill skill) {
        return ((NonNullList)this.presets.get(this.activePreset)).contains((Object)SkillUtils.getSkillId(skill));
    }

    @Override
    public boolean isSkillInSpecificSlot(ManasSkill skill, int slot) {
        if (((NonNullList)this.presets.get(this.activePreset)).isEmpty()) {
            return false;
        }
        return ((ResourceLocation)((NonNullList)this.presets.get(this.activePreset)).get(slot)).equals((Object)SkillUtils.getSkillId(skill));
    }

    @Override
    public void setInstanceInSlot(@Nullable ManasSkillInstance instance, int slot) {
        if (instance == null) {
            ((NonNullList)this.presets.get(this.activePreset)).set(slot, (Object)new ResourceLocation("tensura", "none"));
            return;
        }
        ((NonNullList)this.presets.get(this.activePreset)).set(slot, (Object)instance.getSkillId());
    }

    @Override
    public void setInstanceInPresetSlot(@Nullable ManasSkillInstance instance, int preset, int slot) {
        if (instance == null) {
            ((NonNullList)this.presets.get(preset)).set(slot, (Object)new ResourceLocation("tensura", "none"));
            return;
        }
        ((NonNullList)this.presets.get(preset)).set(slot, (Object)instance.getSkillId());
    }

    @Override
    public boolean removeSkillFromSlots(ManasSkill skill) {
        boolean success = false;
        ResourceLocation id = SkillUtils.getSkillId(skill);
        for (int list = 0; list < 9; ++list) {
            if (!((NonNullList)this.presets.get(list)).contains((Object)id)) continue;
            for (int i = 0; i < 3; ++i) {
                if (!((ResourceLocation)((NonNullList)this.presets.get(list)).get(i)).equals((Object)id)) continue;
                ((NonNullList)this.presets.get(list)).set(i, (Object)new ResourceLocation("tensura:none"));
                success = true;
            }
        }
        return success;
    }

    @Override
    public String getPresetName(int number) {
        return this.presetNames.get(number);
    }

    @Override
    public void setPresetName(int number, String name) {
        this.presetNames.set(number, name);
    }

    @Override
    public String getWarpName(int warp) {
        return this.warpNames.get(warp);
    }

    @Override
    public void setWarpName(int warp, String name) {
        this.warpNames.set(warp, name);
    }

    @Override
    public double getWarpX(int warp) {
        return (Double)((NonNullList)this.warps.get(warp)).get(0);
    }

    @Override
    public double getWarpY(int warp) {
        return (Double)((NonNullList)this.warps.get(warp)).get(1);
    }

    @Override
    public double getWarpZ(int warp) {
        return (Double)((NonNullList)this.warps.get(warp)).get(2);
    }

    @Override
    public void setWarp(int warp, double x, double y, double z) {
        ((NonNullList)this.warps.get(warp)).set(0, (Object)x);
        ((NonNullList)this.warps.get(warp)).set(1, (Object)y);
        ((NonNullList)this.warps.get(warp)).set(2, (Object)z);
    }

    @Override
    public void clearAllWarp() {
        this.warpNames = new ArrayList<String>();
        for (int i = 1; i <= 3; ++i) {
            this.warpNames.add("Warp " + i);
        }
        this.warps = NonNullList.m_122780_((int)3, (Object)NonNullList.m_122780_((int)3, (Object)0.0));
    }

    @Override
    public void setWaterPoint(double point) {
        this.waterPoint = Mth.m_14008_((double)point, (double)0.0, (double)10000.0);
    }

    @Override
    public void setLavaPoint(double point) {
        this.lavaPoint = Mth.m_14008_((double)point, (double)0.0, (double)10000.0);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("spiritCooldown", this.spiritCooldown);
        tag.m_128405_("activePreset", this.activePreset);
        tag.m_128347_("waterPoint", this.waterPoint);
        tag.m_128347_("lavaPoint", this.lavaPoint);
        tag.m_128405_("analysisLevel", this.analysisLevel);
        tag.m_128405_("analysisMode", this.analysisMode);
        tag.m_128405_("analysisDistance", this.analysisDistance);
        ListTag presetList = new ListTag();
        for (int i = 0; i < this.presets.size(); ++i) {
            List list = (List)this.presets.get(i);
            ListTag preset = new ListTag();
            CompoundTag name = new CompoundTag();
            name.m_128359_("name", this.presetNames.get(i));
            preset.add((Object)name);
            for (Object resourceLocation : list) {
                CompoundTag ability = new CompoundTag();
                ability.m_128359_("ability", resourceLocation.toString());
                preset.add((Object)ability);
            }
            CompoundTag abilityList = new CompoundTag();
            abilityList.m_128365_("preset", (Tag)preset);
            presetList.add((Object)abilityList);
        }
        tag.m_128365_("presetList", (Tag)presetList);
        ListTag warpList = new ListTag();
        for (int i = 0; i < this.warps.size(); ++i) {
            List list = (List)this.warps.get(i);
            ListTag warp = new ListTag();
            CompoundTag name = new CompoundTag();
            name.m_128359_("name", this.warpNames.get(i));
            warp.add((Object)name);
            for (Double coord : list) {
                CompoundTag coordinate = new CompoundTag();
                coordinate.m_128347_("coord", coord.doubleValue());
                warp.add((Object)coordinate);
            }
            CompoundTag coordinateList = new CompoundTag();
            coordinateList.m_128365_("warp", (Tag)warp);
            warpList.add((Object)coordinateList);
        }
        tag.m_128365_("warpList", (Tag)warpList);
        ListTag spiritList = new ListTag();
        for (int i = 0; i < this.spiritLevels.size(); ++i) {
            CompoundTag spirit = new CompoundTag();
            spirit.m_128405_("spirit" + i, this.spiritLevels.get(i).intValue());
            spiritList.add((Object)spirit);
        }
        tag.m_128365_("spiritList", (Tag)spiritList);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag spiritList;
        ListTag warpList;
        this.spiritCooldown = nbt.m_128451_("spiritCooldown");
        this.activePreset = nbt.m_128451_("activePreset");
        this.waterPoint = nbt.m_128459_("waterPoint");
        this.lavaPoint = nbt.m_128459_("lavaPoint");
        this.analysisLevel = nbt.m_128451_("analysisLevel");
        this.analysisMode = nbt.m_128451_("analysisMode");
        this.analysisDistance = nbt.m_128451_("analysisDistance");
        ListTag presetList = (ListTag)nbt.m_128423_("presetList");
        if (presetList != null) {
            this.presetNames.clear();
            for (int i = 0; i < presetList.size(); ++i) {
                NonNullList listRL = NonNullList.m_122780_((int)3, (Object)new ResourceLocation("tensura:none"));
                Tag tag = presetList.get(i);
                ListTag listTag = (ListTag)((CompoundTag)tag).m_128423_("preset");
                assert (listTag != null);
                listRL.set(0, (Object)new ResourceLocation(((CompoundTag)listTag.get(1)).m_128461_("ability")));
                listRL.set(1, (Object)new ResourceLocation(((CompoundTag)listTag.get(2)).m_128461_("ability")));
                listRL.set(2, (Object)new ResourceLocation(((CompoundTag)listTag.get(3)).m_128461_("ability")));
                this.presetNames.add(((CompoundTag)listTag.get(0)).m_128461_("name"));
                this.presets.set(i, (Object)listRL);
            }
        }
        if ((warpList = (ListTag)nbt.m_128423_("warpList")) != null) {
            this.warpNames.clear();
            for (int i = 0; i < warpList.size(); ++i) {
                NonNullList coordinates = NonNullList.m_122780_((int)3, (Object)0.0);
                Tag tag = warpList.get(i);
                ListTag listTag = (ListTag)((CompoundTag)tag).m_128423_("warp");
                assert (listTag != null);
                coordinates.set(0, (Object)((CompoundTag)listTag.get(1)).m_128459_("coord"));
                coordinates.set(1, (Object)((CompoundTag)listTag.get(2)).m_128459_("coord"));
                coordinates.set(2, (Object)((CompoundTag)listTag.get(3)).m_128459_("coord"));
                this.warpNames.add(((CompoundTag)listTag.get(0)).m_128461_("name"));
                this.warps.set(i, (Object)coordinates);
            }
        }
        if ((spiritList = (ListTag)nbt.m_128423_("spiritList")) != null) {
            this.spiritLevels.clear();
            for (int i = 0; i < spiritList.size(); ++i) {
                CompoundTag spirit = (CompoundTag)spiritList.get(i);
                this.spiritLevels.add(spirit.m_128451_("spirit" + i));
            }
        }
    }

    @Nullable
    public static ManasSkill getSkillInSlot(LivingEntity pLivingEntity, int slot) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return null;
        }
        return capability.getSkillInSlot(slot);
    }

    public static boolean isSkillInSlot(LivingEntity pLivingEntity, ManasSkill skill) {
        if (!SkillUtils.hasSkill((Entity)pLivingEntity, skill)) {
            return false;
        }
        if (!(pLivingEntity instanceof Player)) {
            return true;
        }
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isSkillInSlots(skill);
    }

    public static boolean isSkillInSlot(LivingEntity pLivingEntity, ManasSkill skill, int slot) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isSkillInSpecificSlot(skill, slot);
    }

    public static void removeSkillFromSlots(Player player, ManasSkill skill) {
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
            if (cap.removeSkillFromSlots(skill)) {
                TensuraSkillCapability.sync(player);
            }
        });
    }

    @Nullable
    public static String getWarpName(Player player, int warp) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return null;
        }
        return capability.getWarpName(warp);
    }

    public static double getWarpX(Player player, int warp) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getWarpX(warp);
    }

    public static double getWarpY(Player player, int warp) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getWarpY(warp);
    }

    public static double getWarpZ(Player player, int warp) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getWarpZ(warp);
    }

    public static int getSpiritCooldown(Player player) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getSpiritCooldown();
    }

    public static void setSpiritCooldown(Player player, int cooldown) {
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> cap.setSpiritCooldown(cooldown));
        TensuraSkillCapability.sync(player);
    }

    public static int getSpiritLevel(Player player, int spirit) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getSpiritLevel(spirit);
    }

    public static int getAnalysisLevel(Player player) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getAnalysisLevel();
    }

    public static int getAnalysisMode(Player player) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getAnalysisMode();
    }

    public static int getAnalysisDistance(Player player) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getAnalysisDistance();
    }

    public static double getWaterPoint(LivingEntity pLivingEntity) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getWaterPoint();
    }

    public static double getLavaPoint(LivingEntity pLivingEntity) {
        ITensuraSkillCapability capability = CapabilityHandler.getCapability((Entity)pLivingEntity, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getLavaPoint();
    }

    public static void resetEverything(Player player, boolean clearWarp, boolean spirit) {
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
            if (clearWarp) {
                cap.clearAllWarp();
            }
            if (spirit) {
                cap.clearSpiritLevel();
                cap.setSpiritCooldown(0);
            }
            cap.setAnalysisLevel(0);
            cap.setAnalysisDistance(0);
            cap.setLavaPoint(0.0);
            cap.setWaterPoint(0.0);
        });
        TensuraSkillCapability.sync(player);
    }

    @Override
    public int getActivePreset() {
        return this.activePreset;
    }

    @Override
    public int getAnalysisLevel() {
        return this.analysisLevel;
    }

    @Override
    public int getAnalysisMode() {
        return this.analysisMode;
    }

    @Override
    public int getAnalysisDistance() {
        return this.analysisDistance;
    }

    @Override
    public int getSpiritCooldown() {
        return this.spiritCooldown;
    }

    @Override
    public void setActivePreset(int activePreset) {
        this.activePreset = activePreset;
    }

    @Override
    public void setAnalysisLevel(int analysisLevel) {
        this.analysisLevel = analysisLevel;
    }

    @Override
    public void setAnalysisMode(int analysisMode) {
        this.analysisMode = analysisMode;
    }

    @Override
    public void setAnalysisDistance(int analysisDistance) {
        this.analysisDistance = analysisDistance;
    }

    @Override
    public void setSpiritCooldown(int spiritCooldown) {
        this.spiritCooldown = spiritCooldown;
    }

    @Override
    public double getWaterPoint() {
        return this.waterPoint;
    }

    @Override
    public double getLavaPoint() {
        return this.lavaPoint;
    }

    @Override
    public List<String> getPresetNames() {
        return this.presetNames;
    }
}

