/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.capability.race;

import com.github.manasmods.manascore.api.attribute.AttributeModifierHelper;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.ITensuraPlayerCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapabilityProvider;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.handler.CapabilityHandler;
import com.github.manasmods.tensura.menu.RaceSelectionMenu;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.SyncPlayerCapabilityPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.attribute.TensuraAttributeModifierIds;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TensuraPlayerCapability
implements ITensuraPlayerCapability {
    private static final Logger log = LogManager.getLogger(TensuraPlayerCapability.class);
    public static final Capability<ITensuraPlayerCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITensuraPlayerCapability>(){});
    private static final ResourceLocation ID = new ResourceLocation("tensura", "player_cap");
    @Nullable
    private Race race = null;
    @Nullable
    private Race trackedEvolution = null;
    private double baseAura = 0.0;
    private double baseMagicule = 0.0;
    private double aura = 0.0;
    private double magicule = 0.0;
    private int sleepMode = 0;
    private int soulPoints = 0;
    private int resetCounter = 0;
    private boolean blessed = false;
    private boolean spiritualForm;
    private boolean demonLordSeed = false;
    private boolean trueDemonLord = false;
    private boolean heroEgg = false;
    private boolean trueHero = false;
    private double sprintSpeed = 0.13;
    private List<ResourceLocation> intrinsicSkills = new ArrayList<ResourceLocation>();

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Player) {
            e.addCapability(ID, (ICapabilityProvider)new TensuraPlayerCapabilityProvider());
        }
    }

    public static LazyOptional<ITensuraPlayerCapability> getFrom(Player player) {
        return player.getCapability(CAPABILITY);
    }

    public static void sync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TensuraPlayerCapability.getFrom((Player)serverPlayer).ifPresent(data -> TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SyncPlayerCapabilityPacket((ITensuraPlayerCapability)data, serverPlayer.m_19879_())));
        }
    }

    @Override
    public void setBaseAura(double amount, LivingEntity entity) {
        int max = entity.m_9236_().m_46469_().m_46215_(TensuraGameRules.MAX_AP);
        if (amount > (double)max) {
            amount = max;
        } else {
            double min = (double)TensuraGameRules.getMinEp(entity.m_9236_()) / 2.0;
            if (amount < min) {
                amount = min;
            }
        }
        this.baseAura = amount;
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)TensuraAttributeRegistry.MAX_AURA.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_AURA_MODIFIER_ID, "tensura:race_base_aura", amount - entity.m_21172_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()), AttributeModifier.Operation.ADDITION));
        TensuraEPCapability.updateEP(entity);
    }

    @Override
    public void setBaseMagicule(double amount, LivingEntity entity) {
        this.setBaseMagicule(amount, entity, true);
    }

    @Override
    public void setBaseMagicule(double amount, LivingEntity entity, boolean update) {
        int max = entity.m_9236_().m_46469_().m_46215_(TensuraGameRules.MAX_MP);
        if (amount > (double)max) {
            amount = max;
        } else {
            double min = (double)TensuraGameRules.getMinEp(entity.m_9236_()) / 2.0;
            if (amount < min) {
                amount = min;
            }
        }
        this.baseMagicule = amount;
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_MAGICULE_MODIFIER_ID, "tensura:race_base_magicule", amount - entity.m_21172_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()), AttributeModifier.Operation.ADDITION));
        TensuraEPCapability.updateEP(entity, update);
    }

    @Override
    public void setSprintSpeed(double value, Player player) {
        this.sprintSpeed = this.race == null ? 0.13 : Mth.m_14008_((double)value, (double)this.race.getMovementSpeed(), (double)this.race.getSprintSpeed());
        double sprintMultiplier = this.race == null ? (double)1.3f : this.sprintSpeed / this.race.getMovementSpeed();
        AttributeModifierHelper.setModifier((LivingEntity)player, (Attribute)((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_SPRINT_SPEED_MODIFIER_ID, "tensura:race_sprint_speed", sprintMultiplier / (double)1.3f - player.m_21172_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get()), AttributeModifier.Operation.ADDITION));
    }

    @Override
    public void setRace(LivingEntity entity, Race race, boolean resetStat) {
        this.race = race;
        if (resetStat) {
            Random random = new Random();
            this.baseAura = Math.round(race.getMinBaseAura() + (race.getMaxBaseAura() - race.getMinBaseAura()) * random.nextDouble());
            this.baseMagicule = Math.round(race.getMinBaseMagicule() + (race.getMaxBaseMagicule() - race.getMinBaseMagicule()) * random.nextDouble());
            this.aura = this.baseAura;
            this.magicule = this.baseMagicule;
            TensuraEPCapability.getFrom(entity).ifPresent(cap -> {
                cap.setNameable(false);
                cap.setMajin(race.isMajin());
                TensuraEPCapability.sync(entity);
            });
        }
        this.applyBaseAttributeModifiers(entity);
        this.sprintSpeed = race.getSprintSpeed();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TensuraPlayerCapability.sync((Player)player);
            TensuraEPCapability.updateEP(entity);
            this.updateRespawnPos(player, race);
        }
    }

    private void updateRespawnPos(ServerPlayer player, Race race) {
        ResourceKey respawnDimension;
        ResourceKey<Level> dimension = race.getRespawnDimension();
        if (dimension == (respawnDimension = player.m_8963_())) {
            return;
        }
        if (dimension != Level.f_46428_) {
            return;
        }
        player.m_9158_(dimension, null, 0.0f, false, false);
    }

    @Override
    public void setTrackedEvolution(Player player, Race race) {
        this.trackedEvolution = race;
    }

    @Override
    public void addIntrinsicSkill(ManasSkill skill) {
        this.intrinsicSkills.add(SkillUtils.getSkillId(skill));
    }

    @Override
    public void clearIntrinsicSkills() {
        this.intrinsicSkills = new ArrayList<ResourceLocation>();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("race", Optional.ofNullable(this.race).map(race1 -> TensuraRaces.RACE_REGISTRY.get().getKey(race1).toString()).orElse(""));
        if (this.trackedEvolution == null) {
            tag.m_128473_("trackedEvolution");
        } else {
            tag.m_128359_("trackedEvolution", this.trackedEvolution.getRegistryName().toString());
        }
        tag.m_128405_("sleepMode", this.sleepMode);
        tag.m_128405_("soulPoints", this.soulPoints);
        tag.m_128405_("resetCounter", this.resetCounter);
        tag.m_128347_("baseAura", this.baseAura);
        tag.m_128347_("baseMagicule", this.baseMagicule);
        tag.m_128347_("aura", this.aura);
        tag.m_128347_("magicule", this.magicule);
        tag.m_128379_("spiritualForm", this.spiritualForm);
        tag.m_128379_("seed", this.demonLordSeed);
        tag.m_128379_("trueDemonLord", this.trueDemonLord);
        tag.m_128379_("blessed", this.blessed);
        tag.m_128379_("egg", this.heroEgg);
        tag.m_128379_("trueHero", this.trueHero);
        tag.m_128347_("movementSpeed", this.sprintSpeed);
        ListTag intrinsicList = new ListTag();
        for (int i = 0; i < this.intrinsicSkills.size(); ++i) {
            CompoundTag intrinsic = new CompoundTag();
            intrinsic.m_128359_("intrinsic" + i, this.intrinsicSkills.get(i).toString());
            intrinsicList.add((Object)intrinsic);
        }
        tag.m_128365_("intrinsicSkills", (Tag)intrinsicList);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        String raceValue = tag.m_128461_("race");
        if (!raceValue.isEmpty()) {
            ResourceLocation raceRegistryName = new ResourceLocation(raceValue);
            this.race = (Race)TensuraRaces.RACE_REGISTRY.get().getValue(raceRegistryName);
        }
        if (tag.m_128425_("trackedEvolution", 8)) {
            ResourceLocation location = new ResourceLocation(tag.m_128461_("trackedEvolution"));
            this.trackedEvolution = (Race)TensuraRaces.RACE_REGISTRY.get().getValue(location);
        } else {
            this.trackedEvolution = null;
        }
        this.sleepMode = tag.m_128451_("sleepMode");
        this.soulPoints = tag.m_128451_("soulPoints");
        this.resetCounter = tag.m_128451_("resetCounter");
        this.baseAura = tag.m_128459_("baseAura");
        this.baseMagicule = tag.m_128459_("baseMagicule");
        this.aura = tag.m_128459_("aura");
        this.magicule = tag.m_128459_("magicule");
        this.spiritualForm = tag.m_128471_("spiritualForm");
        this.demonLordSeed = tag.m_128471_("seed");
        this.trueDemonLord = tag.m_128471_("trueDemonLord");
        this.blessed = tag.m_128471_("blessed");
        this.heroEgg = tag.m_128471_("egg");
        this.trueHero = tag.m_128471_("trueHero");
        this.sprintSpeed = tag.m_128459_("movementSpeed");
        this.intrinsicSkills.clear();
        ListTag intrinsicList = (ListTag)tag.m_128423_("intrinsicSkills");
        if (intrinsicList != null) {
            for (int i = 0; i < intrinsicList.size(); ++i) {
                CompoundTag spirit = (CompoundTag)intrinsicList.get(i);
                this.intrinsicSkills.add(ResourceLocation.m_135820_((String)spirit.m_128461_("intrinsic" + i)));
            }
        }
    }

    @Override
    public void applyBaseAttributeModifiers(LivingEntity entity) {
        if (this.race == null) {
            return;
        }
        double spiritualHP = (this.race.getBaseHealth() + this.race.getAdditionalSpiritualHealth()) * this.race.getSpiritualHealthMultiplier();
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_SPIRITUAL_HEALTH_MODIFIER_ID, "tensura:race_base_spiritual_health", spiritualHP - entity.m_21172_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()), AttributeModifier.Operation.ADDITION));
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)Attributes.f_22276_, (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_HEALTH_MODIFIER_ID, "tensura:race_base_health", this.race.getBaseHealth() - entity.m_21172_(Attributes.f_22276_), AttributeModifier.Operation.ADDITION));
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)Attributes.f_22281_, (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_ATTACK_DAMAGE_MODIFIER_ID, "tensura:race_attack_damage", this.race.getBaseAttackDamage() - entity.m_21172_(Attributes.f_22281_), AttributeModifier.Operation.ADDITION));
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)Attributes.f_22283_, (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_ATTACK_SPEED_MODIFIER_ID, "tensura:race_attack_speed", this.race.getBaseAttackSpeed() - entity.m_21172_(Attributes.f_22283_), AttributeModifier.Operation.ADDITION));
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)Attributes.f_22278_, (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_KNOCKBACK_RESISTANCE_MODIFIER_ID, "tensura:race_knockback_resistance", this.race.getKnockbackResistance() - entity.m_21172_(Attributes.f_22278_), AttributeModifier.Operation.ADDITION));
        double range = Math.max(RaceHelper.getRaceSize(this.race), 1.0f) * 3.0f;
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)ForgeMod.ATTACK_RANGE.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_ATTACK_REACH_MODIFIER_ID, "tensura:race_attack_reach_speed", range - entity.m_21172_((Attribute)ForgeMod.ATTACK_RANGE.get()), AttributeModifier.Operation.ADDITION));
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)ManasCoreAttributes.JUMP_POWER.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_JUMP_HEIGHT_MODIFIER_ID, "tensura:race_jump_power", this.race.getJumpHeight() - entity.m_21172_((Attribute)ManasCoreAttributes.JUMP_POWER.get()), AttributeModifier.Operation.ADDITION));
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)Attributes.f_22279_, (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_MOVEMENT_SPEED_MODIFIER_ID, "tensura:race_movement_speed", this.race.getMovementSpeed() - entity.m_21172_(Attributes.f_22279_), AttributeModifier.Operation.ADDITION));
        double sprintMultiplier = this.race.getSprintSpeed() / this.race.getMovementSpeed();
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_SPRINT_SPEED_MODIFIER_ID, "tensura:race_sprint_speed", sprintMultiplier / (double)1.3f - entity.m_21172_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get()), AttributeModifier.Operation.ADDITION));
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)TensuraAttributeRegistry.MAX_AURA.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_AURA_MODIFIER_ID, "tensura:race_base_aura", this.baseAura - entity.m_21172_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()), AttributeModifier.Operation.ADDITION));
        AttributeModifierHelper.setModifier((LivingEntity)entity, (Attribute)((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_MAGICULE_MODIFIER_ID, "tensura:race_base_magicule", this.baseMagicule - entity.m_21172_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()), AttributeModifier.Operation.ADDITION));
    }

    public static void checkForFirstLogin(Player entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            if (cap.getRace() != null) {
                return;
            }
            if (player.m_9236_().m_46469_().m_46207_(TensuraGameRules.RIMURU_MODE)) {
                RaceSelectionMenu.reincarnateAsRimuru((Player)player);
            } else {
                if (player.m_9236_().m_46469_().m_46207_(TensuraGameRules.SKILL_BEFORE_RACE)) {
                    cap.setRace((LivingEntity)player, (Race)TensuraRaces.HUMAN.get(), true);
                    RaceSelectionMenu.grantUniqueSkill((Player)player);
                }
                player.m_20331_(true);
                List<ResourceLocation> races = TensuraPlayerCapability.loadRaces();
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider(RaceSelectionMenu::new, (Component)Component.m_237115_((String)"tensura.race.selection")), buf -> {
                    buf.writeBoolean(false);
                    buf.m_236828_((Collection)races, FriendlyByteBuf::m_130085_);
                });
            }
            RaceSelectionMenu.grantLearningResistance((LivingEntity)player);
        });
    }

    public static List<ResourceLocation> loadRaces() {
        ArrayList<ResourceLocation> races = new ArrayList<ResourceLocation>(((List)TensuraConfig.INSTANCE.racesConfig.startingRaces.get()).stream().map(ResourceLocation::new).toList());
        List randomRaces = (List)TensuraConfig.INSTANCE.racesConfig.randomRaces.get();
        if (randomRaces.isEmpty()) {
            return races;
        }
        Random random = new Random();
        String race = (String)randomRaces.get(random.nextInt(randomRaces.size()));
        if (!race.isEmpty() && !race.isBlank()) {
            races.add(new ResourceLocation(race));
        }
        return races;
    }

    public static void resetMagiculeAura(Player player) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (cap.getRace() == null) {
                return;
            }
            float penalty = (float)player.f_19853_.m_46469_().m_46215_(TensuraGameRules.EP_DEATH_PENALTY) / 200.0f;
            cap.setBaseAura(cap.getBaseAura() * (double)(1.0f - penalty), (LivingEntity)player);
            cap.setBaseMagicule(cap.getBaseMagicule() * (double)(1.0f - penalty), (LivingEntity)player);
            if (cap.getSoulPoints() > 0) {
                cap.setSoulPoints((int)((float)cap.getSoulPoints() * (1.0f - penalty)));
            }
            AttributeModifierHelper.setModifier((LivingEntity)player, (Attribute)((Attribute)TensuraAttributeRegistry.MAX_AURA.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_AURA_MODIFIER_ID, "tensura:race_base_aura", cap.getBaseAura() - player.m_21172_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()), AttributeModifier.Operation.ADDITION));
            cap.setAura(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()));
            AttributeModifierHelper.setModifier((LivingEntity)player, (Attribute)((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_BASE_MAGICULE_MODIFIER_ID, "tensura:race_base_magicule", cap.getBaseMagicule() - player.m_21172_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()), AttributeModifier.Operation.ADDITION));
            cap.setMagicule(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()));
            TensuraPlayerCapability.sync(player);
        });
    }

    @Nullable
    public static Race getRace(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return null;
        }
        return capability.getRace();
    }

    @Nullable
    public static Race getTrackedEvolution(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return null;
        }
        return capability.getTrackedEvolution();
    }

    public static double getBaseEP(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getBaseMagicule() + capability.getBaseAura();
    }

    public static double getCurrentEP(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getMagicule() + capability.getAura();
    }

    public static double getMagicule(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getMagicule();
    }

    public static double getBaseMagicule(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getBaseMagicule();
    }

    public static double getAura(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getAura();
    }

    public static double getBaseAura(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.0;
        }
        return capability.getBaseAura();
    }

    public static double getSprintSpeed(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0.13;
        }
        return capability.getSprintSpeed();
    }

    public static int getResetCounter(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getResetCounter();
    }

    public static int getSoulPoints(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return 0;
        }
        return capability.getSoulPoints();
    }

    public static boolean isDemonLordSeed(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isDemonLordSeed();
    }

    public static boolean isTrueDemonLord(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isTrueDemonLord();
    }

    public static boolean isBlessed(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isBlessed();
    }

    public static boolean isHeroEgg(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isHeroEgg();
    }

    public static boolean isTrueHero(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isTrueHero();
    }

    public static boolean isSpiritualForm(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.isSpiritualForm();
    }

    public static List<ResourceLocation> getIntrinsicList(Player player) {
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return new ArrayList<ResourceLocation>();
        }
        return capability.getIntrinsicSkills();
    }

    public static void setTrackedRace(LivingEntity entity, @Nullable Race race) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ITensuraPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return;
        }
        capability.setTrackedEvolution(player, race);
    }

    public static void setMagicule(Player player, double value) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            cap.setMagicule(value);
            TensuraPlayerCapability.sync(player);
        });
    }

    public static void setAura(Player player, double value) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            cap.setAura(value);
            TensuraPlayerCapability.sync(player);
        });
    }

    public static void setSprintSpeed(Player player, double value) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (cap.getRace() == null) {
                return;
            }
            cap.setSprintSpeed(value, player);
            TensuraPlayerCapability.sync(player);
        });
    }

    public static void decreaseMagicule(Player player, double value) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> cap.setMagicule(cap.getMagicule() - value));
        TensuraPlayerCapability.sync(player);
    }

    public static void decreaseAura(Player player, double value) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> cap.setAura(cap.getAura() - value));
        TensuraPlayerCapability.sync(player);
    }

    public static void increaseResetCounter(Player player, int i) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            cap.setResetCounter(Math.max(cap.getResetCounter() + i, 0));
            TensuraPlayerCapability.sync(player);
        });
    }

    public static void resetEverything(Player player) {
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            cap.setSoulPoints(0);
            cap.setDemonLordSeed(false);
            cap.setTrueDemonLord(false);
            cap.setBlessed(false);
            cap.setHeroEgg(false);
            cap.setTrueHero(false);
            cap.setSpiritualForm(false);
            cap.setSleepMode(0);
        });
        TensuraPlayerCapability.sync(player);
    }

    @Override
    @Nullable
    public Race getRace() {
        return this.race;
    }

    @Override
    @Nullable
    public Race getTrackedEvolution() {
        return this.trackedEvolution;
    }

    @Override
    public double getBaseAura() {
        return this.baseAura;
    }

    @Override
    public double getBaseMagicule() {
        return this.baseMagicule;
    }

    @Override
    public double getAura() {
        return this.aura;
    }

    @Override
    public double getMagicule() {
        return this.magicule;
    }

    @Override
    public void setAura(double aura) {
        this.aura = aura;
    }

    @Override
    public void setMagicule(double magicule) {
        this.magicule = magicule;
    }

    @Override
    public int getSleepMode() {
        return this.sleepMode;
    }

    @Override
    public int getSoulPoints() {
        return this.soulPoints;
    }

    @Override
    public int getResetCounter() {
        return this.resetCounter;
    }

    @Override
    public void setSleepMode(int sleepMode) {
        this.sleepMode = sleepMode;
    }

    @Override
    public void setSoulPoints(int soulPoints) {
        this.soulPoints = soulPoints;
    }

    @Override
    public void setResetCounter(int resetCounter) {
        this.resetCounter = resetCounter;
    }

    @Override
    public boolean isBlessed() {
        return this.blessed;
    }

    @Override
    public boolean isSpiritualForm() {
        return this.spiritualForm;
    }

    @Override
    public void setBlessed(boolean blessed) {
        this.blessed = blessed;
    }

    @Override
    public void setSpiritualForm(boolean spiritualForm) {
        this.spiritualForm = spiritualForm;
    }

    @Override
    public boolean isDemonLordSeed() {
        return this.demonLordSeed;
    }

    @Override
    public boolean isTrueDemonLord() {
        return this.trueDemonLord;
    }

    @Override
    public void setDemonLordSeed(boolean demonLordSeed) {
        this.demonLordSeed = demonLordSeed;
    }

    @Override
    public void setTrueDemonLord(boolean trueDemonLord) {
        this.trueDemonLord = trueDemonLord;
    }

    @Override
    public boolean isHeroEgg() {
        return this.heroEgg;
    }

    @Override
    public boolean isTrueHero() {
        return this.trueHero;
    }

    @Override
    public void setHeroEgg(boolean heroEgg) {
        this.heroEgg = heroEgg;
    }

    @Override
    public void setTrueHero(boolean trueHero) {
        this.trueHero = trueHero;
    }

    @Override
    public double getSprintSpeed() {
        return this.sprintSpeed;
    }

    public void setSprintSpeed(double sprintSpeed) {
        this.sprintSpeed = sprintSpeed;
    }

    @Override
    public List<ResourceLocation> getIntrinsicSkills() {
        return this.intrinsicSkills;
    }
}

