/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block.entity;

import com.github.manasmods.tensura.block.KilnBlock;
import com.github.manasmods.tensura.block.state.properties.KilnPart;
import com.github.manasmods.tensura.data.recipe.KilnMeltingRecipe;
import com.github.manasmods.tensura.data.recipe.KilnMixingRecipe;
import com.github.manasmods.tensura.menu.KilnMenu;
import com.github.manasmods.tensura.registry.blocks.TensuraBlockEntities;
import com.github.manasmods.tensura.registry.recipe.TensuraRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KilnBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    public static final int INPUT_FUEL_SLOT_INDEX = 0;
    public static final int INPUT_SLOT_INDEX = 1;
    public static final int OUTPUT_MIXING_SLOT_INDEX = 2;
    public static final int MAX_MOLTEN_PROGRESS = 144;
    private Optional<ResourceLocation> leftBarId = Optional.of(KilnMixingRecipe.EMPTY);
    private Optional<ResourceLocation> rightBarId = Optional.of(KilnMixingRecipe.EMPTY);
    private int moltenAmount = 0;
    private int magicMaterialAmount = 0;
    private int meltingProgress = 0;
    private int fuelTime = 0;
    private int maxFuelTime = 0;
    private int lastMagicAmount;
    private int lastMoltenAmount;
    private ItemStack lastMixingStack = ItemStack.f_41583_;
    private ItemStack lastInputStack = ItemStack.f_41583_;
    private ItemStack lastFuelStack = ItemStack.f_41583_;
    public boolean needUpdate = false;
    private List<KilnMixingRecipe> possibleMixingRecipes = new ArrayList<KilnMixingRecipe>();
    private int selectedRecipeIndex = 0;
    private int lastSelectedRecipeIndex = -1;
    private KilnMeltingRecipe lastMeltingRecipe = null;
    private int totalPossibleRecipes = 0;
    private boolean canHopperMixing = false;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH});

    public KilnBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TensuraBlockEntities.KILN.get(), pos, state);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"tensura.kiln.label");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new KilnMenu(id, inventory, this);
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return this.m_7208_(pContainerId, pInventory, pInventory.f_35978_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing.equals((Object)Direction.DOWN)) {
                return this.handlers[0].cast();
            }
            Direction backSide = ((Direction)this.m_58900_().m_61143_((Property)KilnBlock.FACING)).m_122424_();
            if (backSide.equals((Object)facing)) {
                return this.handlers[2].cast();
            }
            return this.handlers[1].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        this.leftBarId.ifPresent(location -> nbt.m_128359_("kiln.molten.itemId", location.toString()));
        this.rightBarId.ifPresent(location -> nbt.m_128359_("kiln.magic.itemId", location.toString()));
        nbt.m_128405_("kiln.molten", this.moltenAmount);
        nbt.m_128405_("kiln.magic", this.magicMaterialAmount);
        nbt.m_128405_("kiln.workProgess", this.meltingProgress);
        nbt.m_128405_("kiln.fuel", this.fuelTime);
        nbt.m_128405_("kiln.maxFuel", this.maxFuelTime);
        nbt.m_128405_("kiln.possibleRecipes", this.possibleMixingRecipes.size());
        nbt.m_128405_("kiln.currentRecipe", this.selectedRecipeIndex);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.leftBarId = nbt.m_128441_("kiln.molten.itemId") ? Optional.ofNullable(ResourceLocation.m_135820_((String)nbt.m_128461_("kiln.molten.itemId"))) : Optional.of(KilnMixingRecipe.EMPTY);
        this.rightBarId = nbt.m_128441_("kiln.magic.itemId") ? Optional.ofNullable(ResourceLocation.m_135820_((String)nbt.m_128461_("kiln.magic.itemId"))) : Optional.of(KilnMixingRecipe.EMPTY);
        this.moltenAmount = nbt.m_128451_("kiln.molten");
        this.magicMaterialAmount = nbt.m_128451_("kiln.magic");
        this.meltingProgress = nbt.m_128451_("kiln.workProgess");
        this.fuelTime = nbt.m_128451_("kiln.fuel");
        this.maxFuelTime = nbt.m_128451_("kiln.maxFuel");
        this.totalPossibleRecipes = nbt.m_128451_("kiln.possibleRecipes");
        this.selectedRecipeIndex = nbt.m_128451_("kiln.currentRecipe");
    }

    public int[] m_7071_(Direction pSide) {
        if (((KilnPart)((Object)this.m_58900_().m_61143_(KilnBlock.PART))).equals((Object)KilnPart.TOP)) {
            return new int[0];
        }
        Direction backSide = ((Direction)this.m_58900_().m_61143_((Property)KilnBlock.FACING)).m_122424_();
        if (pSide.equals((Object)backSide)) {
            return new int[]{0};
        }
        if (pSide.equals((Object)Direction.DOWN)) {
            return new int[]{2};
        }
        return new int[]{1};
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return switch (pIndex) {
            default -> false;
            case 1 -> true;
            case 0 -> AbstractFurnaceBlockEntity.m_58399_((ItemStack)pItemStack);
        };
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        if (pDirection == Direction.DOWN && pIndex == 0) {
            return pStack.m_150930_(Items.f_42447_) || pStack.m_150930_(Items.f_42446_);
        }
        if (pIndex == 2 && this.canHopperMixing) {
            this.performMixing();
            this.canHopperMixing = false;
        }
        return pIndex != 1;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.items.get(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        this.needUpdate = true;
        return ContainerHelper.m_18969_(this.items, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.items, (int)pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.items.set(pIndex, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        this.needUpdate = true;
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return switch (pIndex) {
            default -> false;
            case 1 -> true;
            case 0 -> AbstractFurnaceBlockEntity.m_58399_((ItemStack)pStack);
        };
    }

    public void m_6211_() {
        this.items.clear();
        this.needUpdate = true;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.items.size());
        for (int i = 0; i < this.items.size(); ++i) {
            if (i == 2) continue;
            inventory.m_6836_(i, (ItemStack)this.items.get(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, KilnBlockEntity pEntity) {
        RandomSource random;
        if (!level.m_5776_()) {
            boolean mixingNeedsUpdate = pEntity.checkMixingCache();
            boolean meltingNeedsUpdate = pEntity.checkMeltingCache();
            if (mixingNeedsUpdate) {
                pEntity.updatePossibleMixingRecipes();
                pEntity.checkSelectedRecipeIndex();
                pEntity.canHopperMixing = true;
                if (pEntity.lastSelectedRecipeIndex != pEntity.selectedRecipeIndex && pEntity.possibleMixingRecipes.size() > pEntity.selectedRecipeIndex) {
                    pEntity.items.set(2, (Object)pEntity.possibleMixingRecipes.get(pEntity.selectedRecipeIndex).getOutput().m_41777_());
                    pEntity.lastSelectedRecipeIndex = pEntity.selectedRecipeIndex;
                    pEntity.needUpdate = true;
                }
            }
            if (mixingNeedsUpdate || meltingNeedsUpdate || pEntity.meltingProgress > 0) {
                pEntity.checkMeltingRecipe();
            }
            pEntity.updateFuelTime();
            if (pEntity.needUpdate) {
                pEntity.m_6596_();
                level.m_7260_(pos, state, state, 2);
                pEntity.needUpdate = false;
            }
        } else if (((Boolean)state.m_61143_((Property)KilnBlock.LIT)).booleanValue() && (random = level.f_46441_).m_188501_() < 0.11f) {
            for (int i = 0; i < random.m_188503_(2) + 2; ++i) {
                CampfireBlock.m_51251_((Level)level, (BlockPos)pos.m_6630_(2), (boolean)false, (boolean)false);
            }
        }
    }

    private void updateFuelTime() {
        if (this.fuelTime > 0) {
            --this.fuelTime;
            this.needUpdate = true;
            if (!((Boolean)this.m_58900_().m_61143_((Property)KilnBlock.LIT)).booleanValue()) {
                BlockState newState = (BlockState)this.m_58900_().m_61124_((Property)KilnBlock.LIT, (Comparable)Boolean.valueOf(true));
                this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
                KilnBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)newState);
            }
            return;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)KilnBlock.LIT)).booleanValue()) {
            BlockState newState = (BlockState)this.m_58900_().m_61124_((Property)KilnBlock.LIT, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
            KilnBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)newState);
        }
    }

    private boolean checkMixingCache() {
        if (this.lastSelectedRecipeIndex != this.selectedRecipeIndex && this.possibleMixingRecipes.size() > 0) {
            this.items.set(2, (Object)this.possibleMixingRecipes.get(this.selectedRecipeIndex).m_8043_().m_41777_());
            this.needUpdate = true;
            this.lastSelectedRecipeIndex = this.selectedRecipeIndex;
        }
        if (this.lastMagicAmount != this.magicMaterialAmount) {
            this.lastMagicAmount = this.magicMaterialAmount;
            return true;
        }
        if (this.lastMoltenAmount != this.moltenAmount) {
            this.lastMoltenAmount = this.moltenAmount;
            return true;
        }
        if (!this.lastMixingStack.equals((ItemStack)this.items.get(2), false)) {
            this.lastMixingStack = ((ItemStack)this.items.get(2)).m_41777_();
            return true;
        }
        return false;
    }

    private boolean checkMeltingCache() {
        if (!this.lastInputStack.equals((ItemStack)this.items.get(1), true)) {
            this.lastInputStack = ((ItemStack)this.items.get(1)).m_41777_();
            return true;
        }
        if (!this.lastFuelStack.equals((ItemStack)this.items.get(0), true)) {
            this.lastFuelStack = ((ItemStack)this.items.get(0)).m_41777_();
            return true;
        }
        return false;
    }

    private void checkSelectedRecipeIndex() {
        if (this.totalPossibleRecipes == 0) {
            this.selectedRecipeIndex = 0;
            this.needUpdate = true;
            return;
        }
        if (this.selectedRecipeIndex >= this.totalPossibleRecipes) {
            --this.selectedRecipeIndex;
            this.needUpdate = true;
            return;
        }
        if (this.selectedRecipeIndex < 0) {
            this.selectedRecipeIndex = 0;
            this.needUpdate = true;
            return;
        }
    }

    private void checkMeltingRecipe() {
        if (((ItemStack)this.items.get(1)).m_41619_()) {
            if (this.meltingProgress > 0) {
                this.resetMeltingProgress();
            }
            return;
        }
        this.f_58857_.m_7465_().m_44015_((RecipeType)TensuraRecipeTypes.KILN_MELTING.get(), (Container)this, this.f_58857_).ifPresentOrElse(kilnMeltingRecipe -> {
            if (this.checkFuel()) {
                if (this.lastMeltingRecipe != null && !this.lastMeltingRecipe.m_6423_().equals((Object)kilnMeltingRecipe.m_6423_())) {
                    this.lastMeltingRecipe = kilnMeltingRecipe;
                    this.resetMeltingProgress();
                }
                if (this.meltingProgress >= 100) {
                    kilnMeltingRecipe.assemble(this);
                    this.resetMeltingProgress();
                } else {
                    ++this.meltingProgress;
                }
            } else {
                this.resetMeltingProgress();
            }
            this.needUpdate = true;
        }, this::resetMeltingProgress);
    }

    private void updatePossibleMixingRecipes() {
        Optional<KilnMixingRecipe> selectedRecipe = this.possibleMixingRecipes.size() > this.selectedRecipeIndex && this.selectedRecipeIndex >= 0 ? Optional.of(this.possibleMixingRecipes.get(this.selectedRecipeIndex)) : Optional.empty();
        this.possibleMixingRecipes = this.f_58857_.m_7465_().m_44056_((RecipeType)TensuraRecipeTypes.KILN_MIXING.get(), (Container)this, this.f_58857_).parallelStream().sorted().toList();
        this.totalPossibleRecipes = this.possibleMixingRecipes.size();
        selectedRecipe.ifPresentOrElse(kilnMixingRecipe -> {
            this.selectedRecipeIndex = this.possibleMixingRecipes.contains(kilnMixingRecipe) ? this.possibleMixingRecipes.indexOf(kilnMixingRecipe) : 0;
        }, () -> {
            this.selectedRecipeIndex = 0;
        });
        if (this.possibleMixingRecipes.size() > 0) {
            this.items.set(2, (Object)this.possibleMixingRecipes.get(this.selectedRecipeIndex).m_8043_());
        }
        this.needUpdate = true;
    }

    public void mixingNextRecipe() {
        this.selectedRecipeIndex = this.selectedRecipeIndex + 1 >= this.possibleMixingRecipes.size() ? 0 : ++this.selectedRecipeIndex;
        this.needUpdate = true;
    }

    public void mixingPrevRecipe() {
        this.selectedRecipeIndex = this.selectedRecipeIndex - 1 < 0 ? this.possibleMixingRecipes.size() - 1 : --this.selectedRecipeIndex;
        this.needUpdate = true;
    }

    private void resetMeltingProgress() {
        if (this.meltingProgress > 0) {
            this.meltingProgress = 0;
            this.lastInputStack = ItemStack.f_41583_;
            this.needUpdate = true;
        }
    }

    private boolean checkFuel() {
        if (this.fuelTime > 0) {
            return true;
        }
        ItemStack fuelSlotStack = ((ItemStack)this.items.get(0)).m_41777_();
        if (fuelSlotStack.m_41619_()) {
            return false;
        }
        int fuelTime = ForgeHooks.getBurnTime((ItemStack)fuelSlotStack, (RecipeType)RecipeType.f_44108_);
        if (fuelTime < 0) {
            return false;
        }
        if (fuelSlotStack.m_41720_() instanceof BucketItem) {
            fuelSlotStack = Items.f_42446_.m_7968_();
        } else {
            fuelSlotStack.m_41774_(1);
        }
        this.items.set(0, (Object)fuelSlotStack);
        this.fuelTime = fuelTime;
        this.maxFuelTime = fuelTime;
        this.needUpdate = true;
        return true;
    }

    public void m_5809_(StackedContents pHelper) {
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void addMagicMaterialAmount(int moltenAmount) {
        this.magicMaterialAmount += moltenAmount;
        this.needUpdate = true;
    }

    public void addMoltenMaterialAmount(int moltenAmount) {
        this.moltenAmount += moltenAmount;
        this.needUpdate = true;
    }

    public boolean hasPrevMixingRecipe() {
        return this.totalPossibleRecipes > this.selectedRecipeIndex - 1 && this.selectedRecipeIndex - 1 >= 0;
    }

    public boolean hasNextMixingRecipe() {
        return this.totalPossibleRecipes > this.selectedRecipeIndex + 1 && this.selectedRecipeIndex + 1 >= 0;
    }

    public void performMixing() {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        if (this.possibleMixingRecipes.isEmpty()) {
            return;
        }
        KilnMixingRecipe recipe = this.possibleMixingRecipes.get(this.selectedRecipeIndex);
        this.moltenAmount -= recipe.getLeftInputAmount();
        if (this.moltenAmount <= 0) {
            this.leftBarId = Optional.of(KilnMixingRecipe.EMPTY);
        }
        this.magicMaterialAmount -= recipe.getRightInputAmount();
        if (this.magicMaterialAmount <= 0) {
            this.rightBarId = Optional.of(KilnMixingRecipe.EMPTY);
        }
        if (recipe.matches(this, this.f_58857_)) {
            this.items.set(2, (Object)recipe.assemble(this));
        } else {
            this.updatePossibleMixingRecipes();
        }
        this.needUpdate = true;
    }

    public Optional<ResourceLocation> getLeftBarId() {
        return this.leftBarId;
    }

    public void setLeftBarId(Optional<ResourceLocation> leftBarId) {
        this.leftBarId = leftBarId;
    }

    public Optional<ResourceLocation> getRightBarId() {
        return this.rightBarId;
    }

    public void setRightBarId(Optional<ResourceLocation> rightBarId) {
        this.rightBarId = rightBarId;
    }

    public int getMoltenAmount() {
        return this.moltenAmount;
    }

    public void setMoltenAmount(int moltenAmount) {
        this.moltenAmount = moltenAmount;
    }

    public int getMagicMaterialAmount() {
        return this.magicMaterialAmount;
    }

    public void setMagicMaterialAmount(int magicMaterialAmount) {
        this.magicMaterialAmount = magicMaterialAmount;
    }

    public int getMeltingProgress() {
        return this.meltingProgress;
    }

    public void setMeltingProgress(int meltingProgress) {
        this.meltingProgress = meltingProgress;
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public void setFuelTime(int fuelTime) {
        this.fuelTime = fuelTime;
    }

    public int getMaxFuelTime() {
        return this.maxFuelTime;
    }

    public void setMaxFuelTime(int maxFuelTime) {
        this.maxFuelTime = maxFuelTime;
    }

    public List<KilnMixingRecipe> getPossibleMixingRecipes() {
        return this.possibleMixingRecipes;
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex;
    }
}

