/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.entity.HellCaterpillarEntity;
import com.github.manasmods.tensura.entity.HellMothEntity;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class MothEggBlock
extends Block {
    private static final VoxelShape ONE_EGG_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS = BlockStateProperties.f_61415_;

    public MothEggBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (!(pEntity.m_20161_() || pEntity instanceof HellMothEntity || pEntity instanceof HellCaterpillarEntity)) {
            this.destroyEgg(pLevel, pState, pPos, pEntity);
        }
        super.m_141947_(pLevel, pPos, pState, pEntity);
    }

    private void destroyEgg(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity) {
        if (!this.canDestroyEgg(pLevel, pEntity)) {
            return;
        }
        if (!pLevel.f_46443_ && pLevel.f_46441_.m_188503_(100) == 0 && pState.m_60713_((Block)TensuraBlocks.MOTH_EGG.get())) {
            return;
        }
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (player.m_150110_().f_35937_) {
                return;
            }
            BlockEvent.BreakEvent preGrief = new BlockEvent.BreakEvent(pLevel, pPos, pState, player);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
        } else if (ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pEntity)) {
            return;
        }
        this.decreaseEggs(pLevel, pPos, pState);
        Block.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)((Item)TensuraMobDropItems.HELL_MOTH_SILK.get()).m_7968_());
    }

    private void decreaseEggs(Level pLevel, BlockPos pPos, BlockState pState) {
        pLevel.m_5594_(null, pPos, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)pState.m_61143_((Property)EGGS);
        if (i <= 1) {
            pLevel.m_46961_(pPos, false);
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            pLevel.m_220407_(GameEvent.f_157794_, pPos, GameEvent.Context.m_223722_((BlockState)pState));
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.shouldUpdateHatchLevel((Level)pLevel) && MothEggBlock.onEggCanPlace((BlockGetter)pLevel, pPos)) {
            int i = (Integer)pState.m_61143_((Property)HATCH);
            if (i < 2) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
                pLevel.m_7471_(pPos, false);
                for (int j = 0; j < (Integer)pState.m_61143_((Property)EGGS); ++j) {
                    pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
                    HellCaterpillarEntity caterpillar = (HellCaterpillarEntity)((EntityType)TensuraEntityTypes.HELL_CATERPILLAR.get()).m_20615_((Level)pLevel);
                    if (caterpillar == null) break;
                    caterpillar.m_146762_(-24000);
                    caterpillar.m_7678_((double)pPos.m_123341_() + 0.3 + (double)j * 0.2, pPos.m_123342_(), (double)pPos.m_123343_() + 0.3, 0.0f, 0.0f);
                    caterpillar.m_6518_((ServerLevelAccessor)pLevel, pLevel.m_6436_(caterpillar.m_20183_()), MobSpawnType.BREEDING, null, null);
                    pLevel.m_7967_((Entity)caterpillar);
                }
            }
        }
    }

    public static boolean onEggCanPlace(BlockGetter pLevel, BlockPos pPos) {
        return MothEggBlock.canPlaceEgg(pLevel, pPos.m_7495_());
    }

    public static boolean canPlaceEgg(BlockGetter pReader, BlockPos pPos) {
        return pReader.m_8055_(pPos).m_204336_(BlockTags.f_13035_) || pReader.m_8055_(pPos).m_204336_(BlockTags.f_13089_);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (MothEggBlock.onEggCanPlace((BlockGetter)pLevel, pPos) && !pLevel.f_46443_) {
            pLevel.m_46796_(2005, pPos, 0);
        }
    }

    private boolean shouldUpdateHatchLevel(Level pLevel) {
        float f = pLevel.m_46942_(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return pLevel.f_46441_.m_188503_(300) == 0;
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pTe, pStack);
        this.decreaseEggs(pLevel, pPos, pState);
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return !pUseContext.m_7078_() && pUseContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)pState.m_61143_((Property)EGGS) < 4 || super.m_6864_(pState, pUseContext);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        if (!fluidstate.m_76178_()) {
            return null;
        }
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)EGGS) + 1))) : super.m_5573_(pContext);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Integer)pState.m_61143_((Property)EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HATCH, EGGS});
    }

    private boolean canDestroyEgg(Level pLevel, Entity pEntity) {
        if (pEntity instanceof HellMothEntity) {
            return false;
        }
        if (pEntity instanceof HellCaterpillarEntity) {
            return false;
        }
        if (pEntity instanceof Bat) {
            return false;
        }
        if (!(pEntity instanceof LivingEntity)) {
            return false;
        }
        return pEntity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)pLevel, (Entity)pEntity);
    }
}

