/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.block.entity.PrayingPathBlockEntity;
import com.github.manasmods.tensura.registry.blocks.TensuraBlockEntities;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class LabyrinthPrayingPathBlock
extends BaseEntityBlock {
    public LabyrinthPrayingPathBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_222994_().m_60918_(SoundType.f_154654_).m_60955_().m_60953_(state -> 15).m_60913_(-1.0f, 3600000.0f));
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.m_60713_((Block)this) || stateFrom.m_60713_((Block)TensuraBlocks.LABYRINTH_LIGHT_PATH.get())) {
            return true;
        }
        if (stateFrom.m_60734_() == TensuraBlocks.LABYRINTH_LIGHT_PATH_SLAB.get() && this.isInvisibleToGlassSlab(state, stateFrom, direction)) {
            return true;
        }
        if (stateFrom.m_60734_() == TensuraBlocks.LABYRINTH_LIGHT_PATH_STAIRS.get() && this.isInvisibleToGlassStairs(state, stateFrom, direction)) {
            return true;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType typeFrom = (SlabType)stateFrom.m_61143_((Property)SlabBlock.f_56353_);
        if (typeFrom == SlabType.DOUBLE) {
            return true;
        }
        if (direction == Direction.UP && typeFrom != SlabType.TOP) {
            return true;
        }
        return direction == Direction.DOWN && typeFrom != SlabType.BOTTOM;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        Half halfFrom = (Half)stateFrom.m_61143_((Property)StairBlock.f_56842_);
        Direction facingFrom = (Direction)stateFrom.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shapeFrom = (StairsShape)stateFrom.m_61143_((Property)StairBlock.f_56843_);
        if (direction == Direction.UP && halfFrom == Half.BOTTOM) {
            return true;
        }
        if (direction == Direction.DOWN && halfFrom == Half.TOP) {
            return true;
        }
        if (facingFrom == direction.m_122424_() && shapeFrom != StairsShape.OUTER_LEFT && shapeFrom != StairsShape.OUTER_RIGHT) {
            return true;
        }
        if (facingFrom.m_122428_() == direction && shapeFrom == StairsShape.INNER_RIGHT) {
            return true;
        }
        return facingFrom.m_122427_() == direction && shapeFrom == StairsShape.INNER_LEFT;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PrayingPathBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> type) {
        return LabyrinthPrayingPathBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TensuraBlockEntities.PRAYING_PATH.get()), PrayingPathBlockEntity::tick);
    }
}

