/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class LabyrinthLightPathStairBlock
extends StairBlock {
    public LabyrinthLightPathStairBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(state, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.m_150110_().f_35937_) return false;
        return true;
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.m_60734_() == TensuraBlocks.LABYRINTH_LIGHT_PATH.get()) {
            return true;
        }
        if (stateFrom.m_60734_() == TensuraBlocks.LABYRINTH_PRAYING_PATH.get()) {
            return true;
        }
        if (stateFrom.m_60734_() == this && this.isInvisibleToGlassStairs(state, stateFrom, direction)) {
            return true;
        }
        if (stateFrom.m_60734_() == TensuraBlocks.LABYRINTH_LIGHT_PATH_SLAB.get() && this.isInvisibleToGlassSlab(state, stateFrom, direction)) {
            return true;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        SlabType typeFrom = (SlabType)stateFrom.m_61143_((Property)SlabBlock.f_56353_);
        if (direction == Direction.UP && typeFrom != SlabType.TOP) {
            return true;
        }
        if (direction == Direction.DOWN && typeFrom != SlabType.BOTTOM) {
            return true;
        }
        if (typeFrom == SlabType.DOUBLE) {
            return true;
        }
        if (direction == facing.m_122424_()) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            if (typeFrom == SlabType.TOP && half == Half.TOP) {
                return true;
            }
        }
        if (direction == facing.m_122427_() && shape == StairsShape.OUTER_LEFT) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            if (typeFrom == SlabType.TOP && half == Half.TOP) {
                return true;
            }
        }
        if (direction == facing.m_122428_() && shape == StairsShape.OUTER_RIGHT) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            return typeFrom == SlabType.TOP && half == Half.TOP;
        }
        return false;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        Half halfFrom = (Half)stateFrom.m_61143_((Property)StairBlock.f_56842_);
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        Direction facingFrom = (Direction)stateFrom.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        StairsShape shapeFrom = (StairsShape)stateFrom.m_61143_((Property)StairBlock.f_56843_);
        if (direction == Direction.UP) {
            if (halfFrom == Half.BOTTOM) {
                return true;
            }
            if (half != halfFrom) {
                if (facing == facingFrom && shape == shapeFrom) {
                    return true;
                }
                switch (shape) {
                    case STRAIGHT: {
                        if (shapeFrom == StairsShape.INNER_LEFT && (facingFrom == facing || facingFrom == facing.m_122427_())) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing && facingFrom != facing.m_122428_()) break;
                        return true;
                    }
                    case INNER_LEFT: {
                        if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing.m_122428_()) break;
                        return true;
                    }
                    case INNER_RIGHT: {
                        if (shapeFrom != StairsShape.INNER_LEFT || facingFrom != facing.m_122427_()) break;
                        return true;
                    }
                    case OUTER_LEFT: {
                        if (shapeFrom == StairsShape.OUTER_RIGHT && facingFrom == facing.m_122428_()) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.m_122428_()) break;
                        return true;
                    }
                    case OUTER_RIGHT: {
                        if (shapeFrom == StairsShape.OUTER_LEFT && facingFrom == facing.m_122427_()) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.m_122427_()) break;
                        return true;
                    }
                }
            }
        }
        if (direction == Direction.DOWN) {
            if (halfFrom == Half.TOP) {
                return true;
            }
            switch (shape) {
                case STRAIGHT: {
                    if (shapeFrom == StairsShape.INNER_LEFT && (facingFrom == facing || facingFrom == facing.m_122427_())) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing && facingFrom != facing.m_122428_()) break;
                    return true;
                }
                case INNER_LEFT: {
                    if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing.m_122428_()) break;
                    return true;
                }
                case INNER_RIGHT: {
                    if (shapeFrom != StairsShape.INNER_LEFT || facingFrom != facing.m_122427_()) break;
                    return true;
                }
                case OUTER_LEFT: {
                    if (shapeFrom == StairsShape.OUTER_RIGHT && facingFrom == facing.m_122428_()) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.m_122428_()) break;
                    return true;
                }
                case OUTER_RIGHT: {
                    if (shapeFrom == StairsShape.OUTER_LEFT && facingFrom == facing.m_122427_()) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.m_122427_()) break;
                    return true;
                }
            }
        }
        if (facingFrom == direction.m_122424_() && shapeFrom != StairsShape.OUTER_LEFT && shapeFrom != StairsShape.OUTER_RIGHT) {
            return true;
        }
        if (facingFrom.m_122428_() == direction && shapeFrom == StairsShape.INNER_RIGHT) {
            return true;
        }
        if (facingFrom.m_122427_() == direction && shapeFrom == StairsShape.INNER_LEFT) {
            return true;
        }
        if (direction == facing && half == halfFrom) {
            if (facingFrom == facing.m_122428_() && shape == StairsShape.OUTER_LEFT && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.m_122427_() && shape == StairsShape.OUTER_RIGHT && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
        }
        if (direction == facing.m_122424_() && half == halfFrom) {
            if (facingFrom == facing.m_122428_() && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
            if (facingFrom == facing.m_122427_() && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.m_122424_()) {
                return true;
            }
        }
        if (direction == facing.m_122428_() && half == halfFrom) {
            if (facingFrom == direction && shape != StairsShape.INNER_LEFT && shapeFrom == StairsShape.INNER_RIGHT) {
                return true;
            }
            if (facingFrom == facing && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
            if (facingFrom == facing.m_122427_() && shapeFrom == StairsShape.OUTER_LEFT && shape != StairsShape.INNER_LEFT) {
                return true;
            }
            if (facingFrom == facing.m_122424_() && shape == StairsShape.OUTER_RIGHT) {
                return true;
            }
        }
        if (direction == facing.m_122427_() && half == halfFrom) {
            if (facingFrom == direction && shape != StairsShape.INNER_RIGHT && shapeFrom == StairsShape.INNER_LEFT) {
                return true;
            }
            if (facingFrom == facing && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.m_122428_() && shapeFrom == StairsShape.OUTER_RIGHT && shape != StairsShape.INNER_RIGHT) {
                return true;
            }
            return facingFrom == facing.m_122424_() && shape == StairsShape.OUTER_LEFT;
        }
        return false;
    }
}

