/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class LabyrinthLightPathSlabBlock
extends SlabBlock {
    public LabyrinthLightPathSlabBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.m_60734_() == TensuraBlocks.LABYRINTH_LIGHT_PATH.get()) {
            return true;
        }
        if (stateFrom.m_60734_() == TensuraBlocks.LABYRINTH_PRAYING_PATH.get()) {
            return true;
        }
        if (stateFrom.m_60734_() == this && this.isInvisibleToGlassSlab(state, stateFrom, direction)) {
            return true;
        }
        if (stateFrom.m_60734_() == TensuraBlocks.LABYRINTH_LIGHT_PATH_STAIRS.get() && this.isInvisibleToGlassStairs(state, stateFrom, direction)) {
            return true;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
        SlabType typeFrom = (SlabType)stateFrom.m_61143_((Property)SlabBlock.f_56353_);
        switch (direction) {
            case UP: {
                if (typeFrom == SlabType.TOP || type == SlabType.BOTTOM) break;
                return true;
            }
            case DOWN: {
                if (typeFrom == SlabType.BOTTOM || type == SlabType.TOP) break;
                return true;
            }
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                if (type != typeFrom && typeFrom != SlabType.DOUBLE) break;
                return true;
            }
        }
        return false;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        SlabType type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
        Half halfFrom = (Half)stateFrom.m_61143_((Property)StairBlock.f_56842_);
        Direction facingFrom = (Direction)stateFrom.m_61143_((Property)StairBlock.f_56841_);
        if (direction == Direction.UP && halfFrom == Half.BOTTOM) {
            return true;
        }
        if (direction == Direction.DOWN && halfFrom == Half.TOP) {
            return true;
        }
        if (facingFrom == direction.m_122424_()) {
            return true;
        }
        if (direction.m_122416_() != -1) {
            if (type == SlabType.BOTTOM && halfFrom == Half.BOTTOM) {
                return true;
            }
            return type == SlabType.TOP && halfFrom == Half.TOP;
        }
        return false;
    }
}

