/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.block;

import com.github.manasmods.tensura.block.entity.KilnBlockEntity;
import com.github.manasmods.tensura.block.state.properties.KilnPart;
import com.github.manasmods.tensura.block.state.properties.TensuraBlockStateProperties;
import com.github.manasmods.tensura.registry.blocks.TensuraBlockEntities;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class KilnBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<KilnPart> PART = TensuraBlockStateProperties.KILN_PART;
    private static final VoxelShape TOP_SHAPE = Shapes.m_83124_((VoxelShape)KilnBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KilnBlock.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), KilnBlock.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), KilnBlock.m_49796_((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), KilnBlock.m_49796_((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)});
    private static final VoxelShape BASE_SHAPE = Shapes.m_83124_((VoxelShape)KilnBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KilnBlock.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), KilnBlock.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)});

    public KilnBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_164534_).m_60913_(50.0f, 1200.0f).m_60918_(SoundType.f_56742_).m_60955_().m_60953_(KilnBlock.litBlockEmission(13)).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)KilnPart.BASE))).m_61124_((Property)LIT, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pLevel.m_5776_()) {
            return;
        }
        BlockPos blockpos = this.getOtherPartPosition(pPos, (KilnPart)((Object)pState.m_61143_(PART)));
        pLevel.m_7731_(blockpos, (BlockState)((BlockState)pState.m_61124_(PART, (Comparable)((Object)KilnPart.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(this.isWaterAtPosition(pLevel, blockpos))), 3);
        pLevel.m_6289_(pPos, Blocks.f_50016_);
        pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
    }

    private BlockPos getOtherPartPosition(BlockPos sourcePos, KilnPart part) {
        return part == KilnPart.BASE ? sourcePos.m_7494_() : sourcePos.m_7495_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT, PART, WATERLOGGED});
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (!pLevel.m_5776_()) {
            BlockPos blockpos = this.getOtherPartPosition(pPos, (KilnPart)((Object)pState.m_61143_(PART)));
            pLevel.m_46597_(blockpos, Blocks.f_50016_.m_49966_());
        }
    }

    public void m_7592_(Level pLevel, BlockPos pPos, Explosion pExplosion) {
        if (pLevel.m_5776_()) {
            return;
        }
        BlockState pState = pLevel.m_8055_(pPos);
        BlockPos blockpos = this.getOtherPartPosition(pPos, (KilnPart)((Object)pState.m_61143_(PART)));
        pLevel.m_46597_(blockpos, Blocks.f_50016_.m_49966_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        if (blockpos.m_123342_() > level.m_151558_() - 1 || !level.m_8055_(blockpos.m_7494_()).m_60629_(pContext)) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(this.isWaterAtPosition(level, blockpos)));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private boolean isWaterAtPosition(Level level, BlockPos blockPos) {
        return level.m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76193_);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevek, BlockPos pPos, CollisionContext pContext) {
        KilnPart part = (KilnPart)((Object)pState.m_61143_(PART));
        if (part == KilnPart.TOP) {
            return TOP_SHAPE;
        }
        return BASE_SHAPE;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue() && ((KilnPart)((Object)pState.m_61143_(PART))).equals((Object)KilnPart.BASE)) {
            double d0 = (double)pPos.m_123341_() + 0.5;
            double d1 = pPos.m_123342_();
            double d2 = (double)pPos.m_123343_() + 0.5;
            if (pRandom.m_188500_() < 0.1) {
                pLevel.m_7785_(d0, d1, d2, SoundEvents.f_11715_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)pState.m_61143_((Property)FACING);
            Direction.Axis direction$axis = direction.m_122434_();
            double d3 = pRandom.m_188500_() * 0.6 - 0.3;
            double d4 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d3;
            double d5 = pRandom.m_188500_() * 6.0 / 16.0;
            double d6 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d3;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d4, d1 + d5, d2 + d6, 0.0, 0.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d4, d1 + d5, d2 + d6, 0.0, 0.0, 0.0);
        }
    }

    public static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? pLightValue : 0;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof KilnBlockEntity) {
            KilnBlockEntity kilnblockEntity = (KilnBlockEntity)blockEntity;
            kilnblockEntity.drops();
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.m_19078_((boolean)true);
        }
        return this.openMenu((ServerPlayer)pPlayer, pLevel, ((KilnPart)((Object)pState.m_61143_(PART))).equals((Object)KilnPart.BASE) ? pPos : pPos.m_7495_());
    }

    private InteractionResult openMenu(ServerPlayer player, Level level, BlockPos pos) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof KilnBlockEntity) {
            KilnBlockEntity kilnblockEntity = (KilnBlockEntity)entity;
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)kilnblockEntity, (BlockPos)pos);
            return InteractionResult.m_19078_((boolean)false);
        }
        throw new IllegalStateException(String.format("Container provider for Kiln block is missing!\n Position: %s; World: %s", pos, level.m_46472_()));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(PART) == KilnPart.BASE) {
            return new KilnBlockEntity(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (state.m_61143_(PART) == KilnPart.BASE) {
            return KilnBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TensuraBlockEntities.KILN.get()), KilnBlockEntity::tick);
        }
        return null;
    }
}

