/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.subclass;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.spike.SpikeEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;

public interface IGiantMob {
    default public boolean breakBlocks(LivingEntity entity, float inflation, boolean breakFloor) {
        return this.breakBlocks(entity, inflation, breakFloor, null);
    }

    default public boolean breakBlocks(LivingEntity entity, float inflation, boolean breakFloor, @Nullable SimpleContainer container) {
        return this.breakBlocks(entity, inflation, breakFloor, 0, container);
    }

    default public boolean breakBlocks(LivingEntity entity, float inflation, boolean breakFloor, int yStep, @Nullable SimpleContainer container) {
        return this.breakBlocks(entity, inflation, breakFloor, yStep, container, false);
    }

    default public boolean breakBlocks(LivingEntity entity, float inflation, boolean breakFloor, int yStep, @Nullable SimpleContainer container, boolean ignoreCollision) {
        if (this.cantBreakBlock(entity, ignoreCollision)) {
            return false;
        }
        AABB aabb = entity.m_20191_().m_82400_((double)inflation);
        List list = entity.f_19853_.m_45976_(SpikeEntity.class, aabb);
        if (!list.isEmpty()) {
            for (SpikeEntity spike : list) {
                spike.onBreak();
            }
        }
        int floorY = Mth.m_14107_((double)aabb.f_82289_) + yStep;
        if (!breakFloor) {
            floorY += (int)inflation;
        }
        boolean success = false;
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)floorY, (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)(Mth.m_14107_((double)aabb.f_82292_) + yStep), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState state;
            if (!this.breakableBlocks(entity, pos, state = entity.f_19853_.m_8055_(pos))) continue;
            boolean drop = this.dropBlockLoot(entity, state);
            if (container != null) {
                Level level = entity.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    for (ItemStack item : IGiantMob.blockDrops(entity, entity.m_21205_(), level2, pos, state)) {
                        if (container.m_19183_(item)) {
                            container.m_19173_(item);
                            continue;
                        }
                        if (!drop) continue;
                        level2.m_7967_((Entity)new ItemEntity((Level)level2, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item));
                    }
                    if (state.m_60819_().m_76170_()) {
                        entity.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    } else {
                        entity.f_19853_.m_46953_(pos, false, (Entity)entity);
                    }
                }
            } else if (state.m_60819_().m_76170_()) {
                entity.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
            } else {
                entity.f_19853_.m_46953_(pos, drop, (Entity)entity);
            }
            success = true;
        }
        return success;
    }

    default public void digBlocks(LivingEntity entity, float inflation, int height, float extraXZ, boolean breakFloor, @Nullable SimpleContainer container) {
        if (this.cantBreakBlock(entity, false)) {
            return;
        }
        AABB aabb = entity.m_20191_().m_82400_((double)inflation);
        int floorY = Mth.m_14107_((double)aabb.f_82289_) + height;
        int ceilY = Mth.m_14107_((double)aabb.f_82292_) + height;
        if (!breakFloor) {
            floorY += (int)inflation;
        }
        float angle = (float)Math.PI / 180 * entity.f_20883_;
        double extraX = extraXZ * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = extraXZ * Mth.m_14089_((float)angle);
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)(aabb.f_82288_ + extraX)), (int)floorY, (int)Mth.m_14107_((double)(aabb.f_82290_ + extraZ)), (int)Mth.m_14107_((double)(aabb.f_82291_ + extraX)), (int)ceilY, (int)Mth.m_14107_((double)(aabb.f_82293_ + extraZ)))) {
            BlockState state;
            if (!this.diggableBlocks(entity, pos, state = entity.f_19853_.m_8055_(pos))) continue;
            boolean drop = this.dropBlockLoot(entity, state);
            if (container != null) {
                Level level = entity.f_19853_;
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel level2 = (ServerLevel)level;
                for (ItemStack item : IGiantMob.blockDrops(entity, entity.m_21205_(), level2, pos, state)) {
                    if (container.m_19183_(item)) {
                        container.m_19173_(item);
                        continue;
                    }
                    if (!drop) continue;
                    level2.m_7967_((Entity)new ItemEntity((Level)level2, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), item));
                }
                entity.f_19853_.m_46953_(pos, false, (Entity)entity);
                continue;
            }
            entity.f_19853_.m_46953_(pos, drop, (Entity)entity);
        }
    }

    default public boolean removeFluid(LivingEntity entity, TagKey<Fluid> tag, float inflation, boolean breakFloor, int yStep) {
        if (this.cantBreakBlock(entity, true)) {
            return false;
        }
        AABB aabb = entity.m_20191_().m_82400_((double)inflation);
        int floorY = Mth.m_14107_((double)aabb.f_82289_) + yStep;
        if (!breakFloor) {
            floorY += (int)inflation;
        }
        boolean success = false;
        Level level = entity.m_9236_();
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)floorY, (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)(Mth.m_14107_((double)aabb.f_82292_) + yStep), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            FluidState fluidState = level.m_6425_(pos);
            if (fluidState.m_76178_() || !fluidState.m_205070_(tag)) continue;
            BlockState state = level.m_8055_(pos);
            if (fluidState.m_76170_()) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            } else if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 11);
            }
            success = true;
        }
        return success;
    }

    default public boolean breakableBlocks(LivingEntity entity, BlockPos pos, BlockState state) {
        if (!state.m_204336_(TensuraTags.Blocks.BREAKABLE_BY_MONSTER)) {
            return false;
        }
        return ForgeEventFactory.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)pos, (BlockState)state);
    }

    default public boolean diggableBlocks(LivingEntity entity, BlockPos pos, BlockState state) {
        if (!state.m_204336_(TensuraTags.Blocks.DIGGABLE_BY_MONSTER)) {
            return false;
        }
        return ForgeEventFactory.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)pos, (BlockState)state);
    }

    default public boolean cantBreakBlock(LivingEntity entity, boolean ignoreCollision) {
        if (!entity.m_6084_()) {
            return true;
        }
        if (entity.m_6162_()) {
            return true;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity)) {
            return true;
        }
        if (this.isColliding(entity, ignoreCollision)) {
            return false;
        }
        Entity controllingPassenger = entity.m_6688_();
        if (controllingPassenger == null) {
            return true;
        }
        if (SkillHelper.getPlayerPOVHitResult(entity.f_19853_, (Entity)entity, ClipContext.Fluid.NONE, 1.0f + entity.m_20205_() / 2.0f).m_6662_().equals((Object)HitResult.Type.BLOCK)) {
            return false;
        }
        if (!(controllingPassenger instanceof LivingEntity)) {
            return true;
        }
        LivingEntity rider = (LivingEntity)controllingPassenger;
        return !SkillHelper.getPlayerPOVHitResult(entity.f_19853_, (Entity)rider, ClipContext.Fluid.NONE, 2.0f + entity.m_20205_() / 2.0f).m_6662_().equals((Object)HitResult.Type.BLOCK);
    }

    default public boolean dropBlockLoot(LivingEntity entity, BlockState state) {
        return true;
    }

    default public boolean isColliding(LivingEntity entity, boolean ignore) {
        if (ignore) {
            return true;
        }
        return entity.f_19862_ || entity.f_19863_ && !entity.f_201939_;
    }

    public static List<ItemStack> blockDrops(LivingEntity entity, ItemStack tool, ServerLevel level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        return Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)entity, (ItemStack)tool);
    }
}

