/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.subclass;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface IFollower {
    public boolean shouldFollow();

    default public void followEntity(TamableAnimal tameable, LivingEntity owner, double followSpeed) {
        tameable.m_21573_().m_5624_((Entity)owner, followSpeed);
    }

    default public boolean isOverWater(LivingEntity living) {
        BlockPos position = living.m_20183_();
        while (position.m_123342_() > 0 && living.f_19853_.m_46859_(position)) {
            position = position.m_7495_();
        }
        return !living.f_19853_.m_6425_(position).m_76178_() || position.m_123342_() <= 0;
    }

    default public BlockPos getGround(LivingEntity living, BlockPos in) {
        BlockPos position = new BlockPos((double)in.m_123341_(), living.m_20186_(), (double)in.m_123343_());
        while (position.m_123342_() > -64 && !living.f_19853_.m_8055_(position).m_60767_().m_76337_() && living.f_19853_.m_6425_(position).m_76178_()) {
            position = position.m_7495_();
        }
        return position;
    }

    default public boolean targetNotBlocked(LivingEntity living, Vec3 target) {
        Vec3 Vector3d = new Vec3(living.m_20185_(), living.m_20188_(), living.m_20189_());
        return living.f_19853_.m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living)).m_6662_() == HitResult.Type.MISS;
    }

    @Nullable
    default public Vec3 getBlockInViewAway(LivingEntity living, Vec3 fleePos, float radiusAdd) {
        float radius = -9.45f - (float)living.m_217043_().m_188503_(24) - radiusAdd;
        float neg = living.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float renderYawOffset = living.f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + living.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.m_7096_() + extraX, 0.0, fleePos.m_7094_() + extraZ);
        BlockPos ground = this.getGround(living, radialPos);
        int distFromGround = (int)living.m_20186_() - ground.m_123342_();
        int flightHeight = 4 + living.m_217043_().m_188503_(10);
        BlockPos newPos = ground.m_6630_(distFromGround > 8 ? flightHeight : living.m_217043_().m_188503_(6) + 1);
        if (this.targetNotBlocked(living, Vec3.m_82512_((Vec3i)newPos)) && living.m_20238_(Vec3.m_82512_((Vec3i)newPos)) > 1.0) {
            return Vec3.m_82512_((Vec3i)newPos);
        }
        return null;
    }

    @Nullable
    default public Vec3 getBlockGrounding(LivingEntity living, Vec3 fleePos) {
        float radius = -9.45f - (float)living.m_217043_().m_188503_(24);
        float neg = living.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float renderYawOffset = living.f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + living.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.m_7096_() + extraX, living.m_20186_(), fleePos.m_7094_() + extraZ);
        BlockPos ground = this.getGround(living, radialPos);
        if (ground.m_123342_() == -64) {
            return living.m_20182_();
        }
        ground = living.m_20183_();
        while (ground.m_123342_() > -62 && !living.f_19853_.m_8055_(ground).m_60767_().m_76337_()) {
            ground = ground.m_7495_();
        }
        if (this.targetNotBlocked(living, Vec3.m_82512_((Vec3i)ground.m_7494_()))) {
            return Vec3.m_82512_((Vec3i)ground);
        }
        return null;
    }
}

