/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.subclass;

import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.api.entity.subclass.ISummonable;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.custom.ElementCoreItem;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface IElementalSpirit
extends ISummonable {
    public MagicElemental getElemental();

    public SpiritualMagic.SpiritLevel getSpiritLevel();

    default public void summoningTicking(TamableAnimal entity) {
        this.summoningTicking((Mob)entity, this.getSpiritLevel() == SpiritualMagic.SpiritLevel.MEDIUM ? 50.0 : 300.0);
    }

    default public float getPhysicalAttackInput(DamageSource damageSource) {
        LivingEntity living;
        Entity entity = damageSource.m_7640_();
        if (entity instanceof LivingEntity && RaceHelper.isSpiritual(living = (LivingEntity)entity)) {
            return 1.0f;
        }
        return RaceHelper.spiritualReducePhysicalDamage(damageSource);
    }

    default public boolean convertElementalCore(LivingEntity spirit, Player player, InteractionHand hand, Item magicCore) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (!(item instanceof ElementCoreItem)) {
            return false;
        }
        ElementCoreItem core = (ElementCoreItem)item;
        if (((Object)((Object)core)).equals(magicCore) && stack.m_41773_() <= 0) {
            return false;
        }
        double EP = TensuraEPCapability.getEP(spirit);
        int cost = (Integer)TensuraConfig.INSTANCE.itemsConfig.elementalCoreCost.get();
        DamageSourceHelper.markHurt(spirit, null);
        if (EP < (double)cost) {
            spirit.m_9236_().m_6269_(null, (Entity)spirit, SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        TensuraEPCapability.getFrom(spirit).ifPresent(cap -> {
            cap.setEP(spirit, EP - (double)cost);
            TensuraEPCapability.sync(spirit);
        });
        player.m_21008_(hand, new ItemStack((ItemLike)magicCore));
        spirit.m_9236_().m_6269_(null, (Entity)spirit, SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    public static class FollowGreaterSpiritGoal
    extends Goal {
        protected final TensuraTamableEntity spirit;
        @Nullable
        protected Mob greater;
        protected final Class<? extends Mob> greaterClass;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowGreaterSpiritGoal(TensuraTamableEntity spirit, double pSpeedModifier, Class<? extends Mob> greaterClass) {
            this.spirit = spirit;
            this.speedModifier = pSpeedModifier;
            this.greaterClass = greaterClass;
        }

        protected boolean hasTarget() {
            if (this.spirit.m_5448_() == null) {
                return false;
            }
            return !this.spirit.m_7307_((Entity)this.spirit.m_5448_());
        }

        public boolean m_8036_() {
            if (this.spirit.m_21826_() != null) {
                return false;
            }
            if (this.spirit.m_21523_() || this.spirit.m_20159_()) {
                return false;
            }
            if (this.hasTarget()) {
                return false;
            }
            List list = this.spirit.f_19853_.m_45976_(this.greaterClass, this.spirit.m_20191_().m_82377_(32.0, 16.0, 32.0));
            Mob owner = null;
            double d0 = Double.MAX_VALUE;
            for (Mob greater : list) {
                double distance = this.spirit.m_20280_((Entity)greater);
                if (!(distance <= d0)) continue;
                d0 = distance;
                owner = greater;
            }
            if (owner == null) {
                return false;
            }
            if (d0 > 256.0) {
                this.greater = owner;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.spirit.m_21824_()) {
                return false;
            }
            if (this.spirit.m_21523_() || this.spirit.m_20159_()) {
                return false;
            }
            if (this.hasTarget()) {
                return false;
            }
            if (this.greater == null) {
                return false;
            }
            if (!this.greater.m_6084_()) {
                return false;
            }
            double d0 = this.spirit.m_20280_((Entity)this.greater);
            return d0 >= 49.0 && d0 <= 256.0;
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            if (this.spirit.m_5803_()) {
                this.spirit.setSleeping(false);
            }
        }

        public void m_8041_() {
            this.greater = null;
            this.spirit.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath > 0) {
                return;
            }
            if (this.greater == null) {
                return;
            }
            if (this.greater.m_5448_() != null && !this.hasTarget() && this.greater.m_5448_() != this.spirit && this.greater.m_5448_().m_20270_((Entity)this.spirit) <= 30.0f) {
                this.spirit.m_6710_(this.greater.m_5448_());
            }
            this.timeToRecalcPath = this.m_183277_(10);
            this.spirit.m_21573_().m_5624_((Entity)this.greater, this.speedModifier);
        }
    }
}

