/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.ai;

import com.github.manasmods.tensura.api.entity.subclass.IFollower;
import com.github.manasmods.tensura.entity.LandfishEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class SemiAquaticFollowOwnerGoal
extends Goal {
    private final TamableAnimal tameable;
    private final LevelReader world;
    private final double followSpeed;
    private final float maxDist;
    private final float minDist;
    private final boolean teleportToLeaves;
    private final boolean avoidLand;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public SemiAquaticFollowOwnerGoal(TamableAnimal tamed, double speed, float minDist, float maxDist, boolean leaves, boolean avoidLand) {
        this.tameable = tamed;
        this.world = tamed.f_19853_;
        this.followSpeed = speed;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = leaves;
        this.avoidLand = avoidLand;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        TensuraTamableEntity tensuraTamable;
        LivingEntity owner = this.tameable.m_21826_();
        if (owner == null) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (!((IFollower)this.tameable).shouldFollow() || this.isInCombat()) {
            return false;
        }
        if (this.tameable.m_20280_((Entity)owner) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        TamableAnimal tamableAnimal = this.tameable;
        if (tamableAnimal instanceof TensuraTamableEntity && (tensuraTamable = (TensuraTamableEntity)tamableAnimal).isWandering()) {
            return false;
        }
        if (this.tameable.m_5448_() != null && this.tameable.m_5448_().m_6084_()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        TensuraTamableEntity tensuraTamable;
        if (this.tameable.m_21573_().m_26571_() || this.isInCombat()) {
            return false;
        }
        if (!((IFollower)this.tameable).shouldFollow()) {
            return false;
        }
        TamableAnimal tamableAnimal = this.tameable;
        if (tamableAnimal instanceof TensuraTamableEntity && (tensuraTamable = (TensuraTamableEntity)tamableAnimal).isWandering()) {
            return false;
        }
        if (this.tameable.m_5448_() != null && this.tameable.m_5448_().m_6084_()) {
            return false;
        }
        return this.tameable.m_20280_((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    private boolean isInCombat() {
        LivingEntity owner = this.tameable.m_21826_();
        if (owner == null) {
            return false;
        }
        return this.tameable.m_20270_((Entity)owner) < 30.0f && this.tameable.m_5448_() != null && this.tameable.m_5448_().m_6084_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tameable.m_21439_(BlockPathTypes.WATER);
        this.tameable.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.tameable.m_21573_().m_26573_();
        this.tameable.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.tameable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tameable.m_8132_());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = 10;
        if (this.tameable.m_21523_() || this.tameable.m_20159_()) {
            return;
        }
        if (this.tameable.m_20280_((Entity)this.owner) >= 144.0) {
            this.tryToTeleportNearEntity();
        } else {
            this.tameable.m_21573_().m_5624_((Entity)this.owner, this.followSpeed);
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos pos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int xRan = this.getRandomNumber(-3, 3);
            int yRan = this.getRandomNumber(-1, 1);
            int zRan = this.getRandomNumber(-3, 3);
            boolean teleport = this.tryToTeleportToLocation(pos.m_123341_() + xRan, pos.m_123342_() + yRan, pos.m_123343_() + zRan);
            if (!teleport) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.tameable.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.tameable.m_146908_(), this.tameable.m_146909_());
        this.tameable.m_21573_().m_26573_();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPathTypes blockPathType = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (this.world.m_6425_(pos).m_205070_(FluidTags.f_13131_) || !this.world.m_6425_(pos).m_205070_(FluidTags.f_13131_) && this.world.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        if (blockPathType != BlockPathTypes.WALKABLE || this.avoidsLand()) {
            return false;
        }
        BlockState state = this.world.m_8055_(pos.m_7495_());
        if (!this.teleportToLeaves && state.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos = pos.m_121996_((Vec3i)this.tameable.m_20183_());
        return this.world.m_45756_((Entity)this.tameable, this.tameable.m_20191_().m_82338_(blockPos));
    }

    public boolean avoidsLand() {
        TamableAnimal tamableAnimal = this.tameable;
        if (tamableAnimal instanceof LandfishEntity) {
            LandfishEntity landfishEntity = (LandfishEntity)tamableAnimal;
            return landfishEntity.getMoistnessLevel() < 300;
        }
        return this.avoidLand;
    }

    private int getRandomNumber(int i, int in) {
        return this.tameable.m_217043_().m_188503_(in - i + 1) + i;
    }
}

