/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.api.entity.ai;

import com.github.manasmods.tensura.entity.HellCaterpillarEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public class CaterpillarTryToCocoonGoal
extends MoveToBlockGoal {
    private final HellCaterpillarEntity caterpillar;
    private int ticksSinceReachedGoal;

    public CaterpillarTryToCocoonGoal(HellCaterpillarEntity pRemoverMob, double pSpeedModifier, int pSearchRange) {
        super((PathfinderMob)pRemoverMob, pSpeedModifier, 16, pSearchRange);
        this.caterpillar = pRemoverMob;
    }

    public boolean m_8036_() {
        if (this.caterpillar.isCocooned()) {
            return false;
        }
        if (this.caterpillar.m_6162_()) {
            return false;
        }
        if (this.caterpillar.getGrassEaten() < 50) {
            return false;
        }
        if (--this.f_25600_ > 0) {
            return false;
        }
        if (this.tryFindBlock()) {
            this.f_25600_ = CaterpillarTryToCocoonGoal.m_186073_((int)20);
            return true;
        }
        this.f_25600_ = this.m_6099_(this.f_25598_);
        return false;
    }

    public boolean m_8045_() {
        return super.m_8045_() && !this.caterpillar.isCocooned();
    }

    public double m_8052_() {
        return 2.0;
    }

    private boolean tryFindBlock() {
        return this.m_6465_((LevelReader)this.f_25598_.f_19853_, this.f_25602_) || this.m_25626_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.ticksSinceReachedGoal = 0;
    }

    public void m_8037_() {
        super.m_8037_();
        Level level = this.caterpillar.f_19853_;
        BlockPos blockpos = this.caterpillar.m_20183_();
        BlockPos pos = this.getPosWithBlock(blockpos, (BlockGetter)level);
        if (pos != null && (level.m_8055_(blockpos.m_7494_()).m_204336_(BlockTags.f_13035_) || level.m_8055_(blockpos.m_7494_()).m_204336_(BlockTags.f_13106_)) || level.m_8055_(blockpos).m_204336_(BlockTags.f_13106_)) {
            if (!this.caterpillar.hasStartedCocoon() && this.ticksSinceReachedGoal > 5) {
                this.caterpillar.setStartCocoon(Boolean.TRUE);
            }
            if (this.ticksSinceReachedGoal > 35 && !this.caterpillar.isCocooned()) {
                this.caterpillar.makeCocoon();
            }
            ++this.ticksSinceReachedGoal;
        }
    }

    @Nullable
    private BlockPos getPosWithBlock(BlockPos pPos, BlockGetter pLevel) {
        BlockPos[] pos;
        if (pLevel.m_8055_(pPos).m_204336_(BlockTags.f_13035_)) {
            return pPos;
        }
        for (BlockPos blockpos : pos = new BlockPos[]{pPos.m_7494_(), pPos.m_122024_(), pPos.m_122029_(), pPos.m_122012_(), pPos.m_122019_(), pPos.m_7494_().m_7494_()}) {
            if (!pLevel.m_8055_(blockpos).m_204336_(BlockTags.f_13035_)) continue;
            return blockpos;
        }
        return null;
    }

    protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
        ChunkAccess chunkaccess = pLevel.m_6522_(SectionPos.m_123171_((int)pPos.m_123341_()), SectionPos.m_123171_((int)pPos.m_123343_()), ChunkStatus.f_62326_, false);
        if (chunkaccess != null) {
            boolean isLeaves;
            boolean bl = isLeaves = chunkaccess.m_8055_(pPos).m_204336_(BlockTags.f_13035_) || chunkaccess.m_8055_(pPos).m_204336_(BlockTags.f_13106_);
            if (isLeaves) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    mutableBlockPos.m_122159_((Vec3i)pPos, direction);
                    if (!chunkaccess.m_8055_((BlockPos)mutableBlockPos).m_204336_(BlockTags.f_13035_) || !chunkaccess.m_8055_(mutableBlockPos.m_7495_()).m_60795_() || !chunkaccess.m_8055_(mutableBlockPos.m_6625_(2)).m_60795_()) continue;
                    return chunkaccess.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_13106_) && chunkaccess.m_8055_(pPos.m_6625_(2)).m_204336_(BlockTags.f_13106_) && chunkaccess.m_8055_(pPos.m_6625_(3)).m_204336_(BlockTags.f_13106_);
                }
            }
        }
        return false;
    }
}

