/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.resist.AbnormalConditionNullification;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;

public class SurvivorSkill
extends Skill {
    public SurvivorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 30000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public boolean canBeSlotted(ManasSkillInstance instance) {
        return instance.getMastery() < 0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        DamageSource source = e.getSource();
        if (this.isNullificationBypass(source)) {
            return;
        }
        if (DamageSourceHelper.isPoison(source)) {
            e.setAmount(0.0f);
        }
        LivingEntity entity = e.getEntity();
        if (DamageSourceHelper.isNaturalEffects(source) && !this.isResistanceBypass(source)) {
            if (e.getAmount() > entity.m_21223_() / 2.0f) {
                e.setAmount(e.getAmount() / 2.0f);
            } else {
                e.setAmount(0.0f);
            }
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 6 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSTANT_REGENERATION.get(), 240, 0, false, false, false));
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        SkillHelper.removePredicateEffect(entity, effect -> effect == TensuraMobEffects.CHILL.get() || AbnormalConditionNullification.getAbnormalEffects().contains(effect));
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        MobEffectInstance effectInstance = entity.m_21124_((MobEffect)TensuraMobEffects.INSTANT_REGENERATION.get());
        if (effectInstance != null && effectInstance.m_19564_() < 1) {
            entity.m_21195_((MobEffect)TensuraMobEffects.INSTANT_REGENERATION.get());
        }
    }

    @Override
    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        ArrayList<MobEffect> list = new ArrayList<MobEffect>();
        if (!instance.isToggled()) {
            return list;
        }
        list.addAll(AbnormalConditionNullification.getAbnormalEffects());
        list.add((MobEffect)TensuraMobEffects.CHILL.get());
        return list;
    }

    public boolean isNullificationBypass(DamageSource damageSource) {
        TensuraDamageSource source;
        Entity entity = damageSource.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        if (TensuraSkillCapability.isSkillInSlot(living, (ManasSkill)UniqueSkills.ANTI_SKILL.get())) {
            return true;
        }
        return damageSource instanceof TensuraDamageSource && (source = (TensuraDamageSource)damageSource).getIgnoreResistance() >= 2.0f;
    }

    public boolean isResistanceBypass(DamageSource damageSource) {
        TensuraDamageSource source;
        Entity entity = damageSource.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        if (damageSource instanceof TensuraDamageSource && (source = (TensuraDamageSource)damageSource).getIgnoreResistance() == 1.0f) {
            return true;
        }
        return SkillUtils.reducingResistances(living);
    }
}

