/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.SpatialMotionSkill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.event.ForcedTeleportationEvent;
import com.github.manasmods.tensura.menu.SpatialMenu;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class SuppressorSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("48a488be-c57d-4dce-a166-08c0e9a27d6c");

    public SuppressorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 20000.0;
    }

    @Override
    public double learningCost() {
        return 500.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.suppressor.blockade");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.suppressor.swap");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.suppressor.motion");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 100.0;
            case 1 -> 300.0;
            default -> 0.0;
        };
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        switch (instance.getMode()) {
            case 1: {
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(25.0), living -> !living.m_7306_((Entity)living) && living.m_6084_() && !living.m_7307_((Entity)living));
                if (list.isEmpty()) {
                    return;
                }
                for (LivingEntity target : list) {
                    target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.SPATIAL_BLOCKADE.get(), 1200, 0, false, false, true), (Entity)entity);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123760_, 1.0);
                }
                break;
            }
            case 2: {
                if (MobEffectHelper.noTeleportation(entity)) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    }
                    return;
                }
                Entity target = SkillHelper.getTargetingEntity(entity, 30.0, 0.2, false, false);
                if (target == null) {
                    return;
                }
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                Vec3 targetPos = new Vec3(target.m_20182_().m_7096_(), target.m_20182_().m_7098_(), target.m_20182_().m_7094_());
                Vec3 userPos = new Vec3(entity.m_20182_().m_7096_(), entity.m_20182_().m_7098_(), entity.m_20182_().m_7094_());
                ForcedTeleportationEvent event = new ForcedTeleportationEvent(target, (Entity)entity, entity.m_20182_().m_7096_(), entity.m_20182_().m_7098_(), entity.m_20182_().m_7094_());
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                EntityTeleportEvent teleportEvent = new EntityTeleportEvent((Entity)entity, target.m_20182_().m_7096_(), target.m_20182_().m_7098_(), target.m_20182_().m_7094_());
                if (MinecraftForge.EVENT_BUS.post((Event)teleportEvent)) {
                    return;
                }
                target.m_183634_();
                target.m_19877_();
                target.m_146884_(userPos);
                target.f_19812_ = true;
                target.f_19864_ = true;
                entity.m_183634_();
                entity.m_19877_();
                entity.m_20219_(targetPos);
                entity.f_19812_ = true;
                entity.f_19864_ = true;
                this.addMasteryPoint(instance, entity);
                TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)ParticleTypes.f_123760_, 1.0);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123760_, 1.0);
                level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                if (MobEffectHelper.noTeleportation(entity)) {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                    }
                    return;
                }
                if (entity.m_6144_()) {
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        if (level.m_46472_() == TensuraDimensions.LABYRINTH) {
                            serverPlayer.m_6330_(SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            serverPlayer.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                        } else {
                            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(SpatialMenu::new, (Component)Component.m_237119_()), buf -> buf.writeBoolean(false));
                            serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                    entity.m_21195_((MobEffect)TensuraMobEffects.WARPING.get());
                    return;
                }
                BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, this.isMastered(instance, entity) ? 50.0 : 30.0);
                BlockPos pos = result.m_82425_().m_121945_(result.m_82434_());
                if (level.m_8055_(pos).m_60713_((Block)TensuraBlocks.LABYRINTH_BARRIER_BLOCK.get())) {
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
                if (SkillHelper.outOfMagicule(entity, 10.0 * Math.sqrt(entity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())))) {
                    return;
                }
                SpatialMotionSkill.warp(entity, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 2 : 5);
            }
        }
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, false);
    }
}

