/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.common.ThoughtCommunicationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class StarvedSkill
extends Skill
implements ISpatialStorage {
    private static final String CORROSION = "80b77a7b-bdf4-4ff3-add1-cc09256c2885";

    public StarvedSkill() {
        super(Skill.SkillType.UNIQUE);
        this.addHeldAttributeModifier(Attributes.f_22279_, CORROSION, -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public double getObtainingEpCost() {
        return 50000.0;
    }

    @Override
    public double learningCost() {
        return 2000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public int modes() {
        return 5;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 5 : instance.getMode() - 1;
        }
        return instance.getMode() == 5 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.starved.corrosion");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.starved.stomach");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.starved.receive");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.starved.provide");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.spiritual_domination");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 200.0;
            default -> 0.0;
        };
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        if (instance.getMastery() < 0 || instance.isTemporarySkill()) {
            return;
        }
        if (!SkillUtils.isSkillMastered(entity, (ManasSkill)UniqueSkills.PREDATOR.get())) {
            return;
        }
        ManasSkill skill = (ManasSkill)UniqueSkills.GLUTTONY.get();
        if (SkillUtils.learnSkill(entity, skill) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (!this.isInSlot(attacker) || instance.getMode() != 1) {
            return;
        }
        if (e.getSource().m_7640_() != attacker) {
            return;
        }
        if (!DamageSourceHelper.isPhysicalAttack(e.getSource())) {
            return;
        }
        LivingEntity target = e.getEntity();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            SkillHelper.addEffectWithSource(target, (LivingEntity)player, (MobEffect)TensuraMobEffects.CORROSION.get(), 200, 1);
        } else {
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.CORROSION.get(), 200, 1, false, false, false));
        }
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12031_, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.ACID_BUBBLE.get()), target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)target.m_20206_() / 2.0, target.m_20182_().f_82481_, 20, 0.08, 0.08, 0.08, 0.15);
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() != 1) {
            return;
        }
        super.addHeldAttributeModifiers(instance, entity);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        List list;
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        Level level = entity.m_9236_();
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12031_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:starved_corrosion"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (heldTicks % 10 == 0 && !(list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(5.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
            for (LivingEntity target : list) {
                if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.corrosion((Entity)entity), entity, instance), 5.0f) || !target.m_21224_()) continue;
                if (!target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
                    List<ManasSkillInstance> targetSkills = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(skillInstance -> StarvedSkill.canGain(skillInstance.getSkill())).toList();
                    for (ManasSkillInstance targetInstance : targetSkills) {
                        SkillPlunderEvent event;
                        if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)target, (Entity)entity, false, targetInstance.getSkill()))) || !SkillUtils.learnSkill(entity, event.getSkill(), instance.getRemoveTime()) || !(entity instanceof Player)) continue;
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                }
                if (instance.isTemporarySkill()) continue;
                CompoundTag tag = instance.getOrCreateTag();
                if (tag.m_128441_("predationList")) {
                    String targetID;
                    predationList = (CompoundTag)tag.m_128423_("predationList");
                    if (predationList == null || predationList.m_128441_(targetID = EntityType.m_20613_((EntityType)target.m_6095_()).toString())) continue;
                    predationList.m_128379_(targetID, true);
                } else {
                    predationList = new CompoundTag();
                    predationList.m_128379_(EntityType.m_20613_((EntityType)target.m_6095_()).toString(), true);
                    tag.m_128365_("predationList", (Tag)predationList);
                }
                if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER)) continue;
                double EP = Math.min(SkillUtils.getEPGain(target, entity), (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get());
                if (target instanceof Player) {
                    Player playerTarget = (Player)target;
                    if (TensuraGameRules.canEpSteal(target.m_9236_())) {
                        int minEP = TensuraGameRules.getMinEp(level);
                        if (minEP > 0) {
                            EP -= (double)minEP;
                        }
                        if (EP <= 0.0) continue;
                        SkillHelper.gainMaxMP(entity, EP / 4.0);
                        SkillHelper.gainMaxAP(entity, EP / 4.0);
                        TensuraEPCapability.setSkippingEPDrop(target, true);
                        SkillHelper.gainMP(entity, EP / 4.0, false);
                        SkillHelper.gainAP(entity, EP / 4.0, false);
                        TensuraPlayerCapability.getFrom(playerTarget).ifPresent(cap -> {
                            cap.setBaseMagicule((double)minEP / 2.0, (LivingEntity)playerTarget);
                            cap.setBaseAura((double)minEP / 2.0, (LivingEntity)playerTarget);
                        });
                        TensuraPlayerCapability.sync(playerTarget);
                    }
                } else {
                    SkillHelper.gainMaxMP(entity, EP / 4.0);
                    SkillHelper.gainMaxAP(entity, EP / 4.0);
                    TensuraEPCapability.setSkippingEPDrop(target, true);
                    SkillHelper.gainMP(entity, EP / 4.0, false);
                    SkillHelper.gainAP(entity, EP / 4.0, false);
                    SkillHelper.reduceEP(target, entity, 1.0, true, true);
                }
                tag.m_128347_("storedMP", tag.m_128459_("storedMP") + EP / 4.0);
                tag.m_128347_("storedAP", tag.m_128459_("storedAP") + EP / 4.0);
                instance.markDirty();
            }
        }
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 2: {
                this.openSpatialStorage(entity, instance);
                break;
            }
            case 3: {
                LivingEntity living2 = SkillHelper.getTargetingEntity(entity, 5.0, false);
                if (living2 == null || !living2.m_6084_()) {
                    return;
                }
                if (!SkillHelper.isSubordinate(entity, living2)) {
                    return;
                }
                if (living2.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
                    return;
                }
                List<ManasSkillInstance> collection = SkillAPI.getSkillsFrom((Entity)living2).getLearnedSkills().stream().filter(sub -> StarvedSkill.canGain(sub.getSkill())).toList();
                for (ManasSkillInstance targetInstance : collection) {
                    SkillPlunderEvent event;
                    if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)living2, (Entity)entity, false, targetInstance.getSkill()))) || !SkillUtils.learnSkill(entity, event.getSkill(), instance.getRemoveTime())) continue;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175828_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() / 2.0, entity.m_20189_(), 20, 0.08, 0.08, 0.08, 0.15);
                }
                break;
            }
            case 4: {
                SkillHelper.comingSoonMessage(entity, "Provide");
                break;
            }
            case 5: {
                if (!(entity instanceof Player)) {
                    return;
                }
                Player player = (Player)entity;
                if (player.m_36341_()) {
                    List list = player.m_9236_().m_6443_(Mob.class, player.m_20191_().m_82400_(15.0), living -> SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)living));
                    if (list.isEmpty()) {
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
                        return;
                    }
                    int command = tag.m_128451_("command");
                    command = command == 4 ? 1 : command + 1;
                    tag.m_128405_("command", command);
                    for (Mob mob : list) {
                        MutableComponent message = switch (command) {
                            default -> {
                                SkillHelper.setStay((LivingEntity)mob);
                                if (mob.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get())) {
                                    mob.m_21195_((MobEffect)TensuraMobEffects.RAMPAGE.get());
                                }
                                yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.stay");
                            }
                            case 2 -> {
                                SkillHelper.setFollow((LivingEntity)mob);
                                if (mob.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get())) {
                                    mob.m_21195_((MobEffect)TensuraMobEffects.RAMPAGE.get());
                                }
                                yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.follow");
                            }
                            case 3 -> {
                                SkillHelper.setWander((LivingEntity)mob);
                                if (mob.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get())) {
                                    mob.m_21195_((MobEffect)TensuraMobEffects.RAMPAGE.get());
                                }
                                yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.wander");
                            }
                            case 4 -> {
                                SkillHelper.setWander((LivingEntity)mob);
                                SkillHelper.addEffectWithSource((LivingEntity)mob, entity, new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), 6000, 0, true, false), false);
                                yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.rampage");
                            }
                        };
                        player.m_21011_(InteractionHand.MAIN_HAND, true);
                        player.m_5661_((Component)message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    break;
                }
                ThoughtCommunicationSkill.movementTelepathy(instance, entity);
            }
        }
    }

    public static boolean canGain(ManasSkill manasSkill) {
        if (!(manasSkill instanceof Skill)) {
            return false;
        }
        Skill skill = (Skill)manasSkill;
        return !skill.getType().equals((Object)Skill.SkillType.UNIQUE) && !skill.getType().equals((Object)Skill.SkillType.ULTIMATE);
    }

    @Override
    public void openSpatialStorage(LivingEntity entity, ManasSkillInstance instance) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        Optional gluttonyOptional = storage.getSkill((ManasSkill)UniqueSkills.GLUTTONY.get());
        if (gluttonyOptional.isPresent()) {
            ManasSkillInstance gluttony = (ManasSkillInstance)gluttonyOptional.get();
            this.moveItemsToSpatialStorage(instance, gluttony, entity, true);
            return;
        }
        ISpatialStorage.super.openSpatialStorage(entity, instance);
    }

    @Override
    @NotNull
    public SpatialStorageContainer getSpatialStorage(ManasSkillInstance instance) {
        SpatialStorageContainer container = new SpatialStorageContainer(54, 128);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }
}

