/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.common.ThoughtCommunicationSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;

public class SpearheadSkill
extends Skill {
    public SpearheadSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 30000.0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return this.isInSlot(entity);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(20.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity target : list) {
            target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.SPEARHEAD.get(), 240, instance.isMastered(entity) ? 1 : 0, false, false, false), (Entity)entity);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.m_36341_()) {
            List list = player.m_9236_().m_6443_(Mob.class, player.m_20191_().m_82400_(20.0), living -> SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)living));
            if (list.isEmpty()) {
                player.m_5661_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
                return;
            }
            CompoundTag tag = instance.getOrCreateTag();
            int command = tag.m_128451_("command");
            command = command == 4 ? 1 : command + 1;
            tag.m_128405_("command", command);
            for (Mob mob : list) {
                MutableComponent message = switch (command) {
                    default -> {
                        SkillHelper.setStay((LivingEntity)mob);
                        TensuraEffectsCapability.setEffectSource((LivingEntity)mob, null, (MobEffect)TensuraMobEffects.SPEARHEAD.get());
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.stay");
                    }
                    case 2 -> {
                        SkillHelper.setFollow((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.follow");
                    }
                    case 3 -> {
                        SkillHelper.setWander((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.wander");
                    }
                    case 4 -> {
                        SkillHelper.setFollow((LivingEntity)mob);
                        SkillHelper.addEffectWithSource((LivingEntity)mob, entity, (MobEffect)TensuraMobEffects.SPEARHEAD.get(), 6000, instance.isMastered(entity) ? 1 : 0, true);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.meat_shield");
                    }
                };
                player.m_21011_(InteractionHand.MAIN_HAND, true);
                player.m_5661_((Component)message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            ThoughtCommunicationSkill.movementTelepathy(instance, entity);
        }
    }

    @Override
    public void onSubordinateDeath(ManasSkillInstance instance, LivingEntity owner, LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            return;
        }
        if (entity instanceof Player && !entity.m_9236_().m_6106_().m_5466_()) {
            return;
        }
        List<ManasSkillInstance> targetSkills = List.copyOf(SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills().stream().filter(skillInstance -> this.canCollect(skillInstance.getSkill())).toList());
        if (targetSkills.isEmpty()) {
            return;
        }
        for (ManasSkillInstance targetInstance : targetSkills) {
            SkillPlunderEvent event;
            if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)entity, (Entity)owner, true, targetInstance.getSkill()))) || !SkillUtils.learnSkill(owner, event.getSkill(), instance.getRemoveTime())) continue;
            SkillAPI.getSkillsFrom((Entity)entity).forgetSkill(event.getSkill());
            this.addMasteryPoint(instance, owner);
            if (!(owner instanceof Player)) continue;
            Player player = (Player)owner;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_fallen", (Object[])new Object[]{event.getSkill().getName(), entity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    public boolean canCollect(ManasSkill manasSkill) {
        if (!(manasSkill instanceof Skill)) {
            return false;
        }
        Skill skill = (Skill)manasSkill;
        return !skill.getType().equals((Object)Skill.SkillType.ULTIMATE);
    }
}

