/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class SlothSkill
extends Skill {
    public SlothSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 100000.0;
    }

    @Override
    public int getMaxMastery() {
        return 1500;
    }

    @Override
    public double learningCost() {
        return 5000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public int modes() {
        return 6;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 6 -> 5;
                case 5 -> 4;
                case 4 -> 3;
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (instance.isMastered(entity)) {
                        yield 6;
                    }
                    yield 5;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 5 -> {
                if (instance.isMastered(entity)) {
                    yield 6;
                }
                yield 1;
            }
            case 4 -> 5;
            case 3 -> 4;
            case 2 -> 3;
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.sloth.deep_hypno");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.sloth.fallen_hypno");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.sloth.deprive");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.sloth.rest");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.sloth.phantasmal_strike");
            case 6 -> Component.m_237115_((String)"tensura.skill.mode.sloth.fallen_strike");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 3 -> 100.0;
            case 6 -> 5000.0;
            default -> 0.0;
        };
    }

    @Override
    public String modeLearningId(int mode) {
        return switch (mode) {
            case 5 -> "phantasmalStrike";
            case 6 -> "fallenStrike";
            default -> "None";
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        return instance.getMode() != 5 && instance.getMode() != 6;
    }

    @Override
    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.SLEEP_MODE.get())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.REST.get())) {
            return true;
        }
        return super.canInteractSkill(instance, entity);
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity entity, LivingHurtEvent event) {
        if (!instance.isToggled()) {
            return;
        }
        if (instance.getOrCreateTag().m_128451_("phantasmalStrike") < 100) {
            return;
        }
        if (DamageSourceHelper.isPhysicalAttack(event.getSource())) {
            LivingEntity target = event.getEntity();
            double bonus = instance.isMastered(entity) ? target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * 0.01 : 0.0;
            DamageSourceHelper.directSpiritualHurt(target, (Entity)entity, 10.0f + (float)bonus);
            if (!target.m_6084_()) {
                event.setCanceled(true);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 5 || instance.getMode() == 6) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                int duration;
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 10.0, false);
                if (target == null) break;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return false;
                    }
                }
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12268_, SoundSource.PLAYERS, 1.0f, 1.0f);
                int i = 0;
                int originalDuration = instance.isMastered(entity) ? 200 : 100;
                MobEffectInstance drowsiness = target.m_21124_((MobEffect)TensuraMobEffects.DROWSINESS.get());
                if (drowsiness != null && heldTicks > 0) {
                    duration = drowsiness.m_19557_() + 2;
                    i = (duration - originalDuration) / (200 + 100 * MobEffectHelper.getSpiritualResistLevel(target));
                } else {
                    duration = originalDuration;
                }
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.DROWSINESS.get(), duration, i, false, false, false, true);
                break;
            }
            case 2: {
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (heldTicks % 10 == 0) {
                    TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:fallen_hypno"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
                }
                float radius = instance.isMastered(entity) ? 10.0f : 5.0f;
                List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
                if (list.isEmpty()) break;
                if (heldTicks % 100 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                for (LivingEntity target : list) {
                    int duration;
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) continue;
                    }
                    int i = 0;
                    int originalDuration = instance.isMastered(entity) ? 200 : 100;
                    MobEffectInstance drowsiness = target.m_21124_((MobEffect)TensuraMobEffects.DROWSINESS.get());
                    if (drowsiness != null && heldTicks > 0) {
                        duration = drowsiness.m_19557_() + 2;
                        i = (duration - originalDuration) / (400 + 100 * MobEffectHelper.getSpiritualResistLevel(target));
                    } else {
                        duration = originalDuration;
                    }
                    SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.DROWSINESS.get(), duration, i, false, false, false, true);
                }
                break;
            }
            case 3: {
                boolean mastered = instance.isMastered(entity);
                double radius = mastered ? 15.0 : 5.0;
                LivingEntity target = SkillHelper.getTargetingEntity(entity, radius, false);
                if (target == null || heldTicks % 20 != 0) break;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return false;
                    }
                }
                if (heldTicks <= 0 || !SkillHelper.drainMP(target, entity, 1000.0, false)) break;
                if (mastered) {
                    SkillHelper.drainMP(target, entity, 0.003, true);
                }
                double bonus = mastered ? target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * 0.01 : 0.0;
                DamageSourceHelper.directSpiritualHurt(target, (Entity)entity, 10.0f + (float)bonus);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (heldTicks % 200 == 0) {
                    this.addMasteryPoint(instance, entity);
                }
                if (!target.m_6084_() || !(TensuraEPCapability.getSpiritualHealth(target) > 0.0) || !(TensuraEPCapability.getSpiritualHealth(target) < (double)(target.m_21233_() / 2.0f)) || !CharmSkill.canMindControl(target, level)) break;
                UUID uuid = entity.m_20148_();
                TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                    if (!Objects.equals(cap.getTemporaryOwner(), uuid)) {
                        cap.setTemporaryOwner(uuid);
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (target instanceof TamableAnimal) {
                                TamableAnimal animal = (TamableAnimal)target;
                                animal.m_21828_(player);
                            } else if (target instanceof TensuraHorseEntity) {
                                TensuraHorseEntity horse = (TensuraHorseEntity)target;
                                horse.m_30637_(player);
                            }
                        }
                        TensuraEPCapability.sync(target);
                        entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123750_);
                        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                });
                break;
            }
            case 4: {
                Player player;
                if (entity instanceof Player && (player = (Player)entity).m_36341_()) {
                    return false;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.REST.get(), 5, 0, false, false, false));
                if (heldTicks % 20 != 0) break;
                entity.m_5634_(instance.isMastered(entity) ? 10.0f + entity.m_21233_() * 0.01f : 10.0f);
                float healSHP = instance.isMastered(entity) ? 10.0f + (float)(entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * (double)0.01f) : 10.0f;
                TensuraEPCapability.healSpiritualHealth(entity, healSHP);
                if (!(entity instanceof Player)) break;
                Player player2 = (Player)entity;
                TensuraPlayerCapability.getFrom(player2).ifPresent(cap -> {
                    double maxMP = player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                    if (cap.getMagicule() >= maxMP) {
                        double mana = SkillHelper.mpRegen((LivingEntity)player2, maxMP, 2.0);
                        CompoundTag tag = instance.getOrCreateTag();
                        tag.m_128347_("storedMagicule", tag.m_128459_("storedMagicule") + mana);
                        instance.markDirty();
                    }
                });
            }
        }
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 4: {
                Player player;
                if (entity instanceof Player && !(player = (Player)entity).m_36341_()) {
                    return;
                }
                List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
                if (list.isEmpty()) {
                    return;
                }
                if (this.outOfStoredMP(entity, instance, 1000 * list.size())) {
                    return;
                }
                for (LivingEntity ally : list) {
                    ally.m_5634_(50.0f);
                    TensuraEPCapability.healSpiritualHealth(ally, 10.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)ally, (ParticleOptions)ParticleTypes.f_123750_, 1.0);
                    if (!(ally instanceof Player)) continue;
                    Player player2 = (Player)ally;
                    TensuraPlayerCapability.getFrom(player2).ifPresent(cap -> {
                        double maxMP = player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                        if (cap.getMagicule() != maxMP) {
                            double newMana = cap.getMagicule() + 1000.0;
                            cap.setMagicule(cap.getMagicule() > maxMP ? newMana : Math.min(newMana, maxMP));
                        }
                        double maxAP = player2.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                        if (cap.getAura() != maxAP) {
                            double newAura = cap.getAura() + 1000.0;
                            cap.setAura(cap.getAura() > maxAP ? newAura : Math.min(newAura, maxAP));
                        }
                    });
                    TensuraPlayerCapability.sync(player2);
                }
                break;
            }
            case 5: {
                int learnPoint = tag.m_128451_("phantasmalStrike");
                if (learnPoint >= 100) break;
                tag.m_128405_("phantasmalStrike", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (tag.m_128451_("phantasmalStrike") >= 100) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    } else {
                        instance.setCoolDown(10);
                        SkillUtils.learningFailPenalty(entity);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                    }
                    player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                instance.markDirty();
                break;
            }
            case 6: {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                int learnPoint = tag.m_128451_("fallenStrike");
                if (learnPoint < 100) {
                    tag.m_128405_("fallenStrike", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("fallenStrike") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(6)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(6)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    return;
                }
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 8.0, false);
                if (target == null) {
                    return;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                DamageSourceHelper.directSpiritualHurt(target, (Entity)entity, 500.0f, 0.0f);
                instance.setCoolDown(10);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123765_, 1.0);
            }
        }
    }

    private boolean outOfStoredMP(LivingEntity entity, ManasSkillInstance skillInstance, double cost) {
        CompoundTag tag = skillInstance.getOrCreateTag();
        double newStored = tag.m_128459_("storedMagicule") - cost;
        if (newStored >= 0.0) {
            tag.m_128347_("storedMagicule", newStored);
            skillInstance.markDirty();
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return false;
        }
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

