/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.projectile.SevererBladeProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SevererSkill
extends Skill {
    public SevererSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double learningCost() {
        return 200.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.severer.sword");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.severer.blade_storm");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.severer.severance");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 3 -> 200.0;
            case 2 -> 2000.0;
            case 1 -> 100.0;
            default -> 0.0;
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                if (entity.m_21205_().m_41619_()) {
                    this.spawnDummySword(instance, entity, InteractionHand.MAIN_HAND);
                    break;
                }
                if (!entity.m_21206_().m_41619_()) break;
                this.spawnDummySword(instance, entity, InteractionHand.OFF_HAND);
                break;
            }
            case 2: {
                ItemStack spatialBlade = null;
                if (entity.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)TensuraToolItems.SPATIAL_BLADE.get())) {
                    spatialBlade = entity.m_21120_(InteractionHand.MAIN_HAND);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                } else if (entity.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)TensuraToolItems.SPATIAL_BLADE.get())) {
                    spatialBlade = entity.m_21120_(InteractionHand.OFF_HAND);
                    entity.m_21011_(InteractionHand.OFF_HAND, true);
                }
                if (spatialBlade == null) {
                    if (entity.m_21205_().m_41619_()) {
                        this.spawnDummySword(instance, entity, InteractionHand.MAIN_HAND);
                    }
                    return;
                }
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 1 : 3);
                int arrowAmount = instance.isMastered(entity) ? 10 : 5;
                this.spawnSeveranceBlade(entity, spatialBlade, instance, arrowAmount);
                break;
            }
            case 3: {
                if (entity.m_21023_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get())) {
                    return;
                }
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                int severance = instance.isMastered(entity) ? 2 : 0;
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get(), 2400, severance, false, false, false));
            }
        }
    }

    private void spawnDummySword(ManasSkillInstance instance, LivingEntity entity, InteractionHand hand) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        ItemStack blade = new ItemStack((ItemLike)TensuraToolItems.SPATIAL_BLADE.get());
        blade.m_41784_().m_128379_("dummy", true);
        blade.m_41663_((Enchantment)TensuraEnchantments.SEVERANCE.get(), instance.isMastered(entity) ? 10 : 5);
        entity.m_21008_(hand, blade);
        entity.m_21011_(hand, true);
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void spawnSeveranceBlade(LivingEntity entity, ItemStack stack, ManasSkillInstance instance, int arrowAmount) {
        int arrowRot = 360 / arrowAmount;
        for (int i = 0; i < arrowAmount; ++i) {
            Vec3 arrowOffset = new Vec3(0.0, 1.0, 0.0).m_82535_(((float)(arrowRot * i) - (float)arrowRot / 2.0f) * ((float)Math.PI / 180));
            Vec3 arrowPos = entity.m_146892_().m_82549_(entity.m_20154_().m_82541_().m_82490_(1.0)).m_82549_(arrowOffset.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180)));
            SevererBladeProjectile blade = new SevererBladeProjectile(entity.m_9236_(), entity, stack);
            blade.m_146884_(arrowPos);
            blade.setOwnerOffset(arrowOffset);
            blade.setLookDistance(instance.isMastered(entity) ? 30.0f : 20.0f);
            blade.setDelayTick(20);
            entity.m_9236_().m_7967_((Entity)blade);
            entity.f_19853_.m_6263_(null, arrowPos.m_7096_(), arrowPos.m_7098_(), arrowPos.m_7094_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

