/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class SeerSkill
extends Skill {
    protected static final UUID SEER = UUID.fromString("5aa90ead-4edc-4a45-b93f-2293ee00a577");

    public SeerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 20000.0;
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        boolean futureVision = entity.m_21023_((MobEffect)TensuraMobEffects.FUTURE_VISION.get());
        if (!instance.isToggled() && !futureVision) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_()) {
            return;
        }
        if (damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_()) {
            return;
        }
        if (!futureVision) {
            float f = entity.m_217043_().m_188501_();
            float f2 = instance.isMastered(entity) ? 0.7f : 0.5f;
            if (f > f2) {
                return;
            }
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
        if (SkillUtils.canNegateDodge(entity, damageSource)) {
            event.setCanceled(false);
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        boolean futureVision = entity.m_21023_((MobEffect)TensuraMobEffects.FUTURE_VISION.get());
        if (!instance.isToggled() && !futureVision) {
            return;
        }
        if (SkillUtils.isProjectileAlwaysHit(event.getProjectile())) {
            return;
        }
        if (!futureVision) {
            float f = entity.m_217043_().m_188501_();
            float f2 = instance.isMastered(entity) ? 0.7f : 0.5f;
            if (f > f2) {
                return;
            }
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (!instance.isToggled()) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_()) {
            return;
        }
        if (damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_()) {
            return;
        }
        float multiplier = instance.isMastered(entity) ? 0.5f : 0.7f;
        event.setAmount(event.getAmount() * multiplier);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 2.0f, 1.0f);
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance chance = entity.m_21051_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get());
        if (chance == null) {
            return;
        }
        int amount = instance.isMastered(entity) ? 50 : 33;
        AttributeModifier attributemodifier = new AttributeModifier(SEER, "Precognition", (double)amount, AttributeModifier.Operation.ADDITION);
        if (!chance.m_22109_(attributemodifier)) {
            chance.m_22125_(attributemodifier);
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance chance = entity.m_21051_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get());
        if (chance != null) {
            chance.m_22127_(SEER);
        }
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return entity.m_21023_((MobEffect)TensuraMobEffects.FUTURE_VISION.get());
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.FUTURE_VISION.get())) {
            entity.m_21195_((MobEffect)TensuraMobEffects.FUTURE_VISION.get());
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
            instance.setCoolDown(10);
        } else {
            int duration = instance.isMastered(entity) ? 400 : 200;
            instance.setCoolDown(instance.isMastered(entity) ? 30 : 20);
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FUTURE_VISION.get(), duration, 0, false, false, false));
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return entity.m_21023_((MobEffect)TensuraMobEffects.FUTURE_VISION.get());
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 6 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
    }
}

