/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;

public class PrideSkill
extends Skill {
    public PrideSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 100000.0;
    }

    @Override
    public int getMaxMastery() {
        return 1500;
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        ManasSkill manasSkill;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (instance.onCoolDown()) {
            return;
        }
        if (!this.isInSlot(entity)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_()) {
            return;
        }
        if (damageSource.m_7639_() != null && damageSource.m_7639_().m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            return;
        }
        if (!(damageSource instanceof TensuraDamageSource)) {
            return;
        }
        TensuraDamageSource source = (TensuraDamageSource)damageSource;
        if ((double)source.getIgnoreBarrier() >= 1.75) {
            return;
        }
        ManasSkillInstance targetInstance = source.getSkill();
        if (targetInstance == null || targetInstance.isTemporarySkill() || targetInstance.getSkill() == this) {
            return;
        }
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        ManasSkill skill = targetInstance.getSkill();
        int chance = this.copyChance(entity, instance, skill);
        if (entity.m_217043_().m_188503_(100) >= chance) {
            if (chance != 0 && !SkillUtils.hasSkill((Entity)entity, skill)) {
                this.addMasteryPoint(instance, entity);
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return;
        }
        SkillPlunderEvent plunderEvent = new SkillPlunderEvent(source.m_7639_(), (Entity)entity, false, skill);
        if (MinecraftForge.EVENT_BUS.post((Event)plunderEvent)) {
            return;
        }
        if (!SkillUtils.learnSkill(entity, plunderEvent.getSkill(), instance.getRemoveTime())) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{plunderEvent.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(plunderEvent.getSkill());
                if (optional.isEmpty()) {
                    return;
                }
                if (cap.getSkillInSlot(0) == null) {
                    cap.setInstanceInSlot((ManasSkillInstance)optional.get(), 0);
                } else if (cap.getSkillInSlot(1) == null) {
                    cap.setInstanceInSlot((ManasSkillInstance)optional.get(), 1);
                } else if (cap.getSkillInSlot(2) == null) {
                    cap.setInstanceInSlot((ManasSkillInstance)optional.get(), 2);
                }
                TensuraSkillCapability.sync(player);
            });
        }
        if ((manasSkill = plunderEvent.getSkill()) instanceof TensuraSkill) {
            TensuraSkill tensuraSkill = (TensuraSkill)manasSkill;
            double mastery = tensuraSkill.getObtainingEpCost() / 10000.0;
            this.addMasteryPoint(instance, entity, (int)(mastery + (double)SkillUtils.getBonusMasteryPoint(instance, entity, (int)mastery)));
            instance.setCoolDown(Math.max((int)(360.0 * mastery), 1));
        } else {
            this.addMasteryPoint(instance, entity);
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215778_, SoundSource.PLAYERS, 2.0f, 1.0f);
    }

    private int copyChance(LivingEntity owner, ManasSkillInstance pride, ManasSkill targetSkill) {
        if (this.cantCopy(targetSkill)) {
            return 0;
        }
        if (pride.isMastered(owner)) {
            return 100;
        }
        return 25;
    }

    private boolean cantCopy(ManasSkill manasSkill) {
        Skill skill;
        if (manasSkill instanceof SpiritualMagic) {
            return true;
        }
        return manasSkill instanceof Skill && (skill = (Skill)manasSkill).getType().equals((Object)Skill.SkillType.ULTIMATE);
    }
}

