/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.AbsorbDissolveSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.breath.PredatorMistProjectile;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PredatorSkill
extends Skill
implements ISpatialStorage {
    public PredatorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 50000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    @Override
    public int modes() {
        return 5;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 5 : instance.getMode() - 1;
        }
        return instance.getMode() == 5 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.predator.predation");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.predator.analysis");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.predator.stomach");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.predator.mimicry");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.predator.isolation");
            default -> Component.m_237119_();
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMode() == 1 && entity.m_6144_();
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (storage.getSkill((ManasSkill)UniqueSkills.STARVED.get()).isEmpty()) {
            return;
        }
        ManasSkill skill = (ManasSkill)UniqueSkills.GLUTTONY.get();
        if (SkillUtils.learnSkill(entity, skill) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                ManasSkillInstance gluttony;
                if (entity.m_6144_() && entity instanceof Player) {
                    int newMode;
                    Player player = (Player)entity;
                    switch (tag.m_128451_("blockMode")) {
                        case 1: {
                            newMode = 2;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.blocks", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            break;
                        }
                        case 2: {
                            newMode = 3;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.fluid", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            break;
                        }
                        case 3: {
                            newMode = 4;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.all", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            break;
                        }
                        default: {
                            newMode = 1;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.none", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                        }
                    }
                    tag.m_128405_("blockMode", newMode);
                    instance.markDirty();
                    break;
                }
                PredatorMistProjectile breath = new PredatorMistProjectile(entity.m_9236_(), entity);
                breath.setLength(3.0f);
                breath.setBlockMode(instance.getOrCreateTag().m_128451_("blockMode"));
                if (instance.isMastered(entity)) {
                    breath.setConsumeProjectile(true);
                }
                breath.setSkill((gluttony = this.getGluttony(entity)) != null ? gluttony : instance);
                breath.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() * 0.7, 0.0));
                entity.m_9236_().m_7967_((Entity)breath);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                this.addMasteryPoint(instance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                break;
            }
            case 2: {
                SkillHelper.comingSoonMessage(entity, "Analysis");
                break;
            }
            case 3: {
                this.openSpatialStorage(entity, instance);
                break;
            }
            case 4: {
                SkillHelper.comingSoonMessage(entity, "Mimicry");
                break;
            }
            case 5: {
                ItemStack itemStack = entity.m_21205_();
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                if (itemStack.m_41619_()) {
                    boolean success;
                    LivingEntity living = SkillHelper.getTargetingEntity(entity, 3.0, false);
                    if (living != null) {
                        success = TensuraEffectsCapability.getSeverance(living) > 0.0;
                        TensuraEffectsCapability.getFrom(living).ifPresent(cap -> cap.setSeveranceAmount(0.0));
                        Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
                        boolean bl = success = success || SkillHelper.removePredicateEffect(living, predicate, this.magiculeCost(entity, instance));
                        if (success) {
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)living, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
                        }
                    } else {
                        success = TensuraEffectsCapability.getSeverance(entity) > 0.0;
                        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> cap.setSeveranceAmount(0.0));
                        Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
                        boolean bl = success = success || SkillHelper.removePredicateEffect(entity, predicate, this.magiculeCost(entity, instance));
                        if (success) {
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
                        }
                    }
                    if (!success) break;
                    instance.setCoolDown(instance.isMastered(entity) ? 5 : 3);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                for (AbsorbDissolveSkill.Dissolving dissolving : AbsorbDissolveSkill.Dissolving.values()) {
                    if (!dissolving.getItem().equals(itemStack.m_41720_())) continue;
                    this.addMasteryPoint(instance, entity);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        if (itemStack.m_41720_().equals(TensuraMaterialItems.SLIME_IN_A_BUCKET.get())) {
                            TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.TRAITOR);
                        }
                        serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                    }
                    itemStack.m_41774_(1);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                            double magicule = cap.getMagicule();
                            double max = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                            double newMagicule = magicule + (double)(dissolving.getMagicule() * 2);
                            cap.setMagicule(magicule > max ? newMagicule : Math.min(max, newMagicule));
                        });
                    }
                    if (dissolving.getHeal() > 0.0f) {
                        entity.m_5634_(dissolving.getHeal());
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                break;
            }
        }
    }

    private ManasSkillInstance getGluttony(LivingEntity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        Optional gluttonyOptional = storage.getSkill((ManasSkill)UniqueSkills.GLUTTONY.get());
        return gluttonyOptional.orElse(null);
    }

    @Override
    public void openSpatialStorage(LivingEntity entity, ManasSkillInstance instance) {
        ManasSkillInstance gluttony = this.getGluttony(entity);
        if (gluttony != null) {
            this.moveItemsToSpatialStorage(instance, gluttony, entity, true);
        } else {
            ISpatialStorage.super.openSpatialStorage(entity, instance);
        }
    }

    @Override
    @NotNull
    public SpatialStorageContainer getSpatialStorage(ManasSkillInstance instance) {
        SpatialStorageContainer container = new SpatialStorageContainer(63, 128);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }
}

