/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class OppressorSkill
extends Skill {
    public OppressorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 20000.0;
    }

    @Override
    public double learningCost() {
        return 500.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity);
    }

    @Override
    public int modes() {
        return 5;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 5 : instance.getMode() - 1;
        }
        return instance.getMode() == 5 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.oppressor.repel");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.oppressor.attract");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.oppressor.oppress");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.oppressor.bleve");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.oppressor.flicker");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1, 2, 5 -> 50.0;
            case 4 -> 1000.0;
            default -> 0.0;
        };
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity entity, UnlockSkillEvent event) {
        if (instance.getMastery() < 0 || instance.isTemporarySkill()) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)ExtraSkills.GRAVITY_MANIPULATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!instance.isToggled() || !this.isMastered(instance, event.getEntity())) {
            return;
        }
        if (event.getSource().m_146707_()) {
            event.setCanceled(true);
        } else if (event.getSource().m_19360_() && !event.getSource().m_19387_()) {
            event.setCanceled(true);
        }
    }

    public boolean onHeld(ManasSkillInstance skillInstance, LivingEntity entity, int heldTicks) {
        if (skillInstance.getMode() == 4 || skillInstance.getMode() == 3) {
            return false;
        }
        CompoundTag tag = skillInstance.getOrCreateTag();
        switch (skillInstance.getMode()) {
            case 1: {
                Entity target = SkillHelper.getTargetingEntity(entity, 10.0, 0.5, false, true);
                if (target == null) break;
                TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)ParticleTypes.f_123760_, 1.0);
                break;
            }
            case 2: {
                Entity target = SkillHelper.getTargetingEntity(entity, 30.0, 0.5, false, true);
                if (target == null) break;
                TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)ParticleTypes.f_123760_, 1.0);
            }
        }
        if (!tag.m_128471_("masteryPower")) {
            tag.m_128405_("scale", heldTicks);
        }
        if (tag.m_128451_("scale") > 100) {
            tag.m_128405_("scale", 100);
        }
        skillInstance.markDirty();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.power_scale", (Object[])new Object[]{(double)tag.m_128451_("scale") / 10.0}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), true);
        }
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        switch (instance.getMode()) {
            case 3: {
                LivingEntity target = SkillHelper.getTargetingEntity(LivingEntity.class, entity, 20.0, 0.0, false);
                if (target == null) {
                    return;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (target.m_21023_((MobEffect)TensuraMobEffects.OPPRESSION.get())) {
                    if (SkillHelper.outOfMagicule(entity, 700.0)) {
                        return;
                    }
                    instance.addMasteryPoint(entity);
                    instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.oppression((Entity)entity), entity, instance), instance.isMastered(entity) ? 200.0f : 100.0f);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
                    break;
                }
                if (SkillHelper.outOfMagicule(entity, 300.0)) {
                    return;
                }
                instance.addMasteryPoint(entity);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                DamageSourceHelper.markHurt(target, (Entity)entity);
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.OPPRESSION.get(), 600, 0, false, false, false, true);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123790_, 1.0);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 4: {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                LivingEntity target = SkillHelper.getTargetingEntity(LivingEntity.class, entity, 20.0, 0.0, false);
                if (target == null) {
                    return;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                instance.addMasteryPoint(entity);
                instance.setCoolDown(instance.isMastered(entity) ? 5 : 10);
                target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.oppressionBleve((Entity)entity), entity, instance), 100.0f);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123812_, 1.0);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                target.m_20256_(target.m_20184_().m_82520_(0.0, 2.0, 0.0));
                target.f_19864_ = true;
            }
        }
    }

    public void onRelease(ManasSkillInstance skillInstance, LivingEntity entity, int heldTicks) {
        if (!this.isHeld(entity)) {
            return;
        }
        CompoundTag tag = skillInstance.getOrCreateTag();
        switch (skillInstance.getMode()) {
            case 1: {
                Entity target;
                if (tag.m_128451_("scale") <= 0) {
                    return;
                }
                if (!SkillHelper.outOfMagicule(entity, skillInstance) && (target = SkillHelper.getTargetingEntity(entity, 10.0, 0.5, false, true)) != null) {
                    double scale;
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            this.resetScale(skillInstance, entity);
                            return;
                        }
                    }
                    if ((scale = (double)tag.m_128451_("scale") / -15.0) >= 2.0) {
                        skillInstance.addMasteryPoint(entity);
                    }
                    TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)ParticleTypes.f_175829_, 1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)ParticleTypes.f_175829_, 1.0);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    Vec3 vec3 = new Vec3(entity.m_20185_() - target.m_20185_(), entity.m_20186_() - target.m_20186_(), entity.m_20189_() - target.m_20189_()).m_82490_(1.0 / (double)target.m_20270_((Entity)entity));
                    target.m_20256_(vec3.m_82541_().m_82490_(scale));
                    target.f_19864_ = true;
                }
                this.resetScale(skillInstance, entity);
                break;
            }
            case 2: {
                Entity target;
                if (tag.m_128451_("scale") <= 0) {
                    return;
                }
                if (!SkillHelper.outOfMagicule(entity, skillInstance) && (target = SkillHelper.getTargetingEntity(entity, 30.0, 0.5, false, true)) != null) {
                    double scale;
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            this.resetScale(skillInstance, entity);
                            return;
                        }
                    }
                    if ((scale = (double)tag.m_128451_("scale") / 15.0) >= 2.0) {
                        skillInstance.addMasteryPoint(entity);
                    }
                    TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)ParticleTypes.f_175829_, 1.0);
                    TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)ParticleTypes.f_175829_, 1.0);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    Vec3 vec3 = new Vec3(entity.m_20185_() - target.m_20185_(), entity.m_20186_() - target.m_20186_(), entity.m_20189_() - target.m_20189_()).m_82490_(1.0 / (double)target.m_20270_((Entity)entity));
                    target.m_20256_(vec3.m_82541_().m_82490_(scale));
                    target.f_19864_ = true;
                }
                this.resetScale(skillInstance, entity);
                break;
            }
            case 5: {
                if (tag.m_128451_("scale") <= 0) {
                    return;
                }
                if (!SkillHelper.outOfMagicule(entity, skillInstance)) {
                    float scale = (float)tag.m_128451_("scale") / 10.0f;
                    if (scale >= 2.0f) {
                        skillInstance.addMasteryPoint(entity);
                    }
                    if (entity.m_20202_() != null) {
                        TensuraParticleHelper.addServerParticlesAroundSelf(entity.m_20202_(), (ParticleOptions)ParticleTypes.f_123812_, 0.5);
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        SkillHelper.riptidePushVehicle(entity.m_20202_(), entity, scale);
                        entity.m_20202_().f_19864_ = true;
                        entity.m_20202_().f_19812_ = true;
                    } else {
                        SkillHelper.riptidePush(entity, scale);
                        entity.f_19864_ = true;
                        entity.f_19812_ = true;
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123812_, 1.0);
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
                this.resetScale(skillInstance, entity);
            }
        }
    }

    public void onRespawn(ManasSkillInstance instance, PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        instance.getOrCreateTag().m_128379_("masteryPower", false);
        instance.markDirty();
    }

    @Override
    public void onNumberKeyPress(ManasSkillInstance instance, Player player, int keyNumber) {
        if (!instance.isMastered((LivingEntity)player)) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        if (keyNumber == 0) {
            if (tag.m_128471_("masteryPower")) {
                tag.m_128379_("masteryPower", false);
                tag.m_128405_("scale", 10);
                instance.markDirty();
            }
            return;
        }
        if (!tag.m_128471_("masteryPower")) {
            tag.m_128379_("masteryPower", true);
        }
        tag.m_128405_("scale", keyNumber * 10 + 10);
        instance.markDirty();
    }

    private void resetScale(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isMastered(entity)) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128405_("scale", 0);
        instance.markDirty();
    }
}

